/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.soap.impl.unmarshaller;

import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.Environment;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.StackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.StackContextFactory;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class FaultStackContext
extends StackContext {
    private Exception _fault;
    private final Environment _env;
    private static final String _faultElement = "fault";
    private static final String _locMsgElement = "localizedMessage";

    public FaultStackContext(VmodlField field, VmodlType type, StackContext parent, Environment env) {
        super(field, type, parent);
        this._env = env;
    }

    @Override
    public void setValue(Object value) throws UnmarshallException {
        throw new UnmarshallException(String.format("Fault contains illegal content: '%1$s'", value));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setChildValue(VmodlField field, Object value) throws UnmarshallException {
        if (field.getName().equals(_faultElement)) {
            if (!(value instanceof MethodFault) && !(value instanceof RuntimeFault)) throw new UnmarshallException(String.format("Unsupported child value for field '%1$s'. Field must be of type MethodFault or RuntimeFault", field.getName()));
            this._fault = (Exception)value;
            return;
        } else {
            if (!field.getName().equals(_locMsgElement)) throw new UnmarshallException(String.format("Unsupported child value for field '%1$s'", field.getName()));
            if (this._fault == null) {
                throw new UnmarshallException(String.format("Unsupported child value for field '%1$s'. Fault cannot be null", field.getName()));
            }
            if (this._fault instanceof MethodFault) {
                ((MethodFault)this._fault).setMessage((String)value);
                return;
            } else {
                if (!(this._fault instanceof RuntimeFault)) return;
                ((RuntimeFault)this._fault).setMessage((String)value);
            }
        }
    }

    @Override
    public Object getValue() {
        return this._fault;
    }

    @Override
    public void close() throws UnmarshallException {
        if (this.getParentContext() != null) {
            this.getParentContext().setChildValue(this.getField(), this._fault);
        }
    }

    @Override
    public StackContext getNestedContext(QName name2, Map<QName, String> attrs, NamespaceContext namespaces) throws UnmarshallException {
        if (name2.getLocalPart().equals(_faultElement)) {
            return StackContextFactory.newContext(this, new FaultField(_faultElement, this.getField(), this.getField().getType()), name2, attrs, namespaces, this._env);
        }
        if (name2.getLocalPart().equals(_locMsgElement)) {
            return StackContextFactory.newContext(this, new FaultField(_locMsgElement, this.getField(), this._env.getTypeMap().getVmodlType(String.class)), name2, attrs, namespaces, this._env);
        }
        throw new UnmarshallException(String.format("Unsupported nested context '%1$s'. Supported contexts are '%2$s' or '%3$s'", name2, _faultElement, _locMsgElement));
    }

    static class FaultField
    implements VmodlField {
        private String _name;
        private VmodlField _field;
        private VmodlType _type;

        public FaultField(String name2, VmodlField faultField, VmodlType type) {
            this._name = name2;
            this._field = faultField;
            this._type = type;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getWsdlName() {
            return this._name;
        }

        @Override
        public VmodlType getType() {
            return this._type;
        }

        @Override
        public VmodlVersion getVersion() {
            return this._field.getVersion();
        }

        @Override
        public String GetPrivilegeId() {
            return this._field.GetPrivilegeId();
        }

        @Override
        public boolean isOptional() {
            return this._field.isOptional();
        }

        @Override
        public VmodlType getManagedObjectType() {
            return this._field.getManagedObjectType();
        }

        @Override
        public boolean isLink() {
            return this._field.isLink();
        }

        @Override
        public boolean isLinkable() {
            return this._field.isLinkable();
        }

        @Override
        public boolean isVisible(VmodlVersion version) {
            return this._field.isVisible(version);
        }

        @Override
        public VmodlType getLinkType() {
            return this._field.getLinkType();
        }

        @Override
        public boolean isSecret() {
            return this._field.isSecret();
        }

        @Override
        public VmodlField.CollectionType getCollectionType() {
            return this._field.getCollectionType();
        }
    }
}

