/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.tracing;

import com.vmware.vim.vmomi.core.tracing.GlobalTracer;
import io.opentracing.Tracer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TracingFeature {
    public static final boolean ON;
    private static final Log _logger;

    private TracingFeature() {
    }

    private static boolean isTracingOn() {
        try {
            if (!_logger.isTraceEnabled()) {
                _logger.info((Object)"OpenTracing logger (com.vmware.vim.vmomi.core.tracing) is not enabled at TRACE level. Tracing data will not be reported.");
                return false;
            }
            Tracer tracer = GlobalTracer.get();
            _logger.info((Object)("Tracing is enabled:" + tracer));
            return true;
        }
        catch (Exception | NoClassDefFoundError e) {
            _logger.info((Object)"VLSI tracing is off");
            _logger.debug((Object)"Failed to initialize tracing", e);
            return false;
        }
    }

    static {
        _logger = LogFactory.getLog(TracingFeature.class);
        ON = TracingFeature.isTracingOn();
    }
}

