/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.util;

import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.types.ComplexType;
import com.vmware.vim.vmomi.core.types.ComplexTypeField;
import com.vmware.vim.vmomi.core.types.VmodlArrayType;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class EqualityUtil {
    private static final String KEY_PROP_NAME = "key";

    public static boolean areEqual(DataObject left, DataObject right, VmodlContext context) {
        return EqualityUtil.areComplexTypeEqual(left, right, context);
    }

    public static boolean areEqual(DataObject left, DataObject right) {
        return EqualityUtil.areEqual(left, right, VmodlContext.getContext());
    }

    public static boolean areEqual(Object left, Object right, VmodlContext context) {
        return EqualityUtil.areEqual(left, right, null, null, context);
    }

    public static boolean areEqual(Object left, Object right) {
        return EqualityUtil.areEqual(left, right, VmodlContext.getContext());
    }

    public static boolean areEqual(Object left, Object right, VmodlField.CollectionType collectionType, VmodlContext context) {
        return EqualityUtil.areEqual(left, right, null, collectionType, context);
    }

    public static boolean areEqual(Object left, Object right, VmodlField.CollectionType collectionType) {
        return EqualityUtil.areEqual(left, right, collectionType, VmodlContext.getContext());
    }

    static boolean areEqual(Object left, Object right, VmodlType type, VmodlField.CollectionType collectionType, VmodlContext context) {
        if (left == right) {
            return true;
        }
        if (left == null ^ right == null) {
            return EqualityUtil.checkForEmptyArray(left, right, type, context);
        }
        if (left.getClass() != right.getClass()) {
            return false;
        }
        if (type == null || type.getKind() == VmodlType.Kind.ANY) {
            type = EqualityUtil.resolveDynamicType(left, context.getVmodlTypeMap());
        }
        switch (type.getKind()) {
            case ARRAY: {
                VmodlArrayType arrType = (VmodlArrayType)type;
                if (collectionType == VmodlField.CollectionType.MAP) {
                    if (!EqualityUtil.isKeyedCollection(arrType)) {
                        throw new RuntimeException("Map not allowed for non keyed collection with element type: " + arrType.getComponentType());
                    }
                    return EqualityUtil.areKeyedArraysEqual(left, right, arrType.getComponentType(), context);
                }
                if (collectionType == VmodlField.CollectionType.SET) {
                    return EqualityUtil.areSetArraysEqual(left, right, arrType.getComponentType(), context);
                }
                if (collectionType == VmodlField.CollectionType.LIST) {
                    return EqualityUtil.areArraysEqual(left, right, arrType.getComponentType(), context);
                }
                if (EqualityUtil.isKeyedCollection(arrType)) {
                    return EqualityUtil.areKeyedArraysEqual(left, right, arrType.getComponentType(), context);
                }
                return EqualityUtil.areArraysEqual(left, right, arrType.getComponentType(), context);
            }
            case DATA_OBJECT: 
            case FAULT: {
                return EqualityUtil.areComplexTypeEqual(left, right, context);
            }
            case MANAGED_OBJECT: {
                return ((ManagedObject)left)._getRef().equals(((ManagedObject)right)._getRef());
            }
            case BOOL: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case DATETIME: 
            case METHOD_NAME: 
            case TYPE_NAME: 
            case MOREF: 
            case PROPERTY_PATH: 
            case URI: 
            case ENUM: 
            case BINARY: {
                return left.equals(right);
            }
        }
        throw new RuntimeException("Unexpected VmodlType: " + (Object)((Object)type.getKind()));
    }

    static boolean areComplexTypeEqual(Object left, Object right, VmodlContext context) {
        ComplexTypeField[] props;
        if (left == right) {
            return true;
        }
        if (left == null ^ right == null) {
            return false;
        }
        if (left.getClass() != right.getClass()) {
            return false;
        }
        ComplexType doType = (ComplexType)EqualityUtil.resolveDynamicType(left, context.getVmodlTypeMap());
        for (ComplexTypeField prop : props = doType.getProperties()) {
            ComplexTypeField field = doType.getProperty(prop.getName());
            if (EqualityUtil.areEqual(field.get(left), field.get(right), field.getType(), field.getCollectionType(), context)) continue;
            return false;
        }
        return true;
    }

    static boolean areKeyedEqual(int[] left, int[] right) {
        if (left.length != right.length) {
            return false;
        }
        int[] l = Arrays.copyOf(left, left.length);
        int[] r = Arrays.copyOf(right, right.length);
        Arrays.sort(l);
        Arrays.sort(r);
        return Arrays.equals(l, r);
    }

    static <T> boolean areKeyedEqual(T[] left, T[] right) {
        if (left.length != right.length) {
            return false;
        }
        HashSet<T> leftSet = new HashSet<T>(Arrays.asList(left));
        for (int i = 0; i < right.length; ++i) {
            if (leftSet.remove(right[i])) continue;
            return false;
        }
        return true;
    }

    static boolean areKeyedEqual(DataObject[] left, DataObject[] right, VmodlContext context) {
        if (left.length != right.length) {
            return false;
        }
        HashMap<Object, DataObject> leftMap = new HashMap<Object, DataObject>();
        for (DataObject dataObj : left) {
            leftMap.put(EqualityUtil.fetchKeyProperty(dataObj, context), dataObj);
        }
        for (DataObject dataObj : right) {
            Object key = EqualityUtil.fetchKeyProperty(dataObj, context);
            DataObject leftDataObj = (DataObject)leftMap.remove(key);
            if (leftDataObj == null) {
                return false;
            }
            if (EqualityUtil.areComplexTypeEqual(leftDataObj, dataObj, context)) continue;
            return false;
        }
        return true;
    }

    static Object fetchKeyProperty(DataObject keyedDo, VmodlContext context) {
        ComplexType doType = (ComplexType)EqualityUtil.resolveDynamicType(keyedDo, context.getVmodlTypeMap());
        return doType.getProperty(KEY_PROP_NAME).get(keyedDo);
    }

    static boolean areSetEqual(DataObject[] left, DataObject[] right, VmodlContext context) {
        int j;
        boolean found;
        int i;
        if (left.length != right.length) {
            return false;
        }
        ArrayList<DataObject> leftList = new ArrayList<DataObject>();
        for (i = 0; i < left.length; ++i) {
            found = false;
            for (j = 0; j < leftList.size(); ++j) {
                if (!EqualityUtil.areEqual(left[i], (DataObject)leftList.get(j), context)) continue;
                found = true;
                break;
            }
            if (found) continue;
            leftList.add(left[i]);
        }
        for (i = 0; i < right.length; ++i) {
            found = false;
            for (j = 0; j < leftList.size(); ++j) {
                if (!EqualityUtil.areEqual(right[i], (DataObject)leftList.get(j), context)) continue;
                leftList.remove(j);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    static boolean areKeyedArraysEqual(Object left, Object right, VmodlType compType, VmodlContext context) {
        if (left.getClass() != right.getClass()) {
            return false;
        }
        switch (compType.getKind()) {
            case DATA_OBJECT: {
                return EqualityUtil.areKeyedEqual((DataObject[])left, (DataObject[])right, context);
            }
            case INT: {
                return EqualityUtil.areKeyedEqual((int[])left, (int[])right);
            }
            case STRING: {
                return EqualityUtil.areKeyedEqual((String[])left, (String[])right);
            }
            case MOREF: {
                return EqualityUtil.areKeyedEqual((ManagedObjectReference[])left, (ManagedObjectReference[])right);
            }
            case MANAGED_OBJECT: {
                return EqualityUtil.areKeyedEqual(EqualityUtil.fetchMoRefs(left), EqualityUtil.fetchMoRefs(right));
            }
        }
        throw new RuntimeException("Unexpected array component type for keyed collection: " + (Object)((Object)compType.getKind()));
    }

    static boolean areSetArraysEqual(Object left, Object right, VmodlType compType, VmodlContext context) {
        if (left.getClass() != right.getClass()) {
            return false;
        }
        switch (compType.getKind()) {
            case INT: {
                return EqualityUtil.areKeyedEqual((int[])left, (int[])right);
            }
            case DATA_OBJECT: {
                return EqualityUtil.areSetEqual((DataObject[])left, (DataObject[])right, context);
            }
            case STRING: {
                return EqualityUtil.areKeyedEqual((String[])left, (String[])right);
            }
            case MOREF: {
                return EqualityUtil.areKeyedEqual((ManagedObjectReference[])left, (ManagedObjectReference[])right);
            }
            case MANAGED_OBJECT: {
                return EqualityUtil.areKeyedEqual(EqualityUtil.fetchMoRefs(left), EqualityUtil.fetchMoRefs(right));
            }
        }
        throw new RuntimeException("areSetArraysEqual not yet implemented for collection of type: " + (Object)((Object)compType.getKind()));
    }

    static boolean areArraysEqual(Object left, Object right, VmodlType compType, VmodlContext context) {
        if (left.getClass() != right.getClass()) {
            return false;
        }
        switch (compType.getKind()) {
            case BYTE: {
                return Arrays.equals((byte[])left, (byte[])right);
            }
            case SHORT: {
                return Arrays.equals((short[])left, (short[])right);
            }
            case INT: {
                return Arrays.equals((int[])left, (int[])right);
            }
            case LONG: {
                return Arrays.equals((long[])left, (long[])right);
            }
            case FLOAT: {
                return Arrays.equals((float[])left, (float[])right);
            }
            case DOUBLE: {
                return Arrays.equals((double[])left, (double[])right);
            }
            case BOOL: {
                return Arrays.equals((boolean[])left, (boolean[])right);
            }
            case DATA_OBJECT: 
            case FAULT: {
                return EqualityUtil.areComplexTypeArraysEqual(left, right, compType, context);
            }
            case MANAGED_OBJECT: {
                return Arrays.equals(EqualityUtil.fetchMoRefs(left), EqualityUtil.fetchMoRefs(right));
            }
            case ARRAY: 
            case STRING: 
            case DATETIME: 
            case METHOD_NAME: 
            case TYPE_NAME: 
            case MOREF: 
            case PROPERTY_PATH: 
            case URI: 
            case ENUM: 
            case BINARY: {
                return Arrays.equals((Object[])left, (Object[])right);
            }
            case ANY: {
                Object[] leftArray = (Object[])left;
                Object[] rightArray = (Object[])right;
                if (leftArray.length != rightArray.length) {
                    return false;
                }
                for (int i = 0; i < leftArray.length; ++i) {
                    if (EqualityUtil.areEqual(leftArray[i], rightArray[i], context)) continue;
                    return false;
                }
                return true;
            }
        }
        throw new RuntimeException("Unexpected array component VmodlType: " + (Object)((Object)compType.getKind()));
    }

    static boolean areComplexTypeArraysEqual(Object left, Object right, VmodlType compType, VmodlContext context) {
        if (Array.getLength(left) != Array.getLength(right)) {
            return false;
        }
        for (int i = 0; i < Array.getLength(left); ++i) {
            if (EqualityUtil.areComplexTypeEqual(Array.get(left, i), Array.get(right, i), context)) continue;
            return false;
        }
        return true;
    }

    static boolean checkForEmptyArray(Object left, Object right, VmodlType type, VmodlContext context) {
        Object nonNull;
        Object object = nonNull = left == null ? right : left;
        if (type == null || type.getKind() == VmodlType.Kind.ANY) {
            type = EqualityUtil.resolveDynamicType(nonNull, context.getVmodlTypeMap());
        }
        if (type.getKind() == VmodlType.Kind.ARRAY) {
            return Array.getLength(nonNull) == 0;
        }
        return false;
    }

    static boolean isKeyedCollection(VmodlArrayType type) {
        VmodlType compType = type.getComponentType();
        switch (compType.getKind()) {
            case DATA_OBJECT: {
                ComplexTypeField keyProperty = ((ComplexType)compType).getProperty(KEY_PROP_NAME);
                if (keyProperty != null) {
                    switch (keyProperty.getType().getKind()) {
                        case MANAGED_OBJECT: 
                        case INT: 
                        case STRING: 
                        case MOREF: {
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
            case MANAGED_OBJECT: 
            case INT: 
            case STRING: 
            case MOREF: {
                return true;
            }
        }
        return false;
    }

    static VmodlType resolveDynamicType(Object any, VmodlTypeMap typeMap) {
        VmodlType dynamicType = typeMap.getDynamicVmodlType(any);
        if (dynamicType == null) {
            throw new RuntimeException(String.format("Unable to determine dynamic type of '%1$s'", any.getClass()));
        }
        return dynamicType;
    }

    static ManagedObjectReference[] fetchMoRefs(Object moArray) {
        ManagedObject[] casted = (ManagedObject[])moArray;
        ManagedObjectReference[] result = new ManagedObjectReference[casted.length];
        for (int i = 0; i < casted.length; ++i) {
            result[i] = casted[i]._getRef();
        }
        return result;
    }
}

