/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.asm.attrs;

import java.util.ArrayList;
import java.util.List;
import net.sf.cglib.asm.ByteVector;
import net.sf.cglib.asm.ClassReader;
import net.sf.cglib.asm.ClassWriter;
import net.sf.cglib.asm.Type;

public class Annotation {
    public String type;
    public List elementValues = new ArrayList();

    public Annotation() {
    }

    public Annotation(String string) {
        this.type = string;
    }

    public void add(String string, Object object) {
        this.elementValues.add(new Object[]{string, object});
    }

    public int read(ClassReader classReader, int n, char[] cArray) {
        this.type = classReader.readUTF8(n, cArray);
        int n2 = classReader.readUnsignedShort(n + 2);
        int[] nArray = new int[]{n += 4};
        for (int i = 0; i < n2; ++i) {
            String string = classReader.readUTF8(nArray[0], cArray);
            nArray[0] = nArray[0] + 2;
            this.elementValues.add(new Object[]{string, Annotation.readValue(classReader, nArray, cArray)});
        }
        return nArray[0];
    }

    public void write(ByteVector byteVector, ClassWriter classWriter) {
        byteVector.putShort(classWriter.newUTF8(this.type));
        byteVector.putShort(this.elementValues.size());
        for (int i = 0; i < this.elementValues.size(); ++i) {
            Object[] objectArray = (Object[])this.elementValues.get(i);
            byteVector.putShort(classWriter.newUTF8((String)objectArray[0]));
            Annotation.writeValue(byteVector, objectArray[1], classWriter);
        }
    }

    public static int readAnnotations(List list, ClassReader classReader, int n, char[] cArray) {
        int n2 = classReader.readUnsignedShort(n);
        n += 2;
        for (int i = 0; i < n2; ++i) {
            Annotation annotation = new Annotation();
            n = annotation.read(classReader, n, cArray);
            list.add(annotation);
        }
        return n;
    }

    public static void readParameterAnnotations(List list, ClassReader classReader, int n, char[] cArray) {
        int n2 = classReader.b[n++] & 0xFF;
        for (int i = 0; i < n2; ++i) {
            ArrayList arrayList = new ArrayList();
            n = Annotation.readAnnotations(arrayList, classReader, n, cArray);
            list.add(arrayList);
        }
    }

    public static ByteVector writeAnnotations(ByteVector byteVector, List list, ClassWriter classWriter) {
        byteVector.putShort(list.size());
        for (int i = 0; i < list.size(); ++i) {
            ((Annotation)list.get(i)).write(byteVector, classWriter);
        }
        return byteVector;
    }

    public static ByteVector writeParametersAnnotations(ByteVector byteVector, List list, ClassWriter classWriter) {
        byteVector.putByte(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Annotation.writeAnnotations(byteVector, (List)list.get(i), classWriter);
        }
        return byteVector;
    }

    public static String stringAnnotations(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                stringBuffer.append('\n').append(list.get(i));
            }
        } else {
            stringBuffer.append("<none>");
        }
        return stringBuffer.toString();
    }

    public static String stringParameterAnnotations(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            stringBuffer.append(string).append(Annotation.stringAnnotations((List)list.get(i)));
            string = ", ";
        }
        return stringBuffer.toString();
    }

    protected static Object readValue(ClassReader classReader, int[] nArray, char[] cArray) {
        Object[] objectArray = null;
        int n = nArray[0];
        nArray[0] = n + 1;
        int n2 = classReader.readByte(n);
        block0 : switch (n2) {
            case 68: 
            case 70: 
            case 73: 
            case 74: {
                objectArray = classReader.readConst(classReader.readUnsignedShort(nArray[0]), cArray);
                nArray[0] = nArray[0] + 2;
                break;
            }
            case 66: {
                objectArray = new Byte((byte)classReader.readInt(classReader.getItem(classReader.readUnsignedShort(nArray[0]))));
                nArray[0] = nArray[0] + 2;
                break;
            }
            case 67: {
                objectArray = new Character((char)classReader.readInt(classReader.getItem(classReader.readUnsignedShort(nArray[0]))));
                nArray[0] = nArray[0] + 2;
                break;
            }
            case 83: {
                objectArray = new Short((short)classReader.readInt(classReader.getItem(classReader.readUnsignedShort(nArray[0]))));
                nArray[0] = nArray[0] + 2;
                break;
            }
            case 90: {
                objectArray = classReader.readInt(classReader.getItem(classReader.readUnsignedShort(nArray[0]))) == 0 ? Boolean.FALSE : Boolean.TRUE;
                nArray[0] = nArray[0] + 2;
                break;
            }
            case 115: {
                objectArray = classReader.readUTF8(nArray[0], cArray);
                nArray[0] = nArray[0] + 2;
                break;
            }
            case 101: {
                objectArray = new EnumConstValue(classReader.readUTF8(nArray[0], cArray), classReader.readUTF8(nArray[0] + 2, cArray));
                nArray[0] = nArray[0] + 4;
                break;
            }
            case 99: {
                objectArray = Type.getType(classReader.readUTF8(nArray[0], cArray));
                nArray[0] = nArray[0] + 2;
                break;
            }
            case 64: {
                objectArray = new Annotation();
                nArray[0] = ((Annotation)objectArray).read(classReader, nArray[0], cArray);
                break;
            }
            case 91: {
                Object[] objectArray2;
                int n3 = classReader.readUnsignedShort(nArray[0]);
                nArray[0] = nArray[0] + 2;
                int n4 = classReader.readByte(nArray[0]);
                switch (n4) {
                    case 73: {
                        int[] nArray2 = new int[n3];
                        for (int i = 0; i < n3; ++i) {
                            nArray[0] = nArray[0] + 1;
                            nArray2[i] = classReader.readInt(classReader.getItem(classReader.readUnsignedShort(nArray[0])));
                            nArray[0] = nArray[0] + 2;
                        }
                        objectArray = nArray2;
                        break block0;
                    }
                    case 74: {
                        long[] lArray = new long[n3];
                        for (int i = 0; i < n3; ++i) {
                            nArray[0] = nArray[0] + 1;
                            lArray[i] = classReader.readLong(classReader.getItem(classReader.readUnsignedShort(nArray[0])));
                            nArray[0] = nArray[0] + 2;
                        }
                        objectArray = lArray;
                        break block0;
                    }
                    case 68: {
                        double[] dArray = new double[n3];
                        for (int i = 0; i < n3; ++i) {
                            nArray[0] = nArray[0] + 1;
                            dArray[i] = Double.longBitsToDouble(classReader.readLong(classReader.getItem(classReader.readUnsignedShort(nArray[0]))));
                            nArray[0] = nArray[0] + 2;
                        }
                        objectArray = dArray;
                        break block0;
                    }
                    case 70: {
                        float[] fArray = new float[n3];
                        for (int i = 0; i < n3; ++i) {
                            nArray[0] = nArray[0] + 1;
                            fArray[i] = Float.intBitsToFloat(classReader.readInt(classReader.getItem(classReader.readUnsignedShort(nArray[0]))));
                            nArray[0] = nArray[0] + 2;
                        }
                        objectArray = fArray;
                        break block0;
                    }
                    case 66: {
                        byte[] byArray = new byte[n3];
                        for (int i = 0; i < n3; ++i) {
                            nArray[0] = nArray[0] + 1;
                            byArray[i] = (byte)classReader.readInt(classReader.getItem(classReader.readUnsignedShort(nArray[0])));
                            nArray[0] = nArray[0] + 2;
                        }
                        objectArray = byArray;
                        break block0;
                    }
                    case 67: {
                        char[] cArray2 = new char[n3];
                        for (int i = 0; i < n3; ++i) {
                            nArray[0] = nArray[0] + 1;
                            cArray2[i] = (char)classReader.readInt(classReader.getItem(classReader.readUnsignedShort(nArray[0])));
                            nArray[0] = nArray[0] + 2;
                        }
                        objectArray = cArray2;
                        break block0;
                    }
                    case 83: {
                        short[] sArray = new short[n3];
                        for (int i = 0; i < n3; ++i) {
                            nArray[0] = nArray[0] + 1;
                            sArray[i] = (short)classReader.readInt(classReader.getItem(classReader.readUnsignedShort(nArray[0])));
                            nArray[0] = nArray[0] + 2;
                        }
                        objectArray = sArray;
                        break block0;
                    }
                    case 90: {
                        boolean[] blArray = new boolean[n3];
                        for (int i = 0; i < n3; ++i) {
                            nArray[0] = nArray[0] + 1;
                            blArray[i] = classReader.readInt(classReader.getItem(classReader.readUnsignedShort(nArray[0]))) != 0;
                            nArray[0] = nArray[0] + 2;
                        }
                        objectArray = blArray;
                        break block0;
                    }
                }
                objectArray = objectArray2 = new Object[n3];
                for (int i = 0; i < n3; ++i) {
                    objectArray2[i] = Annotation.readValue(classReader, nArray, cArray);
                }
                break;
            }
        }
        return objectArray;
    }

    protected static ByteVector writeValue(ByteVector byteVector, Object object, ClassWriter classWriter) {
        if (object instanceof String) {
            byteVector.putByte(115);
            byteVector.putShort(classWriter.newUTF8((String)object));
        } else if (object instanceof EnumConstValue) {
            byteVector.putByte(101);
            byteVector.putShort(classWriter.newUTF8(((EnumConstValue)object).typeName));
            byteVector.putShort(classWriter.newUTF8(((EnumConstValue)object).constName));
        } else if (object instanceof Type) {
            byteVector.putByte(99);
            byteVector.putShort(classWriter.newUTF8(((Type)object).getDescriptor()));
        } else if (object instanceof Annotation) {
            byteVector.putByte(64);
            ((Annotation)object).write(byteVector, classWriter);
        } else if (object instanceof Object[]) {
            byteVector.putByte(91);
            Object[] objectArray = (Object[])object;
            byteVector.putShort(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                Annotation.writeValue(byteVector, objectArray[i], classWriter);
            }
        } else if (object instanceof byte[]) {
            byteVector.putByte(91);
            byte[] byArray = (byte[])object;
            byteVector.putShort(byArray.length);
            for (int i = 0; i < byArray.length; ++i) {
                byteVector.putByte(66);
                byteVector.putShort(classWriter.newConstInt(byArray[i]));
            }
        } else if (object instanceof short[]) {
            byteVector.putByte(91);
            short[] sArray = (short[])object;
            byteVector.putShort(sArray.length);
            for (int i = 0; i < sArray.length; ++i) {
                byteVector.putByte(83);
                byteVector.putShort(classWriter.newConstInt(sArray[i]));
            }
        } else if (object instanceof int[]) {
            byteVector.putByte(91);
            int[] nArray = (int[])object;
            byteVector.putShort(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                byteVector.putByte(73);
                byteVector.putShort(classWriter.newConstInt(nArray[i]));
            }
        } else if (object instanceof char[]) {
            byteVector.putByte(91);
            char[] cArray = (char[])object;
            byteVector.putShort(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                byteVector.putByte(67);
                byteVector.putShort(classWriter.newConstInt(cArray[i]));
            }
        } else if (object instanceof boolean[]) {
            byteVector.putByte(91);
            boolean[] blArray = (boolean[])object;
            byteVector.putShort(blArray.length);
            for (int i = 0; i < blArray.length; ++i) {
                byteVector.putByte(90);
                byteVector.putShort(classWriter.newConstInt(blArray[i] ? 1 : 0));
            }
        } else if (object instanceof long[]) {
            byteVector.putByte(91);
            long[] lArray = (long[])object;
            byteVector.putShort(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                byteVector.putByte(74);
                byteVector.putShort(classWriter.newConstLong(lArray[i]));
            }
        } else if (object instanceof float[]) {
            byteVector.putByte(91);
            float[] fArray = (float[])object;
            byteVector.putShort(fArray.length);
            for (int i = 0; i < fArray.length; ++i) {
                byteVector.putByte(70);
                byteVector.putShort(classWriter.newConstFloat(fArray[i]));
            }
        } else if (object instanceof double[]) {
            byteVector.putByte(91);
            double[] dArray = (double[])object;
            byteVector.putShort(dArray.length);
            for (int i = 0; i < dArray.length; ++i) {
                byteVector.putByte(68);
                byteVector.putShort(classWriter.newConstDouble(dArray[i]));
            }
        } else {
            int n = -1;
            if (object instanceof Integer) {
                n = 73;
            } else if (object instanceof Byte) {
                n = 66;
            } else if (object instanceof Character) {
                n = 67;
            } else if (object instanceof Double) {
                n = 68;
            } else if (object instanceof Float) {
                n = 70;
            } else if (object instanceof Long) {
                n = 74;
            } else if (object instanceof Short) {
                n = 83;
            } else if (object instanceof Boolean) {
                n = 90;
            }
            byteVector.putByte(n);
            byteVector.putShort(classWriter.newConst(object));
        }
        return byteVector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("@").append(this.type);
        if (this.elementValues.size() > 0) {
            stringBuffer.append(" ( ");
            String string = "";
            for (int i = 0; i < this.elementValues.size(); ++i) {
                Object[] objectArray = (Object[])this.elementValues.get(i);
                if (this.elementValues.size() != 1 && !"value".equals(this.elementValues.get(0))) {
                    stringBuffer.append(string).append(objectArray[0]).append(" = ");
                }
                if (objectArray[1] instanceof Object[]) {
                    Object[] objectArray2 = (Object[])objectArray[1];
                    stringBuffer.append("{");
                    String string2 = "";
                    for (int j = 0; j < objectArray2.length; ++j) {
                        stringBuffer.append(string2).append(objectArray2[j]);
                        string2 = ", ";
                    }
                    stringBuffer.append("}");
                } else {
                    stringBuffer.append(objectArray[1]);
                }
                string = ", ";
            }
            stringBuffer.append(" )");
        }
        return stringBuffer.toString();
    }

    public static class EnumConstValue {
        public String typeName;
        public String constName;

        public EnumConstValue(String string, String string2) {
            this.typeName = string;
            this.constName = string2;
        }

        public String toString() {
            return this.typeName + ":" + this.constName;
        }
    }
}

