/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.engine;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.topology.impl.core.engine.Context;
import com.vmware.srm.client.topology.impl.core.engine.GraphIterator;
import com.vmware.srm.client.topology.impl.core.engine.Node;
import com.vmware.srm.client.topology.impl.core.engine.Traversal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Graph<T extends Context> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Graph.class);
    private static final String LOGGER_ALL_NODES_SUFFIX = "Graph.AllNodes";
    private static final Logger LOGGER_ALL_NODES = LoggerFactory.getLogger((String)"Graph.AllNodes");
    private final Node<T> _bootstrap;
    private volatile Map<Node<T>, Set<Node<T>>> _currentNeighbourByNode = new HashMap<Node<T>, Set<Node<T>>>();
    private AtomicReference<Traversal<T>> _traversalRef = new AtomicReference<Object>(null);
    private final AtomicBoolean _disposed = new AtomicBoolean(false);
    private static final Traversal DISPOSED = new Traversal<Object>(null, null, null);

    public Graph(Node<T> bootstrap) {
        Validate.notNull(bootstrap, (String)"bootstrap");
        this._bootstrap = bootstrap;
    }

    public Promise<Void> refresh(T context) {
        Promise<Void> result;
        Validate.notNull(context, (String)"context");
        Traversal<T> traversal = new Traversal<T>(this, this._bootstrap, context);
        if (!this._traversalRef.compareAndSet(null, traversal)) {
            if (this._traversalRef.get() == DISPOSED) {
                return Promises.reject((Exception)new IllegalStateException("Graph is disposed."));
            }
            return Promises.reject((Exception)new IllegalStateException("Ongoing traversal."));
        }
        if (this._disposed.get()) {
            this.tryDispose(traversal);
            return Promises.reject((Exception)new IllegalStateException("Graph is disposed."));
        }
        LOGGER.trace("Starting traversal '{}'.", traversal);
        try {
            result = traversal.start(this._currentNeighbourByNode);
        }
        catch (RuntimeException exc) {
            LOGGER.error("Traversal completed with error:", (Throwable)exc);
            this.tryDispose(traversal);
            return Promises.reject((Exception)exc);
        }
        return result.thenApply(unused -> {
            this.onTraversalComplete(traversal);
            return unused;
        }).onError(err -> {
            LOGGER.error("Traversal '{}' completed with error:", (Object)traversal, err);
            this.tryDispose(traversal);
        }).onSuccess(unused -> {
            LOGGER.trace("Traversal '{}' completed.", (Object)traversal);
            this._traversalRef.set(null);
            if (this._disposed.get()) {
                this.tryDispose(null);
            }
        });
    }

    protected void onTraversalComplete(Traversal<T> traversal) {
        Set reachableNodes = this.getAllReachableNodes(traversal.neighbourByNode);
        Set<Node<T>> removedNodes = this._currentNeighbourByNode.keySet();
        removedNodes.removeAll(reachableNodes);
        this._currentNeighbourByNode = traversal.neighbourByNode;
        this._currentNeighbourByNode.keySet().retainAll(reachableNodes);
        for (Node<T> n : removedNodes) {
            this.remove(n);
        }
        this.logGraph();
    }

    private Set<Node<T>> getAllReachableNodes(Map<Node<T>, Set<Node<T>>> neighboursByNode) {
        HashSet<Node<T>> result = new HashSet<Node<T>>();
        HashSet roots = new HashSet();
        roots.add(this._bootstrap);
        GraphIterator iter = new GraphIterator(roots, neighboursByNode);
        while (iter.hasNext()) {
            result.add((Node)iter.next());
        }
        return result;
    }

    public void dispose() {
        if (!this._disposed.compareAndSet(false, true)) {
            return;
        }
        this.tryDispose(null);
    }

    private void tryDispose(Traversal<T> current) {
        if (this._traversalRef.compareAndSet(current, DISPOSED)) {
            for (Node<T> e : this._currentNeighbourByNode.keySet()) {
                this.dispose(e);
            }
            this._currentNeighbourByNode.clear();
        }
    }

    void dispose(Node<T> node) {
        LOGGER.trace("Disposing node '{}'.", node);
        try {
            node.dispose();
        }
        catch (Exception exc) {
            LOGGER.warn("Error disposing node {}:", node, (Object)exc);
        }
    }

    void remove(Node<T> node) {
        LOGGER.trace("Removing node '{}'.", node);
        try {
            node.removed();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to do 'remove' for '{}'.", node);
        }
        this.dispose(node);
    }

    private void logGraph() {
        if (!LOGGER_ALL_NODES.isInfoEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder("Topology Graph Nodes:\n");
        this._currentNeighbourByNode.forEach((node, neighbours) -> {
            sb.append(node.toString()).append("\nNeighbours: [\n");
            neighbours.forEach(neighbour -> sb.append("  ").append(neighbour.toString().replaceAll("\n", "\n    ")).append("\n"));
            sb.append("]\n");
        });
        LOGGER_ALL_NODES.info(sb.toString());
    }
}

