/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.sso;

import com.vmware.dr.ui.tools.utilities.Disposable;
import com.vmware.dr.ui.tools.utilities.RotationManager;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.sso.DrSecurityTokenService;
import com.vmware.srm.client.topology.impl.sso.LsppRotationManagerProvider;
import com.vmware.srm.client.topology.impl.sso.SsoFacade;
import com.vmware.srm.client.topology.impl.sso.SsoUtils;
import com.vmware.srm.client.topology.impl.sso.StsProxyBase;
import com.vmware.srm.client.topology.impl.utils.Exceptions;
import com.vmware.vim.sso.client.SecurityTokenService;
import com.vmware.vim.sso.client.exception.ServerCommunicationException;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vim.vmomi.client.exception.ConnectionException;
import com.vmware.vim.vmomi.client.exception.SslException;
import com.vmware.vim.vmomi.client.exception.TransportProtocolException;
import java.lang.reflect.Method;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.CallbackHelper;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationStsProxy {
    private static Factory PROTOTYPE;
    private static CallbackHelper FILTER;
    private static final Logger LOGGER;

    public static DrSecurityTokenService create(LsppRotationManagerProvider provider) {
        return FederationStsProxy.create(provider, SsoUtils.CERT, SsoUtils.KEY_PAIR.getPrivate());
    }

    public static DrSecurityTokenService create(LsppRotationManagerProvider provider, X509Certificate certificate, PrivateKey privateKey) {
        return (DrSecurityTokenService)PROTOTYPE.newInstance(new Class[]{Object.class}, new Object[]{new Context(provider, certificate, privateKey)}, FILTER.getCallbacks());
    }

    private static boolean shouldRotate(Exception exc) {
        if (exc instanceof SslException) {
            return false;
        }
        return exc instanceof ConnectionException || exc instanceof TransportProtocolException || exc instanceof UnexpectedStatusCodeException || exc instanceof ServerCommunicationException;
    }

    static {
        FILTER = new FilterImpl();
        LOGGER = LoggerFactory.getLogger(FederationStsProxy.class);
        try {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(StsProxyBase.class);
            enhancer.setUseFactory(true);
            enhancer.setCallbackFilter((CallbackFilter)FILTER);
            enhancer.setCallbackTypes(FILTER.getCallbackTypes());
            enhancer.setCallbacks(FILTER.getCallbacks());
            PROTOTYPE = (Factory)enhancer.create(new Class[0], new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("static ctor failed: ", (Throwable)e);
        }
    }

    private static class FilterImpl
    extends CallbackHelper {
        private static final StsInterceptor STS_INTERCEPT = new StsInterceptor();
        private static final DrStsInterceptor DR_STS_INTERCEPT = new DrStsInterceptor();
        private static final DisposeInterceptor DISPOSE_INTERCEPT = new DisposeInterceptor();

        FilterImpl() {
            super(StsProxyBase.class, null);
        }

        protected Object getCallback(Method method) {
            if (SecurityTokenService.class.equals(method.getDeclaringClass())) {
                return STS_INTERCEPT;
            }
            if (DrSecurityTokenService.class.equals(method.getDeclaringClass())) {
                return DR_STS_INTERCEPT;
            }
            if (Disposable.class.equals(method.getDeclaringClass())) {
                return DISPOSE_INTERCEPT;
            }
            return NoOp.INSTANCE;
        }
    }

    private static final class DisposeInterceptor
    implements MethodInterceptor {
        private DisposeInterceptor() {
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) {
            return null;
        }
    }

    private static final class DrStsInterceptor
    implements MethodInterceptor {
        private static final Method GET_URL;
        private static final Method GET_PRIVATE_KEY;

        private DrStsInterceptor() {
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) {
            StsProxyBase base = (StsProxyBase)proxy;
            Context context = (Context)base.getContext();
            if (GET_URL.equals(method)) {
                RotationManager<LsppService> manager = context.provider.getManager();
                LsppService start = (LsppService)manager.getCurrentStart();
                return SsoUtils.getAdminEndpoint((LsppService)start).url;
            }
            if (GET_PRIVATE_KEY.equals(method)) {
                return context.key;
            }
            throw new UnsupportedOperationException(method.toString());
        }

        static {
            try {
                GET_URL = DrSecurityTokenService.class.getDeclaredMethod("getUrl", new Class[0]);
                GET_PRIVATE_KEY = DrSecurityTokenService.class.getDeclaredMethod("getPrivateKey", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    private static class StsInterceptor
    implements MethodInterceptor {
        private StsInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            StsProxyBase base = (StsProxyBase)proxy;
            Context context = (Context)base.getContext();
            block5: while (true) {
                RotationManager<LsppService> rm = context.provider.getManager();
                RotationManager.Rotation rotation = rm.create();
                while (true) {
                    try {
                        DrSecurityTokenService sts = SsoFacade.createSts((LsppService)rotation.getCurrent(), context.cert, context.key);
                        try {
                            Object object = methodProxy.invoke((Object)sts, args);
                            return object;
                        }
                        finally {
                            sts.dispose();
                        }
                    }
                    catch (Exception e) {
                        Class<?>[] declaredExceptions;
                        if (!rm.equals(context.provider.getManager())) continue block5;
                        if (FederationStsProxy.shouldRotate(e) && rotation.rotate() != null) continue;
                        Class<?>[] classArray = declaredExceptions = method.getExceptionTypes();
                        int n = classArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Class<?> ex = classArray[n2];
                            if (ex.isInstance(e)) {
                                throw e;
                            }
                            ++n2;
                        }
                        throw Exceptions.getRuntimeException(e);
                    }
                    break;
                }
                break;
            }
        }
    }

    private static final class Context {
        final LsppRotationManagerProvider provider;
        final X509Certificate cert;
        final PrivateKey key;

        Context(LsppRotationManagerProvider provider, X509Certificate cert, PrivateKey key) {
            this.provider = provider;
            this.cert = cert;
            this.key = key;
        }
    }
}

