/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.sso;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.utilities.Exceptions;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.impl.common.Utils;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.BaseLsppNode;
import com.vmware.srm.client.topology.impl.lspp.LsppNegotiator;
import com.vmware.srm.client.topology.impl.lspp.Types;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.srm.client.topology.impl.sso.SsoServiceImpl;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.VmomiServiceImpl;
import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vim.sso.client.DefaultTokenFactory;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.sso.client.util.codec.Base64;
import com.vmware.vim.vmomi.core.Future;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;

public class SsoUtils {
    public static final KeyPair KEY_PAIR;
    public static final X509Certificate CERT;
    private static final String SSO_ADMIN_POINT = "com.vmware.cis.cs.identity.admin";
    private static final String SSO_REST_POINT = "com.vmware.cis.cs.identity.sso";

    public static X509Certificate[] generateRootCertificates(String[] certArray) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        for (String c : certArray) {
            ByteArrayInputStream is = new ByteArrayInputStream(Base64.decodeBase64((String)c));
            certList.add((X509Certificate)factory.generateCertificate(is));
        }
        return certList.toArray(new X509Certificate[0]);
    }

    static SecurityTokenServiceConfig createStsConfig(URL stsUrl, X509Certificate hokCertificate, PrivateKey hokPrivateKey, X509Certificate[] stsCerts, String thumbprint, X509Certificate[] rootCerts) {
        SecurityTokenServiceConfig.HolderOfKeyConfig hokConfig = new SecurityTokenServiceConfig.HolderOfKeyConfig((Key)hokPrivateKey, hokCertificate, null);
        return SsoUtils.createStsConfig(stsUrl, stsCerts, thumbprint, rootCerts, hokConfig);
    }

    public static SecurityTokenServiceConfig createBearerStsConfig(URL stsUrl, X509Certificate[] stsCerts, String thumbprint, X509Certificate[] rootCerts) {
        return SsoUtils.createStsConfig(stsUrl, stsCerts, thumbprint, rootCerts, null);
    }

    private static SecurityTokenServiceConfig createStsConfig(URL stsUrl, X509Certificate[] stsCerts, String thumbprint, X509Certificate[] rootCerts, SecurityTokenServiceConfig.HolderOfKeyConfig hokConfig) {
        SecurityTokenServiceConfig.ConnectionConfig connConfig = new SecurityTokenServiceConfig.ConnectionConfig(stsUrl, stsCerts, thumbprint, null, false);
        return new SecurityTokenServiceConfig(connConfig, rootCerts, (ExecutorService)Utils.getExecutor(), hokConfig);
    }

    public static LsppServiceEndpoint getStsEndpoint(LsppService sso) {
        return SsoUtils.getEndpoint(sso, SSO_REST_POINT);
    }

    public static LsppServiceEndpoint getAdminEndpoint(LsppService sso) {
        return SsoUtils.getEndpoint(sso, SSO_ADMIN_POINT);
    }

    public static Promise<SamlToken> createSamlToken(String samlTokenAsXml, URI lsppUrl, String lsppThumbprint) {
        Promise<SsoServiceImpl> ssoService = SsoUtils.createSsoService(lsppUrl, lsppThumbprint);
        Promise signCerts = ssoService.thenCompose(SsoUtils::getSigningCerts);
        Promise clockTolerance = ssoService.thenCompose(SsoUtils::getClockTolerance);
        Promises.allWithException((Promise[])new Promise[]{signCerts, clockTolerance}).onSuccess(unused -> ssoService.onSuccess(VmomiServiceImpl::dispose));
        return signCerts.thenCombine(clockTolerance, (certs, tolerance) -> SsoUtils.createToken(samlTokenAsXml, certs, tolerance));
    }

    public static Promise<SamlToken> createSamlToken(String samlTokenAsXml, LsppService ssoReg) {
        Promise<SsoServiceImpl> ssoService = SsoUtils.createSsoService(ssoReg);
        Promise signCerts = ssoService.thenCompose(SsoUtils::getSigningCerts);
        Promise clockTolerance = ssoService.thenCompose(SsoUtils::getClockTolerance);
        Promises.allWithException((Promise[])new Promise[]{signCerts, clockTolerance}).onSuccess(unused -> ssoService.onSuccess(VmomiServiceImpl::dispose));
        return signCerts.thenCombine(clockTolerance, (certs, tolerance) -> SsoUtils.createToken(samlTokenAsXml, certs, tolerance));
    }

    private static SamlToken createToken(String samlTokenAsXml, X509Certificate[] signCerts, long clockTolerance) {
        try {
            return DefaultTokenFactory.createToken((String)samlTokenAsXml, (X509Certificate[])signCerts, (long)clockTolerance);
        }
        catch (InvalidTokenException e) {
            throw Exceptions.getRuntimeException((Throwable)e);
        }
    }

    public static Promise<SsoServiceImpl> createSsoService(URI lsppUrl, String lsppThumbprint) {
        return SsoUtils.createSsoService(() -> new LsppNegotiator(lsppUrl, lsppThumbprint));
    }

    public static Promise<SsoServiceImpl> createSsoService(LsppService ssoReg) {
        return SsoUtils.createSsoService(() -> BaseLsppNode.createNegotiator(ssoReg));
    }

    private static Promise<SsoServiceImpl> createSsoService(Supplier<LsppNegotiator> querySupplier) {
        LsppNegotiator query = querySupplier.get();
        Promise<Set<LsppService>> queryResult = query.query(Types.LsppType.Sso.getVmodlType());
        queryResult.materialize().onSuccess(rp -> query.close());
        return queryResult.thenApply(set -> (LsppService)set.iterator().next()).thenApply(ssoReg -> {
            KeyStore store;
            LsppServiceEndpoint ep = SsoUtils.getAdminEndpoint(ssoReg);
            try {
                store = CertificateUtils.createTrustStore(ep.getCertificates());
            }
            catch (IOException | GeneralSecurityException e) {
                throw Exceptions.getRuntimeException((Throwable)e);
            }
            return new SsoServiceImpl(ep.url, null, store, null);
        });
    }

    private static LsppServiceEndpoint getEndpoint(LsppService sso, String type) {
        if (sso == null || sso.getEndpoints() == null) {
            throw new IllegalArgumentException("sso");
        }
        for (LsppServiceEndpoint ep : sso.getEndpoints()) {
            if (!type.equals(ep.type)) continue;
            return ep;
        }
        String msg = String.format("No endpoint '%s' defined for service %s.", type, sso);
        throw new IllegalArgumentException(msg);
    }

    private static Promise<Long> getClockTolerance(SsoServiceImpl service) {
        return service.getContent().thenCompose(content -> {
            ConfigurationManagementService cms = (ConfigurationManagementService)service.createStub(content.getConfigurationManagementService());
            FuturePromise result = new FuturePromise();
            cms.getClockTolerance((Future)result);
            return result;
        });
    }

    private static Promise<X509Certificate[]> getSigningCerts(SsoServiceImpl service) {
        return service.getContent().thenCompose(content -> {
            ConfigurationManagementService cms = (ConfigurationManagementService)service.createStub(content.getConfigurationManagementService());
            FuturePromise result = new FuturePromise();
            cms.getIssuersCertificates((Future)result);
            return result;
        }).thenApply(certs -> {
            try {
                return SsoUtils.generateRootCertificates(certs);
            }
            catch (CertificateException e) {
                throw Exceptions.getRuntimeException((Throwable)e);
            }
        });
    }

    static {
        Security.addProvider((Provider)new BouncyCastleFipsProvider());
        KEY_PAIR = CertificateUtils.generateKeyPair();
        CERT = CertificateUtils.generateSelfSignedCert(KEY_PAIR);
    }
}

