/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.sso;

import com.vmware.dr.ui.tools.utilities.ExecuteOnceOpWrapper;
import com.vmware.dr.ui.tools.utilities.OperationWaiter;
import com.vmware.srm.client.topology.impl.init.Config;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.apache.commons.lang.Validate;

public final class StartupKeyStore {
    private static final StartupKeyStore STORE = new StartupKeyStore();
    private final ExecuteOnceOpWrapper<Void> _loadOp = new ExecuteOnceOpWrapper(() -> {
        this.load();
        return null;
    });
    private volatile KeyStore _keyStore;

    public static StartupKeyStore get() {
        return STORE;
    }

    private StartupKeyStore() {
    }

    public KeyStore getStore() {
        this.init();
        return this._keyStore;
    }

    public OperationWaiter<Void> ensureLoaded() {
        return this._loadOp.invoke();
    }

    private void load() throws GeneralSecurityException, IOException {
        Config config = Config.get();
        String name = config.getKeyStoreName();
        String pass = config.getKeyStorePass();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        ClassLoader loader = Config.class.getClassLoader();
        try (InputStream resStream = loader.getResourceAsStream(name);){
            Validate.notNull((Object)resStream, (String)"resStream");
            keyStore.load(resStream, pass.toCharArray());
        }
        this._keyStore = keyStore;
    }

    private void init() {
        this._loadOp.invoke().get();
    }
}

