/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.sso.external;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.PromiseResult;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.topology.impl.sso.TokenManager;
import com.vmware.srm.client.topology.impl.sso.external.ExternalTokenClient;
import com.vmware.srm.client.topology.impl.sso.external.ExternalTokenData;
import com.vmware.srm.client.topology.impl.utils.PromiseUtils;
import com.vmware.srm.client.topology.impl.utils.RefreshManager;
import com.vmware.vim.sso.client.SamlToken;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class ExternalTokenManager
extends RefreshManager<ExternalTokenClient, ExternalTokenData> {
    private static final long DEFAULT_REFRESH_EXP_TIME = 120L;
    private static final long DEFAULT_SAML_EXP_TIME = 60L;

    public ExternalTokenManager() {
        super(120L);
    }

    @Override
    protected void onRequestExists(CompletableFuture<ExternalTokenData> result) {
        result.completeExceptionally(new TokenManager.TokenRequestExists());
    }

    @Override
    protected void refreshProduct(ExternalTokenClient externalTokenClient, ExternalTokenData currentProduct, CompletableFuture<ExternalTokenData> newProductFuture) {
        externalTokenClient.refreshToken(currentProduct.refreshToken, newProductFuture);
    }

    @Override
    protected Date getExpirationTime(ExternalTokenData externalTokenData) {
        return externalTokenData.expirationTime;
    }

    public Promise<SamlToken> acquireToken(ExternalTokenClient extClient, ExternalTokenData tokenData) {
        return PromiseUtils.toPromise(this.getProduct(extClient, (client, future) -> {
            if (!this.isTokenExpired(tokenData.samlToken)) {
                future.complete(tokenData);
                return;
            }
            client.refreshToken(tokenData.refreshToken, (CompletableFuture<ExternalTokenData>)future);
        })).thenApply(td -> td.samlToken);
    }

    public Promise<SamlToken> getToken(ExternalTokenClient client) {
        CompletableFuture future = this.getCurrentRequestFor(client);
        if (future == null) {
            return Promises.resolve(null);
        }
        return PromiseUtils.toPromise(future).thenCompose(tokenData -> {
            if (!this.isTokenExpired(tokenData.samlToken)) {
                return Promises.resolve((Object)tokenData.samlToken);
            }
            this.refreshNow(client);
            return this.getToken(client);
        });
    }

    public Promise<Boolean> isLoggedIn(ExternalTokenClient client) {
        CompletableFuture future = this.getCurrentRequestFor(client);
        if (future == null) {
            return Promises.resolve((Object)false);
        }
        return PromiseUtils.toPromise(future).materialize().thenApply(PromiseResult::isSuccessful);
    }

    public void releaseToken(ExternalTokenClient client) {
        this.releaseClient(client);
    }

    private boolean isTokenExpired(SamlToken token) {
        long tokenExpTimeMillis = token.getExpirationTime().getTime();
        Date minExpTime = new Date(tokenExpTimeMillis - TimeUnit.SECONDS.toMillis(60L));
        return minExpTime.before(new Date());
    }
}

