/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vlsi.record;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.utilities.ExecuteOnceOpWrapper;
import com.vmware.srm.client.topology.client.vmomi.Service;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.ManagedObjectProxy;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.StubCreator;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.VlsiClientUtils;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.record.CallRecord;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.record.VmomiRecordLookup;
import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReplayVmomiServiceImpl<S extends ManagedObject, D extends DataObject>
implements Service<S, D>,
MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplayVmomiServiceImpl.class);
    private final URI _url;
    private final String _guid;
    private final VmodlContext _context;
    private final ManagedObjectReference _siRef;
    private final ExecuteOnceOpWrapper<VmodlVersion> _versionCreator;
    private final ExecuteOnceOpWrapper<VmomiRecordLookup> _lookupCreator;

    private static VmodlVersion loadVersion(File guidDir, VmodlContext context) throws IOException {
        String versionString = FileUtils.readFileToString((File)new File(guidDir, "vmomi-version"), (Charset)StandardCharsets.UTF_8);
        String[] parts = versionString.split("/");
        if (parts.length != 2) {
            throw new RuntimeException("Invalid version string '" + versionString + "'");
        }
        String ns = parts[0];
        String vid = parts[1];
        VmodlVersion vv = context.getVmodlVersionMap().findVersion(ns, vid);
        if (vv == null) {
            throw new RuntimeException("No version found for '" + versionString + "'");
        }
        return vv;
    }

    protected ReplayVmomiServiceImpl(File opIdDir, URI url, String guid, ManagedObjectReference siRef, VmodlContext context) {
        this._url = url;
        this._guid = guid;
        this._siRef = new ManagedObjectReference(siRef.getType(), siRef.getValue(), guid);
        this._context = context;
        File guidDir = new File(opIdDir, guid);
        this._versionCreator = new ExecuteOnceOpWrapper(() -> ReplayVmomiServiceImpl.loadVersion(guidDir, this._context));
        this._lookupCreator = new ExecuteOnceOpWrapper(() -> new VmomiRecordLookup(opIdDir, guid, this._context, (VmodlVersion)this._versionCreator.invoke().get()));
    }

    @Override
    public URI getServerUrl() {
        return this._url;
    }

    @Override
    public <T extends ManagedObject> T createStub(ManagedObjectReference moRef) {
        ManagedObjectType moType = VlsiClientUtils.getType(moRef, this._context.getVmodlTypeMap());
        Class moBackingClass = moType.getTypeClass();
        return StubCreator.create(moRef, moBackingClass, this);
    }

    @Override
    public Promise<S> getServiceInstance() {
        return this.getContent().thenApply(content -> {
            String guid = this.getServerGuid(content);
            if (!this._guid.equals(guid)) {
                String msg = "Ctor guid and content guid differ. '" + this._guid + "' != '" + guid + "'";
                LOGGER.error(msg);
                throw new RuntimeException(msg);
            }
            ManagedObjectReference siRef = new ManagedObjectReference(this._siRef.getType(), this._siRef.getValue(), guid);
            return this.createStub(siRef);
        });
    }

    @Override
    public final Promise<D> getContent() {
        return this.retrieveContent(this.createStub(this._siRef));
    }

    protected abstract String getServerGuid(D var1);

    protected abstract Promise<D> retrieveContent(S var1);

    @Override
    public Promise<VmodlVersion> getVersion() {
        return Promises.resolve((Object)((VmodlVersion)this._versionCreator.invoke().get()));
    }

    public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) {
        Validate.notEmpty((Object[])args, (String)"args");
        Validate.notEmpty((Object[])args);
        Validate.isTrue((boolean)(args[args.length - 1] instanceof Future));
        ManagedObjectProxy moProxy = (ManagedObjectProxy)proxy;
        ManagedObjectReference moRef = moProxy._getRef();
        VmomiRecordLookup vrl = (VmomiRecordLookup)this._lookupCreator.invoke().get();
        CallRecord cr = vrl.lookup(method, moRef, args, this._context);
        Future f = (Future)args[args.length - 1];
        if (cr == null) {
            String argsToString = Arrays.toString(args);
            LOGGER.error("Failed to lookup method '{}' with args '{}' for ref '{}'", new Object[]{method, argsToString, moRef});
            f.setException((Exception)new RuntimeException("Failed to lookup method " + method + " for " + moRef));
            return null;
        }
        cr.completeFuture(f);
        return null;
    }
}

