/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.exporters.inventory;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vr.client.impex.configurables.inventory.IeInventoryTree;
import com.vmware.vr.client.impex.configurables.inventory.InventoryConverter;
import com.vmware.vr.client.impex.exporters.SingleSiteExporter;
import com.vmware.vr.client.impex.tool.IdBuilder;
import com.vmware.vr.client.impex.tool.ServersDataWrapper;
import java.util.Collections;
import java.util.List;

public abstract class InventoryExporter
extends SingleSiteExporter<IeInventoryTree> {
    public InventoryExporter(boolean isRobo) {
        super(isRobo);
    }

    @Override
    protected Promise<List<IeInventoryTree>> getSingleSiteConfigurables(boolean local) {
        ServersDataWrapper serversData = this.getServersDataWrapper();
        String vcGuid = local ? serversData.getLocalPair().server().vc().guid() : serversData.getRemotePair().server().vc().guid();
        return PCUtil.retrieveProperties(serversData.getView(), (PropertyCollector.FilterSpec[])new PropertyCollector.FilterSpec[]{InventoryConverter.getFilterSpec(vcGuid)}).thenApply(pcResult -> {
            IeInventoryTree tree = new IeInventoryTree();
            tree.setLocal(local);
            tree.setRoot(InventoryConverter.rootFromVmodl(this.getIdBuilder(), pcResult, vcGuid));
            return Collections.singletonList(tree);
        });
    }

    protected abstract ServersDataWrapper getServersDataWrapper();

    protected abstract IdBuilder getIdBuilder();
}

