/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.tool.io;

import com.vmware.vr.client.impex.tool.io.IOHelper;
import java.io.Console;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleIOHelper
implements IOHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleIOHelper.class);
    private final Console _console;

    public ConsoleIOHelper(Console console) {
        this._console = console;
    }

    @Override
    public void writeln(String message) {
        LOGGER.info(message);
        this._console.writer().println(message);
    }

    @Override
    public String readln(String message) {
        LOGGER.info(message);
        this.write(message);
        String input = this._console.readLine();
        LOGGER.info("Input: " + input);
        return input;
    }

    @Override
    public String readPass(String message) {
        LOGGER.info(message);
        this.write(message);
        return new String(this._console.readPassword());
    }

    private void write(String message) {
        this._console.writer().write(message);
        this._console.writer().flush();
    }
}

