/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.tool.io.request;

import com.vmware.vr.client.impex.tool.io.IOHelper;
import com.vmware.vr.client.impex.tool.io.data.Lspp;
import com.vmware.vr.client.impex.tool.io.request.Request;
import org.apache.commons.lang.StringUtils;

public class LsppRequest
extends Request<Lspp> {
    private final IOHelper _ioHelper;

    public LsppRequest(IOHelper ioHelper) {
        super(false);
        this._ioHelper = ioHelper;
    }

    @Override
    public Lspp handle() {
        return this.collect();
    }

    private Lspp collect() {
        String host = this._ioHelper.readln("Enter host name or IP address of a Lookup Service:");
        String port = this._ioHelper.readln("Enter port (or press Enter in case you use the default - 443):");
        while (!StringUtils.isEmpty(port) && !StringUtils.isNumeric(port)) {
            port = this._ioHelper.readln("Enter a valid port (or press Enter in case you use the default - 443):");
        }
        return new Lspp(host, this.processPort(port));
    }

    private int processPort(String port) {
        if (StringUtils.isEmpty(port)) {
            return 443;
        }
        return Integer.valueOf(port);
    }
}

