/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class VersionUtil {
    public static List<Integer> parseVersionNumbers(String version) {
        if (StringUtils.isEmpty(version)) {
            throw new IllegalArgumentException("The version is empty or null.");
        }
        String[] versionNumberValues = version.split("\\.");
        ArrayList<Integer> versionNumbers = new ArrayList<Integer>();
        for (int i = 0; i < versionNumberValues.length; ++i) {
            versionNumbers.add(Integer.parseInt(versionNumberValues[i]));
        }
        return versionNumbers;
    }

    public static int compareVersion(String version1, String version2) {
        List<Integer> versionNumbers1 = VersionUtil.parseVersionNumbers(version1);
        List<Integer> versionNumbers2 = VersionUtil.parseVersionNumbers(version2);
        int length = Math.max(versionNumbers1.size(), versionNumbers2.size());
        for (int i = 0; i < length; ++i) {
            int versionNumber2;
            int versionNumber1 = i < versionNumbers1.size() && versionNumbers1.get(i) != null ? versionNumbers1.get(i) : 0;
            int n = versionNumber2 = i < versionNumbers2.size() && versionNumbers2.get(i) != null ? versionNumbers2.get(i) : 0;
            if (versionNumber1 < versionNumber2) {
                return -1;
            }
            if (versionNumber1 <= versionNumber2) continue;
            return 1;
        }
        return 0;
    }
}

