/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy;

import com.vmware.vide.deploy.AutoDeployOperation;
import com.vmware.vide.deploy.FileDeployExportData;
import com.vmware.vide.deploy.IAutoDeployOperationsDatabase;
import com.vmware.vide.deploy.IFileDeployExportDataReader;
import com.vmware.vide.deploy.Utilities;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class AutoDeployOperationsDatabase
implements IAutoDeployOperationsDatabase {
    public static final String BUILDER_AUTODEPLOYS_PROPERTY_KEY = "builder auto deploy operations";
    public static final String POST_COMMANDS_KEY = "post commands";
    public static final String PRE_COMMANDS_KEY = "pre commands";
    private IProject project;
    private String key;
    private QualifiedName autoDeploys;
    private final String AUTO_DEPLOY_PREFIX = "auto*deploy*";
    private final String AUTO_DEPLOY_PREFIX_SEPALATOR = "auto\\*deploy\\*";

    private AutoDeployOperationsDatabase(IProject project, String key) {
        this.project = project;
        this.key = key;
        this.autoDeploys = new QualifiedName("com.vmware.vide.deploy", key);
    }

    public String[] getAutoDeployOperationNames() {
        String operations = null;
        try {
            operations = this.project.getPersistentProperty(this.autoDeploys);
        }
        catch (CoreException coreException) {}
        if (operations == null || operations.isEmpty()) {
            return null;
        }
        return operations.substring("auto*deploy*".length()).split("auto\\*deploy\\*");
    }

    @Override
    public AutoDeployOperation[] getAutoDeployOperations() {
        ArrayList<AutoDeployOperation> operations = new ArrayList<AutoDeployOperation>();
        String[] opNames = this.getAutoDeployOperationNames();
        if (opNames != null) {
            String[] stringArray = opNames;
            int n = opNames.length;
            int n2 = 0;
            while (n2 < n) {
                String opName = stringArray[n2];
                String preCommands = null;
                String postCommands = null;
                QualifiedName q = new QualifiedName("com.vmware.vide.deploy", String.valueOf(this.key) + PRE_COMMANDS_KEY + opName);
                try {
                    preCommands = this.project.getPersistentProperty(q);
                }
                catch (CoreException coreException) {}
                if (preCommands == null) {
                    preCommands = "";
                }
                q = new QualifiedName("com.vmware.vide.deploy", String.valueOf(this.key) + POST_COMMANDS_KEY + opName);
                try {
                    postCommands = this.project.getPersistentProperty(q);
                }
                catch (CoreException coreException) {}
                if (postCommands == null) {
                    postCommands = "";
                }
                operations.add(new AutoDeployOperation(opName, preCommands, postCommands));
                ++n2;
            }
        }
        return operations.toArray(new AutoDeployOperation[operations.size()]);
    }

    public void setAutoDeployOperations(String[] operations) {
        StringBuffer newOperations = new StringBuffer();
        String[] stringArray = operations;
        int n = operations.length;
        int n2 = 0;
        while (n2 < n) {
            String op = stringArray[n2];
            newOperations.append("auto*deploy*" + op);
            ++n2;
        }
        try {
            this.project.setPersistentProperty(this.autoDeploys, newOperations.toString());
        }
        catch (CoreException coreException) {}
    }

    public void setAutoDeployOperations(AutoDeployOperation[] operations) {
        StringBuffer newOperations = new StringBuffer();
        AutoDeployOperation[] autoDeployOperationArray = operations;
        int n = operations.length;
        int n2 = 0;
        while (n2 < n) {
            AutoDeployOperation op = autoDeployOperationArray[n2];
            if (op.getName() != null && !op.getName().isEmpty()) {
                newOperations.append("auto*deploy*" + op.getName());
                QualifiedName q = new QualifiedName("com.vmware.vide.deploy", String.valueOf(this.key) + PRE_COMMANDS_KEY + op.getName());
                try {
                    this.project.setPersistentProperty(q, op.getPreCommands());
                }
                catch (CoreException coreException) {
                    System.err.println("Failed to set the pre commands for the deploy operation " + op.getName());
                }
                q = new QualifiedName("com.vmware.vide.deploy", String.valueOf(this.key) + POST_COMMANDS_KEY + op.getName());
                try {
                    this.project.setPersistentProperty(q, op.getPostCommands());
                }
                catch (CoreException coreException) {
                    System.err.println("Failed to set the post commands for the deploy operation " + op.getName());
                }
            }
            ++n2;
        }
        try {
            this.project.setPersistentProperty(this.autoDeploys, newOperations.toString());
        }
        catch (CoreException coreException) {
            System.err.println("Failed to set the deploy operations list");
        }
    }

    public void deleteAutoDeployOperations(String[] deletedOperations) {
        String[] currentOperations = this.getAutoDeployOperationNames();
        if (currentOperations == null) {
            return;
        }
        String[] diffs = Utilities.getDifference(currentOperations, deletedOperations);
        if (diffs != null && diffs.length > 0) {
            this.setAutoDeployOperations(diffs);
        } else {
            try {
                this.project.setPersistentProperty(this.autoDeploys, "");
            }
            catch (CoreException coreException) {}
        }
    }

    @Override
    public IFileDeployExportDataReader getFileDeployExportDataReader(String name) {
        FileDeployExportData exportConfigData = new FileDeployExportData();
        try {
            exportConfigData.restore(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to restore the deploy operation " + name);
            return null;
        }
        return exportConfigData;
    }

    public static AutoDeployOperationsDatabase createBuilderDatabase(IProject project) {
        return new AutoDeployOperationsDatabase(project, BUILDER_AUTODEPLOYS_PROPERTY_KEY);
    }

    @Override
    public IFileDeployExportDataReader[] getAllFileDeployExportDataReaders() {
        String[] names = this.getAutoDeployOperationNames();
        IFileDeployExportDataReader[] readers = new IFileDeployExportDataReader[names.length];
        int i = 0;
        while (i < names.length) {
            readers[i] = this.getFileDeployExportDataReader(names[i]);
            ++i;
        }
        return readers;
    }
}

