/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy;

import com.vmware.vide.deploy.AutoDeployOperation;
import com.vmware.vide.deploy.AutoDeployOperationsDatabase;
import com.vmware.vide.deploy.DeployCommandDialog;
import com.vmware.vide.deploy.DeployExportWizard;
import com.vmware.vide.deploy.FileDeployExportData;
import com.vmware.vide.deploy.FileDeployOperationsDatabase;
import com.vmware.vide.deploy.Utilities;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.PlatformUI;

public class AutoDeployPropertyTabPage {
    private static final String SELECTED_OPERATIONS_POPUPMENU_POSITION = "selected operations popupmenu position";
    private static final String AUTO_DEPLOY_OPERATIONS_LABEL = "Auto deploy operations";
    private static final String FILE_DEPLOY_OPERATIONS_LABEL = "File deploy operations";
    private List selectedOperations;
    private List operations;
    private Button selectButton;
    private Button deselectButton;
    private Button upButton;
    private Button downButton;
    private Button removeButton;
    private Button newButton;
    private Button editButton;
    private TabFolder tabFolder;
    private AutoDeployOperationsDatabase autoDeployOperationsDatabase;
    private HashMap<String, AutoDeployOperation> commandsCache;
    OperationsPropertyChangeListener operationsPropertyChangeListener;

    private void moveSelectedItems(List from, List to) {
        String[] operations;
        String[] stringArray = operations = from.getSelection();
        int n = operations.length;
        int n2 = 0;
        while (n2 < n) {
            String operation = stringArray[n2];
            to.add(operation);
            ++n2;
        }
        from.remove(from.getSelectionIndices());
    }

    private void enableUpDown(boolean enables) {
        this.upButton.setEnabled(enables);
        this.downButton.setEnabled(enables);
    }

    private String getFileDeployInformation(String operation) {
        FileDeployExportData data = new FileDeployExportData();
        try {
            data.restore(operation);
        }
        catch (Exception e) {
            System.err.println("Failed to get the file deploy operation " + operation);
            e.printStackTrace();
        }
        return data.getInformationText();
    }

    public AutoDeployPropertyTabPage(TabFolder tabFolder) {
        this.tabFolder = tabFolder;
    }

    private void deleteOperations(String[] deletedOperations) {
        this.deleteOperations(this.operations, deletedOperations);
        this.deleteOperations(this.selectedOperations, deletedOperations);
    }

    private void deleteOperations(List ops, String[] deletedOperations) {
        String[] newOps = Utilities.getDifference(ops.getItems(), deletedOperations);
        ops.setItems(newOps);
    }

    private void addOperations(String[] addedOperations) {
        String[] items = this.operations.getItems();
        String[] newItems = new String[items.length + addedOperations.length];
        System.arraycopy(items, 0, newItems, 0, items.length);
        System.arraycopy(addedOperations, 0, newItems, items.length, addedOperations.length);
        this.operations.setItems(newItems);
        String[] stringArray = addedOperations;
        int n = addedOperations.length;
        int n2 = 0;
        while (n2 < n) {
            String opName = stringArray[n2];
            this.commandsCache.put(opName, new AutoDeployOperation(opName, "", ""));
            ++n2;
        }
    }

    public Control getTabControl() {
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        new Label(composite, 0).setText(AUTO_DEPLOY_OPERATIONS_LABEL);
        new Label(composite, 0);
        new Label(composite, 0).setText(FILE_DEPLOY_OPERATIONS_LABEL);
        this.selectedOperations = new List(composite, 2562);
        GridData gridData = new GridData(4, 4, true, true);
        this.selectedOperations.setLayoutData((Object)gridData);
        Composite buttonsComposite = new Composite(composite, 0);
        buttonsComposite.setLayout((Layout)new FillLayout(512));
        this.selectButton = new Button(buttonsComposite, 8);
        this.selectButton.setText("<< Select <<");
        this.selectButton.addListener(13, (Listener)new SelectButtonListener());
        this.deselectButton = new Button(buttonsComposite, 8);
        this.deselectButton.setText(">> Deselect >>");
        this.deselectButton.addListener(13, (Listener)new DeselectButtonListener());
        new Label(buttonsComposite, 0);
        UpDownButtonListener upDownButtonListener = new UpDownButtonListener();
        this.upButton = new Button(buttonsComposite, 8);
        this.upButton.setText("UP");
        this.upButton.addListener(13, (Listener)upDownButtonListener);
        this.downButton = new Button(buttonsComposite, 8);
        this.downButton.setText("DOWN");
        this.downButton.addListener(13, (Listener)upDownButtonListener);
        this.enableUpDown(false);
        new Label(buttonsComposite, 0);
        this.removeButton = new Button(buttonsComposite, 8);
        this.removeButton.setText("Remove");
        this.removeButton.addListener(13, (Listener)new RemoveButtonListener());
        this.removeButton.setEnabled(false);
        this.newButton = new Button(buttonsComposite, 8);
        this.newButton.setText("New...");
        this.newButton.addListener(13, (Listener)new NewButtonListener());
        this.newButton.setEnabled(true);
        this.operations = new List(composite, 2562);
        gridData = new GridData(4, 4, true, true);
        this.operations.setLayoutData((Object)gridData);
        new Label(buttonsComposite, 0);
        this.editButton = new Button(buttonsComposite, 8);
        this.editButton.setText("Edit...");
        this.editButton.setToolTipText("Edit commands associated with the selected deploy operation.");
        this.editButton.addSelectionListener((SelectionListener)new EditSelectedListener());
        this.editButton.setEnabled(false);
        this.selectedOperations.addSelectionListener((SelectionListener)new SelectedOperationsListener());
        this.operations.addSelectionListener((SelectionListener)new OperationsListener());
        this.operationsPropertyChangeListener = new OperationsPropertyChangeListener();
        FileDeployOperationsDatabase.addListener(this.operationsPropertyChangeListener);
        this.createSelectedOperationsPopupMenu();
        this.createOperationInformationHover();
        return composite;
    }

    private void createOperationInformationHover() {
        OperationsHoverListener operationsHoverListener = new OperationsHoverListener();
        this.selectedOperations.addListener(32, (Listener)operationsHoverListener);
        this.selectedOperations.addListener(5, (Listener)operationsHoverListener);
        this.selectedOperations.addListener(1, (Listener)operationsHoverListener);
        this.selectedOperations.addListener(12, (Listener)operationsHoverListener);
        this.operations.addListener(32, (Listener)operationsHoverListener);
        this.operations.addListener(5, (Listener)operationsHoverListener);
        this.operations.addListener(1, (Listener)operationsHoverListener);
        this.operations.addListener(12, (Listener)operationsHoverListener);
    }

    private void createSelectedOperationsPopupMenu() {
        this.selectedOperations.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                if (AutoDeployPropertyTabPage.this.selectedOperations.getSelectionCount() > 0) {
                    Menu m = AutoDeployPropertyTabPage.this.createSelectedOperationMenu();
                    m.setVisible(true);
                    AutoDeployPropertyTabPage.this.selectedOperations.setData(AutoDeployPropertyTabPage.SELECTED_OPERATIONS_POPUPMENU_POSITION, (Object)new Point(e.x, e.y));
                }
            }
        });
    }

    private Menu createSelectedOperationMenu() {
        Menu m = new Menu((Control)this.selectedOperations);
        MenuItem m1 = new MenuItem(m, 0);
        m1.setText("Edit Command...");
        if (this.selectedOperations.getSelectionCount() == 1) {
            m1.setEnabled(true);
        } else {
            m1.setEnabled(false);
        }
        m1.addSelectionListener((SelectionListener)new EditSelectedListener());
        new MenuItem(m, 2);
        MenuItem m2 = new MenuItem(m, 0);
        m2.setText("Deselect");
        m2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AutoDeployPropertyTabPage.this.moveSelectedItems(AutoDeployPropertyTabPage.this.selectedOperations, AutoDeployPropertyTabPage.this.operations);
            }
        });
        return m;
    }

    public String[] getSelectedOperations() {
        return this.selectedOperations.getItems();
    }

    public List getSelectedOperationsList() {
        return this.selectedOperations;
    }

    public List getOperationsList() {
        return this.operations;
    }

    public void setOperationsList(String[] ops) {
        this.operations.setItems(ops);
    }

    public void setSelectedOperationsList(String[] ops) {
        this.selectedOperations.setItems(ops);
    }

    public void cleanup() {
        FileDeployOperationsDatabase.removeListener(this.operationsPropertyChangeListener);
    }

    public AutoDeployOperation[] getAutoDeployOperations() {
        String[] selectedOps = this.getSelectedOperations();
        ArrayList<AutoDeployOperation> autoDeployOperations = new ArrayList<AutoDeployOperation>();
        String[] stringArray = selectedOps;
        int n = selectedOps.length;
        int n2 = 0;
        while (n2 < n) {
            String op = stringArray[n2];
            autoDeployOperations.add(this.commandsCache.get(op));
            ++n2;
        }
        return autoDeployOperations.toArray(new AutoDeployOperation[autoDeployOperations.size()]);
    }

    public void initializeOperations(AutoDeployOperationsDatabase database) {
        String[] allOps = FileDeployOperationsDatabase.getOperationNames();
        String[] selectedOps = database.getAutoDeployOperationNames();
        if (selectedOps == null) {
            this.setOperationsList(allOps);
        } else {
            this.setOperationsList(Utilities.getDifference(allOps, selectedOps));
            this.setSelectedOperationsList(selectedOps);
        }
        this.autoDeployOperationsDatabase = database;
        this.commandsCache = new HashMap();
        AutoDeployOperation[] autoDeployOperations = database.getAutoDeployOperations();
        Object[] objectArray = autoDeployOperations;
        int n = autoDeployOperations.length;
        int n2 = 0;
        while (n2 < n) {
            AutoDeployOperation op = objectArray[n2];
            this.commandsCache.put(op.getName(), op);
            ++n2;
        }
        objectArray = allOps;
        n = allOps.length;
        n2 = 0;
        while (n2 < n) {
            Object opName = objectArray[n2];
            if (!this.commandsCache.containsKey(opName)) {
                this.commandsCache.put((String)opName, new AutoDeployOperation((String)opName, "", ""));
            }
            ++n2;
        }
    }

    private class DeselectButtonListener
    implements Listener {
        private DeselectButtonListener() {
        }

        public void handleEvent(Event event) {
            AutoDeployPropertyTabPage.this.moveSelectedItems(AutoDeployPropertyTabPage.this.selectedOperations, AutoDeployPropertyTabPage.this.operations);
        }
    }

    private class EditSelectedListener
    extends SelectionAdapter {
        private EditSelectedListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            String operation = AutoDeployPropertyTabPage.this.selectedOperations.getSelection()[0];
            DeployCommandDialog dlg = new DeployCommandDialog(AutoDeployPropertyTabPage.this.selectedOperations.getShell());
            Point location = event.getSource() instanceof Button ? AutoDeployPropertyTabPage.this.selectedOperations.toDisplay(new Point(((AutoDeployPropertyTabPage)AutoDeployPropertyTabPage.this).selectedOperations.getBounds().width / 2, AutoDeployPropertyTabPage.this.selectedOperations.getSelectionIndex() * AutoDeployPropertyTabPage.this.selectedOperations.getItemHeight())) : (Point)AutoDeployPropertyTabPage.this.selectedOperations.getData(AutoDeployPropertyTabPage.SELECTED_OPERATIONS_POPUPMENU_POSITION);
            DeployCommandDialog.AutoDeployCommandsPair commandsPair = dlg.open(AutoDeployPropertyTabPage.this.selectedOperations, location, (AutoDeployOperation)AutoDeployPropertyTabPage.this.commandsCache.get(operation), AutoDeployPropertyTabPage.this.getFileDeployInformation(operation));
            if (commandsPair != null) {
                AutoDeployOperation op = new AutoDeployOperation(operation, commandsPair.getPreCommands(), commandsPair.getPostCommands());
                AutoDeployPropertyTabPage.this.commandsCache.put(operation, op);
            }
        }
    }

    private class NewButtonListener
    implements Listener {
        private NewButtonListener() {
        }

        public void handleEvent(Event event) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            DeployExportWizard wd = new DeployExportWizard();
            wd.setWindowTitle("Export Settings");
            WizardDialog wdlg = new WizardDialog(shell, (IWizard)wd);
            wdlg.open();
        }
    }

    private class OperationsHoverListener
    implements Listener {
        private Shell tipShell;
        private Point originalPoint;
        private List opList;

        private OperationsHoverListener() {
        }

        public void handleEvent(Event event) {
            this.opList = (List)event.widget;
            switch (event.type) {
                case 1: 
                case 5: 
                case 12: {
                    if (this.tipShell == null) break;
                    this.tipShell.dispose();
                    this.tipShell = null;
                    break;
                }
                case 32: {
                    Point pos;
                    FileDeployExportData deployData = this.getOperation(event);
                    if (deployData == null) {
                        return;
                    }
                    if (this.tipShell != null && !this.tipShell.isDisposed()) {
                        this.tipShell.dispose();
                    }
                    Display display = this.opList.getDisplay();
                    this.tipShell = new Shell(this.opList.getShell(), 540676);
                    this.tipShell.setBackground(display.getSystemColor(29));
                    this.tipShell.setText("Operation Info");
                    FillLayout layout = new FillLayout();
                    layout.marginWidth = 2;
                    this.tipShell.setLayout((Layout)layout);
                    Label label = new Label((Composite)this.tipShell, 0);
                    label.setForeground(display.getSystemColor(28));
                    label.setBackground(display.getSystemColor(29));
                    if (this.opList.equals(AutoDeployPropertyTabPage.this.selectedOperations)) {
                        label.setText(this.getAutoDeployInformationText(deployData));
                    } else {
                        label.setText(deployData.getInformationText());
                    }
                    label.addListener(3, (Listener)new TipMouseListener());
                    label.addListener(7, (Listener)new TipMouseListener());
                    this.originalPoint = this.opList.toDisplay(event.x, event.y);
                    Point size = this.tipShell.computeSize(-1, -1);
                    if (event.y > this.opList.getItemCount() * this.opList.getItemHeight()) {
                        int y = this.opList.getItemHeight() * this.opList.getSelectionIndex() + 2;
                        pos = this.opList.toDisplay(event.x, y);
                    } else {
                        pos = this.opList.toDisplay(event.x - 1, event.y - 1);
                    }
                    this.tipShell.setBounds(pos.x, pos.y, size.x, size.y);
                    this.tipShell.setVisible(true);
                }
            }
        }

        private String getAutoDeployInformationText(FileDeployExportData deployData) {
            StringBuffer infoText = new StringBuffer(deployData.getInformationText());
            String name = deployData.getName();
            AutoDeployOperation aOp = (AutoDeployOperation)AutoDeployPropertyTabPage.this.commandsCache.get(name);
            if (aOp != null && !aOp.getPreCommands().trim().isEmpty()) {
                infoText.append("Pre deploy commands: \n    ");
                infoText.append(this.formCommands(aOp.getPreCommands()));
            }
            if (aOp != null && !aOp.getPostCommands().trim().isEmpty()) {
                if (infoText.charAt(infoText.length() - 1) != '\n') {
                    infoText.append('\n');
                }
                infoText.append("Post deploy commands: \n    ");
                infoText.append(this.formCommands(aOp.getPostCommands()));
            }
            return infoText.toString();
        }

        private String formCommands(String commandsText) {
            return commandsText.replaceAll("\n", "\n    ").trim();
        }

        private FileDeployExportData getOperation(Event event) {
            FileDeployExportData data = null;
            List opList = (List)event.widget;
            int index = event.y / opList.getItemHeight();
            if (index >= opList.getItemCount()) {
                if (opList.getSelectionCount() != 1) {
                    return data;
                }
                index = opList.getSelectionIndex();
            }
            String op = opList.getItem(index);
            data = new FileDeployExportData();
            try {
                data.restore(op);
            }
            catch (Exception exception) {
                System.err.println("Failed to restore the operation " + op);
                return null;
            }
            return data;
        }

        private class TipMouseListener
        implements Listener {
            private TipMouseListener() {
            }

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: 
                    case 7: {
                        if (OperationsHoverListener.this.tipShell == null) break;
                        OperationsHoverListener.this.tipShell.dispose();
                        if (OperationsHoverListener.this.opList.equals(AutoDeployPropertyTabPage.this.selectedOperations) && event.type == 3) {
                            Event e = new Event();
                            e.x = ((OperationsHoverListener)OperationsHoverListener.this).originalPoint.x;
                            e.y = ((OperationsHoverListener)OperationsHoverListener.this).originalPoint.y;
                            int h = ((OperationsHoverListener)OperationsHoverListener.this).opList.toControl((int)((OperationsHoverListener)OperationsHoverListener.this).originalPoint.x, (int)((OperationsHoverListener)OperationsHoverListener.this).originalPoint.y).y;
                            if (h < OperationsHoverListener.this.opList.getItemHeight() * OperationsHoverListener.this.opList.getItemCount()) {
                                OperationsHoverListener.this.opList.deselectAll();
                                OperationsHoverListener.this.opList.select(h / OperationsHoverListener.this.opList.getItemHeight());
                            }
                            e.type = 35;
                            e.button = event.button;
                            OperationsHoverListener.this.opList.notifyListeners(35, e);
                        }
                        OperationsHoverListener.this.tipShell = null;
                    }
                }
            }
        }
    }

    private class OperationsListener
    implements SelectionListener {
        private OperationsListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            AutoDeployPropertyTabPage.this.selectedOperations.deselectAll();
            AutoDeployPropertyTabPage.this.deselectButton.setEnabled(false);
            AutoDeployPropertyTabPage.this.editButton.setEnabled(false);
            AutoDeployPropertyTabPage.this.selectButton.setEnabled(true);
            AutoDeployPropertyTabPage.this.enableUpDown(false);
            if (AutoDeployPropertyTabPage.this.operations.getSelectionCount() > 0) {
                AutoDeployPropertyTabPage.this.removeButton.setEnabled(true);
            } else {
                AutoDeployPropertyTabPage.this.removeButton.setEnabled(false);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class OperationsPropertyChangeListener
    implements IPropertyChangeListener {
        private OperationsPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (FileDeployOperationsDatabase.isDeployOperationsProperty(event.getProperty())) {
                String[] oldOperations;
                String[] newOperations = FileDeployOperationsDatabase.extractOperations((String)event.getNewValue());
                if (newOperations.length > (oldOperations = FileDeployOperationsDatabase.extractOperations((String)event.getOldValue())).length) {
                    String[] addedOperations = Utilities.getDifference(newOperations, oldOperations);
                    AutoDeployPropertyTabPage.this.addOperations(addedOperations);
                } else if (newOperations.length < oldOperations.length) {
                    String[] deletedOperations = Utilities.getDifference(oldOperations, newOperations);
                    AutoDeployPropertyTabPage.this.deleteOperations(deletedOperations);
                    AutoDeployPropertyTabPage.this.autoDeployOperationsDatabase.deleteAutoDeployOperations(deletedOperations);
                }
            }
        }
    }

    private class RemoveButtonListener
    implements Listener {
        private RemoveButtonListener() {
        }

        public void handleEvent(Event event) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            boolean confirmed = MessageDialog.openConfirm((Shell)shell, (String)"Confirm", (String)"This operation will remove the currently selected deploy operation from the workspace. All auto deploy operations associated with the selected operation will be removed for all projects.");
            if (confirmed) {
                String[] ops = null;
                if (AutoDeployPropertyTabPage.this.operations.getSelectionCount() > 0) {
                    ops = AutoDeployPropertyTabPage.this.operations.getSelection();
                    AutoDeployPropertyTabPage.this.operations.remove(AutoDeployPropertyTabPage.this.operations.getSelectionIndices());
                } else if (AutoDeployPropertyTabPage.this.selectedOperations.getSelectionCount() > 0) {
                    ops = AutoDeployPropertyTabPage.this.selectedOperations.getSelection();
                    AutoDeployPropertyTabPage.this.selectedOperations.remove(AutoDeployPropertyTabPage.this.selectedOperations.getSelectionIndices());
                } else {
                    return;
                }
                this.doRemoveOperations(ops);
            }
        }

        private void doRemoveOperations(String[] ops) {
            FileDeployOperationsDatabase.remove(ops);
        }
    }

    private class SelectButtonListener
    implements Listener {
        private SelectButtonListener() {
        }

        public void handleEvent(Event event) {
            AutoDeployPropertyTabPage.this.moveSelectedItems(AutoDeployPropertyTabPage.this.operations, AutoDeployPropertyTabPage.this.selectedOperations);
        }
    }

    private class SelectedOperationsListener
    implements SelectionListener {
        private SelectedOperationsListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            AutoDeployPropertyTabPage.this.operations.deselectAll();
            AutoDeployPropertyTabPage.this.selectButton.setEnabled(false);
            AutoDeployPropertyTabPage.this.deselectButton.setEnabled(true);
            if (AutoDeployPropertyTabPage.this.selectedOperations.getSelectionCount() > 0) {
                AutoDeployPropertyTabPage.this.removeButton.setEnabled(true);
            } else {
                AutoDeployPropertyTabPage.this.removeButton.setEnabled(false);
            }
            if (AutoDeployPropertyTabPage.this.selectedOperations.getSelectionCount() == 1) {
                AutoDeployPropertyTabPage.this.enableUpDown(true);
                AutoDeployPropertyTabPage.this.editButton.setEnabled(true);
            } else {
                AutoDeployPropertyTabPage.this.enableUpDown(false);
                AutoDeployPropertyTabPage.this.editButton.setEnabled(false);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class UpDownButtonListener
    implements Listener {
        private UpDownButtonListener() {
        }

        public void handleEvent(Event event) {
            int oldPosition = AutoDeployPropertyTabPage.this.selectedOperations.getSelectionIndex();
            String operation = AutoDeployPropertyTabPage.this.selectedOperations.getSelection()[0];
            int newPosition = oldPosition;
            if (event.widget == AutoDeployPropertyTabPage.this.upButton) {
                if (oldPosition != 0) {
                    --newPosition;
                }
            } else if (oldPosition != AutoDeployPropertyTabPage.this.selectedOperations.getItemCount() - 1) {
                ++newPosition;
            }
            if (oldPosition != newPosition) {
                AutoDeployPropertyTabPage.this.selectedOperations.remove(oldPosition);
                AutoDeployPropertyTabPage.this.selectedOperations.add(operation, newPosition);
                AutoDeployPropertyTabPage.this.selectedOperations.setSelection(newPosition);
            }
        }
    }
}

