/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy;

import com.vmware.vide.deploy.FileDeployUtilities;
import com.vmware.vide.target.api.ITarget;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.RemoteFileException;

public class FileDeployExporter {
    private boolean noTarget = false;
    private ITarget target = null;

    public FileDeployExporter(String targetPath) {
        if (targetPath.indexOf(":") == -1) {
            this.noTarget = true;
        } else {
            ITarget t = FileDeployUtilities.getTargetByName(targetPath);
            if (t != null) {
                this.target = t;
            }
            if (this.target == null) {
                System.err.println("Specified target " + targetPath + " is not found in the target list.");
            }
        }
    }

    public void createFolder(IPath path) {
        String folderName = this.extractPath(path);
        File file = FileDeployUtilities.getFolderOrCreate(String.valueOf(this.target.getHostName()) + ":" + folderName);
        if (file == null || !file.exists()) {
            System.err.println("Failed to create the directory " + path.toString());
        }
    }

    public void write(IFile file, IPath targetPath) throws CoreException, IOException {
        String folderName = this.extractPath(targetPath.removeLastSegments(1));
        File sourceFile = new File(file.getLocation().toOSString());
        try {
            this.target.uploadFile(sourceFile, folderName, null);
        }
        catch (RemoteFileException e) {
            Exception ex = e.getRemoteException();
            if (ex != null) {
                if (ex instanceof SecurityException) {
                    throw new IOException(((SecurityException)ex).getMessage());
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
            }
            throw new IOException(e.getMessage());
        }
        catch (SystemMessageException e) {
            SystemMessage sysmsg = e.getSystemMessage();
            if (sysmsg != null) {
                String msg = sysmsg.getLevelTwoText();
                if (msg != null && !msg.isEmpty()) {
                    throw new IOException(msg);
                }
                msg = sysmsg.getLevelOneText();
                if (msg != null && !msg.isEmpty()) {
                    throw new IOException(msg);
                }
            }
            throw new IOException(e.getMessage());
        }
        catch (CoreException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private String extractPath(IPath path) {
        if (this.noTarget) {
            return path.toString();
        }
        if (path.segmentCount() == 1 && path.segment(0).endsWith(":")) {
            return "/";
        }
        String pathName = path.toString();
        return pathName.substring(pathName.indexOf(":") + 1, pathName.length());
    }
}

