/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.devkit;

import com.vmware.vide.init.ConfigUtil;
import com.vmware.vide.project.config.devkit.AbstractCommandRunner;
import com.vmware.vide.project.config.devkit.ShellCommandRunner;
import com.vmware.vide.project.config.devkit.VIBBuildCommandRunner;
import com.vmware.vide.project.manager.ProjectManager;
import com.vmware.vide.project.utils.Utils;
import com.vmware.vide.utils.net.HttpLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;

public class MenuRunner {
    private static final String EXTPOINT_COMMANDRUNNER = "commandrunner";
    private static final String TAG_PROPERTY = "property";
    private static final String TAG_KEY = "key";
    private static final String TAG_VALUE = "value";
    private static final String TAG_ENV = "env";
    private static final String TAG_ENV_NAME = "name";
    private static final String TAG_ENV_VALUE = "value";
    private String command;
    private int sequence;
    private AbstractCommandRunner runner;
    private Map<String, String> properties;
    private Map<String, String> environments;
    private static Map<String, AbstractCommandRunner> commandrunners;

    public MenuRunner(Object config, int defaultsequence) {
        this.sequence = defaultsequence;
        String seq = ConfigUtil.lookupString((Object)config, (String)"sequence");
        if (seq != null) {
            try {
                this.sequence = Integer.parseInt(seq);
            }
            catch (Exception exception) {}
        }
        this.command = ConfigUtil.lookupString((Object)config, (String)"command");
        this.properties = this.getProperties(config);
        this.environments = this.getEnvironments(config);
        this.runner = this.getCommandRunner(ConfigUtil.lookupString((Object)config, (String)"type"));
    }

    public boolean isValid() {
        if (this.runner != null) {
            return this.runner.isValid();
        }
        return false;
    }

    public boolean isRunnable(IProject project) {
        if (this.runner != null) {
            return this.runner.isRunnable(project);
        }
        return false;
    }

    public int getSequence() {
        return this.sequence;
    }

    public Job execute(Shell shell, IProject project) throws Exception {
        if (this.runner == null) {
            throw Utils.createCommandExecutionException("Failed to execute command ", null);
        }
        String evaluatedcommand = Utils.replaceContent(this.command, ProjectManager.getAllProjectProperties(project));
        Map<String, String> commandProperties = this.translateProperties(project);
        Map<String, String> envs = this.translateEnvironments(project);
        Job job = this.runner.run(shell, project, evaluatedcommand, this.sequence, commandProperties, envs);
        HttpLogger.logActivity((String)"devkits", (String)ProjectManager.getDevkitId(project));
        return job;
    }

    private Map<String, String> translateProperties(IProject project) {
        String dir;
        Map<String, String> projectProperties = ProjectManager.getAllProjectProperties(project);
        LinkedHashMap<String, String> commandProperties = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> ent : this.properties.entrySet()) {
            String val = ent.getValue();
            val = Utils.replaceContent(val, projectProperties);
            commandProperties.put(ent.getKey(), val);
        }
        if (commandProperties.containsKey("ExecutePath") && !(dir = (String)commandProperties.get("ExecutePath")).startsWith(File.separator)) {
            String projectPath = project.getLocation().toOSString();
            if (!projectPath.endsWith(File.separator)) {
                projectPath = String.valueOf(projectPath) + File.separator;
            }
            dir = String.valueOf(projectPath) + dir;
            commandProperties.remove("ExecutePath");
            commandProperties.put("ExecutePath", dir);
        }
        return commandProperties;
    }

    private Map<String, String> translateEnvironments(IProject project) {
        HashMap<String, String> envs = new HashMap<String, String>();
        Map<String, String> projectProperties = ProjectManager.getAllProjectProperties(project);
        for (Map.Entry<String, String> ent : this.environments.entrySet()) {
            String var = ent.getKey();
            var = Utils.replaceContent(var, projectProperties);
            String val = ent.getValue();
            if (val != null) {
                val = Utils.replaceContent(val, projectProperties);
            }
            envs.put(var, val);
        }
        return envs;
    }

    private AbstractCommandRunner getCommandRunner(String id) {
        Map<String, AbstractCommandRunner> runners = MenuRunner.getCommandRunners();
        if (runners.containsKey(id)) {
            return runners.get(id);
        }
        return null;
    }

    private Map<String, String> getProperties(Object config) {
        HashMap<String, String> commandproperties = new HashMap<String, String>();
        ArrayList properties = ConfigUtil.lookupList((Object)config, (String)TAG_PROPERTY);
        for (Object property : properties) {
            String key = ConfigUtil.lookupString(property, (String)TAG_KEY);
            String value = ConfigUtil.lookupString(property, (String)"value");
            if (key == null || key.isEmpty() || value == null) continue;
            commandproperties.put(key, value);
        }
        return commandproperties;
    }

    public static Map<String, AbstractCommandRunner> getCommandRunners() {
        if (commandrunners != null) {
            return commandrunners;
        }
        commandrunners = new HashMap<String, AbstractCommandRunner>();
        commandrunners.put(ShellCommandRunner.getDefault().getID(), ShellCommandRunner.getDefault());
        commandrunners.put("vibbuild", new VIBBuildCommandRunner());
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("com.vmware.vide.project", EXTPOINT_COMMANDRUNNER);
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension e = iExtensionArray[n2];
                try {
                    IConfigurationElement[] iConfigurationElementArray = e.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement ce = iConfigurationElementArray[n4];
                        String runnerid = ce.getAttribute("commandrunnerid");
                        Object obj = ce.createExecutableExtension("class");
                        if (obj instanceof AbstractCommandRunner) {
                            commandrunners.put(runnerid, (AbstractCommandRunner)obj);
                        }
                        ++n4;
                    }
                }
                catch (Exception exp) {
                    System.out.println(exp.getMessage());
                }
                ++n2;
            }
        }
        return commandrunners;
    }

    private Map<String, String> getEnvironments(Object config) {
        HashMap<String, String> envs = new HashMap<String, String>();
        ArrayList envElements = ConfigUtil.lookupList((Object)config, (String)TAG_ENV);
        for (Object element : envElements) {
            String variable = ConfigUtil.lookupString(element, (String)TAG_ENV_NAME);
            if (variable == null || variable.isEmpty()) {
                System.err.println("Missing variable name for the env.");
                continue;
            }
            String value = ConfigUtil.lookupString(element, (String)"value");
            envs.put(variable, value);
        }
        return envs;
    }
}

