/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.devkit;

import com.vmware.vide.init.ConfigUtil;
import com.vmware.vide.project.config.devkit.DevkitInfo;
import com.vmware.vide.project.config.devkit.MenuResource;
import com.vmware.vide.project.config.devkit.MenuRunner;
import com.vmware.vide.project.config.resource.AbstractProjectResource;
import com.vmware.vide.project.utils.Utils;
import com.vmware.vide.project.utils.VIDEProjectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ProjectMenu {
    public static final String TAG_TITLE = "title";
    public static final String TAG_GROUP = "group";
    public static final String TAG_ENABLE = "enable";
    public static final String TAG_PROJECTNATURE = "projectnature";
    public static final String TAG_RESOURCE = "resource";
    public static final String TAG_RUNNER = "runner";
    public static final String TAG_TYPE = "type";
    public static final String TAG_NAME = "name";
    public static final String TAG_REQUIRED = "required";
    public static final String TAG_SEQUENCE = "sequence";
    public static final String TAG_COMMAND = "command";
    public static final String TAG_CREATE_WHEN = "create_when";
    public static final String TAGVALUE_CREATE_WHEN_ALWAYS = "always";
    public static final String TAGVALUE_CREATE_WHEN_ALWAYS_ASK = "always_ask";
    public static final String TAGVALUE_CREATE_WHEN_UNAVAILABLE = "unavailable";
    public static final String TAGVALUE_CREATE_WHEN_UNAVAILABLE_ASK = "unavailable_ask";
    private final DevkitInfo parent;
    private String title;
    private final ArrayList<MenuResource> menuresources = new ArrayList();
    private final ArrayList<MenuRunner> menurunners = new ArrayList();
    private String[] natureids;
    private String groupname = null;

    public ProjectMenu(DevkitInfo parent, Object config) {
        this.parent = parent;
        this.refresh(config);
    }

    public boolean isValid() {
        return this.title != null && !this.title.isEmpty() && this.menurunners != null && this.menurunners.size() > 0;
    }

    public String getTitle() {
        return this.title;
    }

    public String getGroupName() {
        return this.groupname;
    }

    public boolean isGroup() {
        return this.groupname != null && !this.groupname.isEmpty();
    }

    public String[] getProjectNatureIds() {
        return this.natureids;
    }

    public String getDevkitId() {
        return this.parent.getId();
    }

    public AbstractProjectResource getResource(String resourceid) {
        return this.parent.getResource(resourceid);
    }

    public boolean isVisible(IProject project) {
        for (MenuResource resource : this.menuresources) {
            if (!resource.isRequired() || resource.isAvailable(project)) continue;
            return false;
        }
        return true;
    }

    public MenuResource.STATUS isRunnable(IProject project, boolean createifnotavailable) {
        if (this.menuresources != null && this.menuresources.size() > 0) {
            int i = 0;
            while (i < this.menuresources.size()) {
                MenuResource ms = this.menuresources.get(i);
                if (!ms.isAvailable(project) || ms.isCreateAlways()) {
                    if (!ms.canCreate()) {
                        return MenuResource.STATUS.ERROR;
                    }
                    if (createifnotavailable) {
                        return ms.createResources(project);
                    }
                }
                ++i;
            }
        }
        return this.getMenuRunners(project).size() != 0 ? MenuResource.STATUS.OK : MenuResource.STATUS.ERROR;
    }

    public void menuClicked(IProject project) throws VIDEProjectException {
        MenuResource.STATUS status = this.isRunnable(project, true);
        if (status == MenuResource.STATUS.OK) {
            final IProject curproject = project;
            final ArrayList<MenuRunner> runners = this.getMenuRunners(project);
            final Shell curshell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            if (runners.size() > 0) {
                Collections.sort(runners, new MenuComparator());
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        Job prevjob = null;
                        for (MenuRunner runner : runners) {
                            try {
                                if (prevjob != null) {
                                    prevjob.join();
                                    if (prevjob.getResult() == Status.CANCEL_STATUS) {
                                        return;
                                    }
                                }
                                prevjob = runner.execute(curshell, curproject);
                            }
                            catch (Exception exception) {
                                return;
                            }
                        }
                    }
                };
                thread.start();
                return;
            }
        } else if (status == MenuResource.STATUS.ERROR) {
            throw Utils.createCommandExecutionException("Insufficient information  to execute \"" + this.title + "\"", null);
        }
    }

    private void refresh(Object config) {
        ArrayList runners;
        if (!ConfigUtil.lookupBoolean((Object)config, (String)TAG_ENABLE, (String)"true", (boolean)false)) {
            this.title = null;
            return;
        }
        this.title = ConfigUtil.lookupString((Object)config, (String)TAG_TITLE);
        this.groupname = ConfigUtil.lookupString((Object)config, (String)TAG_GROUP);
        String natures = ConfigUtil.lookupString((Object)config, (String)TAG_PROJECTNATURE);
        this.natureids = natures != null && !natures.isEmpty() ? (natures.indexOf(";") != -1 ? natures.split(";") : new String[]{natures}) : new String[0];
        ArrayList resources = ConfigUtil.lookupList((Object)config, (String)TAG_RESOURCE);
        if (resources != null) {
            int i = 0;
            while (i < resources.size()) {
                MenuResource resource = new MenuResource(this, resources.get(i));
                if (resource.isValid()) {
                    this.menuresources.add(resource);
                }
                ++i;
            }
        }
        if ((runners = ConfigUtil.lookupList((Object)config, (String)TAG_RUNNER)) != null) {
            int i = 0;
            while (i < runners.size()) {
                MenuRunner runner = new MenuRunner(runners.get(i), i);
                if (runner.isValid()) {
                    this.menurunners.add(runner);
                }
                ++i;
            }
        }
    }

    public Hashtable<String, ProjectMenu> getMenusPerNature() {
        Hashtable<String, ProjectMenu> natures = new Hashtable<String, ProjectMenu>();
        if (this.natureids != null) {
            int i = 0;
            while (i < this.natureids.length) {
                natures.put(this.natureids[i], this);
                ++i;
            }
        }
        return natures;
    }

    private ArrayList<MenuRunner> getMenuRunners(IProject project) {
        ArrayList<MenuRunner> runners = new ArrayList<MenuRunner>();
        if (this.menurunners != null && this.menurunners.size() > 0) {
            for (MenuRunner runner : this.menurunners) {
                if (!runner.isRunnable(project)) continue;
                runners.add(runner);
            }
        }
        return runners;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        sb.append("title=").append(this.title == null ? "null" : this.title).append(", ");
        sb.append("group=").append(this.groupname == null ? "null" : this.groupname).append(", ");
        sb.append("natures=");
        if (this.natureids == null) {
            sb.append("null");
        } else {
            sb.append('[');
            i = 0;
            while (i < this.natureids.length) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.natureids[i]);
                ++i;
            }
            sb.append(']');
        }
        sb.append(", ");
        sb.append("menu resources=[");
        i = 0;
        while (i < this.menuresources.size()) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.menuresources.get(i).toString());
            ++i;
        }
        sb.append("], ");
        sb.append('}');
        return sb.toString();
    }

    private class MenuComparator
    implements Comparator<MenuRunner> {
        private MenuComparator() {
        }

        @Override
        public int compare(MenuRunner op1, MenuRunner op2) {
            return op1.getSequence() < op2.getSequence() ? -1 : (op1.getSequence() == op2.getSequence() ? 0 : 1);
        }
    }
}

