/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.devkit;

import com.vmware.vide.init.ConfigUtil;
import com.vmware.vide.init.InitPlugin;
import com.vmware.vide.project.config.devkit.DevkitInfo;
import com.vmware.vide.project.config.devkit.ProjectNaturePath;
import com.vmware.vide.project.config.devkit.ProjectProperty;
import com.vmware.vide.project.config.wizard.project.IProjectDataAccessor;
import com.vmware.vide.project.utils.VIDEProjectException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ProjectNatureInfo {
    private static final String TAG_ID = "id";
    private final DevkitInfo parent;
    private final String natureid;
    private final List<ProjectNaturePath> projectnaturepaths;
    private final LinkedHashMap<String, ProjectProperty> orderedNatureProperties;

    public ProjectNatureInfo(DevkitInfo parent, Object config) {
        List paths;
        this.parent = parent;
        this.natureid = ConfigUtil.lookupString((Object)config, (String)TAG_ID);
        this.orderedNatureProperties = new LinkedHashMap();
        this.projectnaturepaths = new ArrayList<ProjectNaturePath>();
        InitPlugin initPlugin = InitPlugin.getDefault();
        String kitid = parent.getId();
        ArrayList projectproperties = initPlugin.getProjectNatureOptions(kitid, this.natureid);
        if (projectproperties != null) {
            for (Map projectproperty : projectproperties) {
                ProjectProperty property = new ProjectProperty(projectproperty);
                if (!property.isValid() || this.orderedNatureProperties.containsKey(property.getName())) continue;
                this.orderedNatureProperties.put(property.getName(), property);
            }
        }
        if ((paths = initPlugin.getProjectNaturePaths(kitid, this.natureid)) != null) {
            for (Map path : paths) {
                try {
                    ProjectNaturePath p = new ProjectNaturePath(this.natureid, path);
                    this.projectnaturepaths.add(p);
                }
                catch (VIDEProjectException e) {
                    System.out.print(e.getMessage());
                }
            }
        }
    }

    public String getNatureId() {
        return this.natureid;
    }

    public boolean isValid() {
        return this.parent != null && this.natureid != null && !this.natureid.isEmpty();
    }

    public String getProperty(String propertyid) {
        if (this.orderedNatureProperties != null && this.orderedNatureProperties.containsKey(propertyid)) {
            return this.orderedNatureProperties.get(propertyid).getValue(null);
        }
        return null;
    }

    public Map<String, String> getProperties(final File projectfile) {
        final HashMap<String, String> properties = new HashMap<String, String>();
        for (String property : this.orderedNatureProperties.keySet()) {
            IProjectDataAccessor accessor = new IProjectDataAccessor(){
                Map<String, String> currentProperties = null;

                @Override
                public File getFirstFindProjectFile() {
                    return projectfile;
                }

                @Override
                public Map<String, String> getCurrentProperties() {
                    if (this.currentProperties == null) {
                        this.currentProperties = new HashMap<String, String>();
                        for (Map.Entry ent : properties.entrySet()) {
                            if (ent.getValue() == null) continue;
                            this.currentProperties.put((String)ent.getKey(), (String)ent.getValue());
                        }
                    }
                    return this.currentProperties;
                }
            };
            properties.put(property, this.orderedNatureProperties.get(property).getValue(accessor));
        }
        return properties;
    }

    public LinkedHashMap<String, ProjectProperty> getOrderedProjectProperties() {
        return this.orderedNatureProperties;
    }

    public List<ProjectNaturePath> getProjectNaturePaths() {
        return this.projectnaturepaths;
    }
}

