/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.resource;

import com.vmware.vide.project.config.devkit.MenuResource;
import com.vmware.vide.project.config.resource.AbstractProjectResource;
import com.vmware.vide.project.manager.ProjectManager;
import com.vmware.vide.project.utils.Utils;
import com.vmware.vide.project.utils.VIDEProjectException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;

public class ProjectPropertyResource
extends AbstractProjectResource {
    private static final String COMPARE_PATTERN = "([^\\s]+)\\s*([=!][=~])\\s*(.*)";
    private static final String ERR_BAD_PROPERTY_TEST = "Bad property test [%s].";
    private static final String ERR_NO_PROPERTY = "Property is not specified.";
    private static final String ERR_NO_COMPARATOR = "Comparator is not specified.";
    private static final String ERR_BAD_COMPARATOR = "Bad comparator [%s].";
    private final String property;
    private final String value;
    private final Pattern valuePattern;
    private final IComparator comparator;

    public ProjectPropertyResource(String propertyTest) {
        String comparator;
        if (propertyTest == null) {
            throw new NullPointerException();
        }
        Pattern p = Pattern.compile(COMPARE_PATTERN, 32);
        Matcher m = p.matcher(propertyTest);
        if (!m.find()) {
            throw new IllegalArgumentException(String.format(ERR_BAD_PROPERTY_TEST, propertyTest));
        }
        String property = m.group(1);
        if (property.isEmpty()) {
            throw new IllegalArgumentException(ERR_NO_PROPERTY);
        }
        String value = m.group(3).trim();
        if (value.length() > 1 && value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        if ((comparator = m.group(2)).isEmpty()) {
            throw new IllegalArgumentException(ERR_NO_COMPARATOR);
        }
        this.property = property;
        this.value = value;
        this.valuePattern = Pattern.compile(value);
        IComparator c = null;
        if (comparator.equals("==")) {
            c = new Equal();
        } else if (comparator.equals("!=")) {
            c = new NotEqual();
        } else if (comparator.equals("=~")) {
            c = new Match();
        } else if (comparator.equals("!~")) {
            c = new NotMatch();
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format(ERR_BAD_COMPARATOR, comparator));
        }
        this.comparator = c;
    }

    @Override
    public String getResourceId() {
        return "project_property";
    }

    @Override
    public boolean isAvailable(IProject project) {
        String value = ProjectManager.getProjectProperty(project, this.property);
        if (value == null) {
            return false;
        }
        value = Utils.replaceContent(value, ProjectManager.getAllProjectProperties(project));
        return this.comparator.eval(value);
    }

    @Override
    public MenuResource.STATUS createDefault(IProject project, int when, boolean ask) throws VIDEProjectException {
        return MenuResource.STATUS.OK;
    }

    private class Equal
    implements IComparator {
        private Equal() {
        }

        @Override
        public boolean eval(String propertyValue) {
            return ProjectPropertyResource.this.value.equals(propertyValue);
        }
    }

    private static interface IComparator {
        public boolean eval(String var1);
    }

    private class Match
    implements IComparator {
        private Match() {
        }

        @Override
        public boolean eval(String propertyValue) {
            Matcher m = ProjectPropertyResource.this.valuePattern.matcher(propertyValue);
            return m.find();
        }
    }

    private class NotEqual
    implements IComparator {
        private NotEqual() {
        }

        @Override
        public boolean eval(String propertyValue) {
            return !ProjectPropertyResource.this.value.equals(propertyValue);
        }
    }

    private class NotMatch
    implements IComparator {
        private NotMatch() {
        }

        @Override
        public boolean eval(String propertyValue) {
            Matcher m = ProjectPropertyResource.this.valuePattern.matcher(propertyValue);
            return !m.find();
        }
    }
}

