/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.vib;

import com.vmware.vide.project.ProjectPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class UserInputHelperCommand
implements Cloneable {
    private static ILog logger = ProjectPlugin.getDefault().getLog();
    private final String BUILTIN = "builtin:";
    private final String EXTERNAL = "external:";
    String command;
    List<String> args;

    public String getCommand() {
        if (this.isBuiltin()) {
            return this.command.substring("builtin:".length());
        }
        if (this.isExternal()) {
            return this.command.substring("external:".length());
        }
        return this.command;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public boolean isBuiltin() {
        return this.command.startsWith("builtin:");
    }

    public boolean isExternal() {
        return this.command.startsWith("external:");
    }

    public UserInputHelperCommand clone() {
        UserInputHelperCommand helperCommand = null;
        try {
            helperCommand = (UserInputHelperCommand)super.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e));
        }
        if (this.args != null) {
            helperCommand.args = new ArrayList<String>(this.args);
        }
        return helperCommand;
    }
}

