/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.wizard;

import com.vmware.vide.init.ConfigUtil;
import com.vmware.vide.project.config.devkit.DevkitInfo;
import com.vmware.vide.project.config.wizard.AbstractContent;
import com.vmware.vide.project.config.wizard.ImportProjectWizard;
import com.vmware.vide.project.config.wizard.NewProjectWizard;
import com.vmware.vide.project.config.wizard.WizardCategory;
import java.util.ArrayList;

public abstract class AbstractWizardType
extends AbstractContent {
    public static final String WIZARDTYPE_IMPORT_PROJECT = "import_project";
    public static final String WIZARDTYPE_NEW_PROJECT = "new_project";
    private static String[] wizardtypes = new String[]{"new_project", "import_project"};
    private static final String TAG_ID = "id";
    private static final String TAG_ENABLED = "enabled";
    private static final String TAG_EXPANDTREE = "expandtree";
    private String wizardtype;
    private DevkitInfo devkitinfo;
    private boolean expandtree;
    private ArrayList<WizardCategory> categories = new ArrayList();
    protected boolean isvalid = false;

    public AbstractWizardType(String type, DevkitInfo devkitinfo, Object configinfo) {
        this.wizardtype = type;
        this.devkitinfo = devkitinfo;
        this.refreshConfig(configinfo);
        if (this.devkitinfo != null && this.categories.size() > 0) {
            this.isvalid = true;
        }
    }

    public boolean isValid() {
        return this.isvalid;
    }

    public String getWizardType() {
        return this.wizardtype;
    }

    public String getDevkitName() {
        return this.devkitinfo.getName();
    }

    public String getDevkitId() {
        return this.devkitinfo.getId();
    }

    public DevkitInfo getDevkitInfo() {
        return this.devkitinfo;
    }

    public boolean isExpandTree() {
        return this.expandtree;
    }

    public void refreshConfig(Object info) {
        if (info == null) {
            return;
        }
        try {
            this.expandtree = ConfigUtil.lookupBoolean((Object)info, (String)TAG_EXPANDTREE, (String)"true", (boolean)false);
            ArrayList nodes = ConfigUtil.lookupList((Object)info, (String)"category");
            if (nodes != null) {
                int i = 0;
                while (i < nodes.size()) {
                    WizardCategory category = this.createCategory(this, nodes.get(i));
                    if (category != null && category.isValid()) {
                        this.categories.add(category);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public WizardCategory createCategory(AbstractWizardType wizardtype, Object config) {
        WizardCategory category = new WizardCategory(wizardtype, config);
        if (category.isValid()) {
            return category;
        }
        return null;
    }

    public static AbstractWizardType createWizardType(DevkitInfo devkit, Object config) {
        String type = ConfigUtil.lookupString((Object)config, (String)TAG_ID);
        if (type != null && ConfigUtil.lookupBoolean((Object)config, (String)TAG_ENABLED, (String)"true", (boolean)false)) {
            int i = 0;
            while (i < wizardtypes.length) {
                if (type.equals(wizardtypes[i])) {
                    if (type.equals(WIZARDTYPE_IMPORT_PROJECT)) {
                        return new ImportProjectWizard(devkit, config);
                    }
                    if (type.equals(WIZARDTYPE_NEW_PROJECT)) {
                        return new NewProjectWizard(devkit, config);
                    }
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public Object[] getChildren() {
        return this.categories.toArray(new WizardCategory[this.categories.size()]);
    }

    @Override
    public boolean hasChildren() {
        return this.categories.size() > 0;
    }

    @Override
    public String getText() {
        return String.valueOf(this.devkitinfo.getName()) + " " + this.devkitinfo.getVersion();
    }

    @Override
    public Object getParent() {
        return null;
    }
}

