/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.wizard.project;

import com.vmware.vide.init.ConfigUtil;
import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.config.devkit.ProjectNatureInfo;
import com.vmware.vide.project.config.devkit.ProjectProperty;
import com.vmware.vide.project.config.vib.UserInput;
import com.vmware.vide.project.config.vib.VIBData;
import com.vmware.vide.project.config.wizard.AbstractContent;
import com.vmware.vide.project.config.wizard.AbstractWizardData;
import com.vmware.vide.project.config.wizard.AbstractWizardType;
import com.vmware.vide.project.config.wizard.WizardCategory;
import com.vmware.vide.project.config.wizard.project.Builder;
import com.vmware.vide.project.config.wizard.project.IProjectDataAccessor;
import com.vmware.vide.project.config.wizard.project.ProjectCommand;
import com.vmware.vide.project.config.wizard.project.ProjectCommandRunner;
import com.vmware.vide.project.config.wizard.project.ProjectFile;
import com.vmware.vide.project.config.wizard.project.ProjectOption;
import com.vmware.vide.project.config.wizard.project.Template;
import com.vmware.vide.project.utils.Utils;
import com.vmware.vide.project.utils.VIDEProjectException;
import com.vmware.vide.utils.net.HttpLogger;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.Deflater;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.internal.signedcontent.Base64;
import org.eclipse.osgi.service.datalocation.Location;

public class ProjectData
extends AbstractWizardData {
    private static final ILog logger = ProjectPlugin.getDefault().getLog();
    public static final String TAG_INITPATH = "initpath";
    public static final String TAG_PROJPATH = "projpath";
    public static final String TAG_PROJNATURE = "project_nature";
    public static final String TAG_PROJFILE_EXTENSION = "projectfile_extension";
    public static final String TAG_PROJFILE_REQCONTENT = "projectfile_requiredcontent";
    public static final String TAG_PROJFILE_DIRECTORY = "projectfile_directory";
    public static final String TAG_PROJECT_DESTPATH = "project_destpath";
    public static final String TAG_INVALID_PROJECT_PATH = "invalid_project_path";
    public static final String TAG_CREATE_VIBXML = "create_vibxml";
    public static final String TAG_PROJECT_FILE = "projectfile";
    public static final String TAG_TEMPLATE_FILE = "templatefile";
    public static final String TAG_USER_INPUT = "userinput";
    public static final String TAG_SOURCEPATH = "sourcepath";
    public static final String TAG_DEFAULTBUILDTARGET = "defaultbuildtarget";
    public static final String TAG_FILE = "file";
    public static final String TAG_FILE_PERMISSION = "file_permission";
    public static final String TAG_TYPE = "type";
    public static final String TAG_DESTPATH = "destpath";
    public static final String TAG_DESTFILENAME = "destfilename";
    public static final String TAG_RECURSIVE = "recursive";
    public static final String TAG_REPLACE_TEXT = "replacetext";
    public static final String TAG_PROPERTY_VAR = "property_variable";
    public static final String TAG_TEXT_PATTERN = "text_pattern";
    public static final String TAG_REPLACE_PATTERN = "replace_pattern";
    public static final String TAG_TITLE = "title";
    public static final String TAG_DESC = "description";
    public static final String TAG_DEFAULT = "default";
    public static final String TAG_INPUT_PATTERN = "input_pattern";
    public static final String TAG_INPUT_VALUES = "input_values";
    public static final String TAG_APPENDLINE_BEFORE = "appendline_before";
    public static final String TAG_APPENDLINE_AFTER = "appendline_after";
    public static final String PROP_PROJECT_NAME = "PROJECT_NAME";
    public static final String PROP_RELATIVE_PROJECT_PATH = "RELATIVE_PROJECT_PATH";
    public static final String PROP_ABSOLUTE_PROJECT_PATH = "ABSOLUTE_PROJECT_PATH";
    public static final String PROP_PROJECT_INCLUDE_PATH = "INCLUDE_PATH";
    public static final String PROP_PROJECT_INCLUDE_FILE = "INCLUDE_FILE";
    public static final String PROP_CMACROS = "CMACROS";
    public static final String PROP_BUILD_OUTPUT_PATH = "BUILD_OUTPUT_PATH";
    public static final String PROP_WORKBENCH_INSTALLED_PATH = "WORKBENCH_INSTALLED_PATH";
    public static final String TAG_OPTION = "option";
    public static final String TAG_VALUE = "value";
    public static final String TAG_SORTRULE = "sortrule";
    public static final String TAG_VALIDITY = "validity";
    public static final String TAG_SEVERITY = "severity";
    public static final String TAG_INPUT_HELPER = "input_helper";
    public static final String TAG_CHECKBOX = "checkbox";
    public static final String TAG_CONDITION = "condition";
    public static final String TAG_PROPERTY = "property";
    public static final String TAG_PROPERTY_VALUE = "property_value";
    public static final String TAG_LINKEDRESOURCE_DESTPATH = "linkedresource_destpath";
    public static final String TAG_LINKEDRESOURCE_FILE = "linkedresource_file";
    public static final String TAG_ADDITONAL_PROJECTNATURE = "additional_projectnature";
    public static final String TAG_FILEFOUND = "filefound";
    public static final String TAG_FILENAME = "filename";
    public static final String TAG_EXTENSION = "extension";
    public static final String TAG_REQUIRED_CONTENT = "requiredcontent";
    public static final String TAG_REMOTE = "remote";
    public static final String TAG_BINARY = "binary";
    public static final String TAG_IGNORE_NO_SRC = "ignore_no_src";
    public static final String TAG_WHEN = "when";
    private static final String TAG_BUILDERS = "builders";
    private static final String TAG_BUILDERS_NAME = "name";
    private static final String TAG_BUILD = "build";
    private static final String TAG_BUILD_NAME = "name";
    private static final String TAG_BUILD_ARG = "arg";
    private static final String TAG_ARG_KEY = "key";
    private static final String TAG_ARG_VALUE = "value";
    private static final String TAG_BUILD_REFERENCE = "builders";
    private static final String PROP_EXT_NATURES = "EXT_NATURES";
    private static final String TAG_PROJECT_CONFIGURATOR = "project_configurator";
    private static final String TAG_PROJECT_VALIDATOR = "project_validator";
    private static final String TAG_COMMAND = "command";
    private static final String TAG_ARG = "arg";
    private static final String TAG_ID = "id";
    private static final String TAG_VALIDATE_PROJECT_NAME = "validate_project_name";
    private static final String TAG_ALLOW_START_LETTERS = "allow_start_letters";
    private static final String TAG_ALLOW_OTHER_LETTERS = "allow_other_letters";
    private static final String PROP_PROJECT_INFO_FILE_NAME = "PROJECT_INFO_FILE_NAME";
    private static final String PROP_PROJECT_INFO_FILE_LOCATION = "PROJECT_INFO_FILE_LOCATION";
    private static final String VALID_KEY = "VALID";
    private static final String IMPORT_PROJECT_DIR_KEY = "%IMPORT_PROJECT_DIR%";
    private static final String PROP_PROJECT_ID = "PROJECT_ID";
    private static final char TITLE_SEP = '\f';
    private static final String ERR_NO_BUILD_NODE = "No build node in builders node.";
    private static final String ERR_BUILDER_UNNAMED = "The builder is unnamed.";
    private static final String ERR_BAD_ARG_KEY_VALUE = "Missing key/value in the arg node for the build [%s].";
    private static final String ERR_CONFLICT_NODES = "Both name node [%s] and reference node [%s] are specified in the build node.";
    private static final String ERR_NO_NAME_NO_REFERENCE = "No name/reference node in build node.";
    private static final String ERR_MISSING_BUILDER = "Missing the referenced builder [%s].";
    public static final String QUALIFIER = "com.vmware.vide.project.ProjectData";
    private static final String[] projwizard_types = new String[]{"initpath", "projpath", "project_nature", "projectfile_extension", "projectfile", "projectfile_directory", "projectfile_requiredcontent", "project_destpath", "file_permission", "create_vibxml", "sourcepath", "defaultbuildtarget", "sortrule"};
    private static final String[] projwizard_required_types = new String[]{"initpath", "project_nature"};
    private static final String[] project_property_types = new String[]{"PROJECT_NAME", "RELATIVE_PROJECT_PATH", "ABSOLUTE_PROJECT_PATH"};
    private List<Template> templates;
    private VIBData vibdata;
    private Hashtable<String, ProjectOption> options;
    private LinkedHashMap<String, UserInput> orderedUserInputs;
    private boolean is_wizard_create_vib;
    private String current_project_name;
    private ArrayList<AdditionalProjectNature> additional_projnatures;
    private final Map<String, String> projectNaturePathProperties = new HashMap<String, String>();
    private Map<String, List<Builder>> builders;
    private List<ProjectCommand> configurators;
    private Map<String, String> configuratorProperties;
    private File projectFile;
    private List<ProjectCommand> validators;
    private Pattern validStartLetters;
    private Pattern validOtherLetters;
    private Pattern validProjectName;
    private boolean validationRulesExist;

    public ProjectData(WizardCategory parent, Object config) {
        super(parent, "projectinfo", config);
        this.parent = parent;
        this.vibdata = null;
        this.is_wizard_create_vib = false;
    }

    @Override
    public void refreshConfig(Object config) {
        super.refreshConfig(config);
        try {
            this.options = ProjectOption.getOptions(config);
            this.orderedUserInputs = UserInput.getOrderedUserInputs(config);
            this.templates = ProjectFile.getTemplates(config, this.getSourcePath());
            this.additional_projnatures = this.getAdditionalProjectNatures(config);
            this.builders = ProjectData.getBuilders(config, false);
            this.configurators = ProjectData.getProjectCommands(config, TAG_PROJECT_CONFIGURATOR);
            this.validators = ProjectData.getProjectCommands(config, TAG_PROJECT_VALIDATOR);
            String startLetters = this.getRegex(config, TAG_ALLOW_START_LETTERS);
            String otherLetters = this.getRegex(config, TAG_ALLOW_OTHER_LETTERS);
            if (startLetters != null && otherLetters != null) {
                Pattern namePattern;
                Pattern startPattern = this.compilePattern(startLetters);
                Pattern otherPattern = this.compilePattern(otherLetters);
                if (startPattern != null && otherPattern != null && (namePattern = this.compilePattern(String.valueOf(startLetters) + otherLetters)) != null) {
                    this.validStartLetters = startPattern;
                    this.validOtherLetters = otherPattern;
                    this.validProjectName = namePattern;
                    this.validationRulesExist = true;
                }
            } else if (startLetters != null || otherLetters != null) {
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", "Only one of <allow_start_letters> or <allow_other_letters> was specified. Must specify both of them."));
            }
            this.isvalid = true;
        }
        catch (Exception e) {
            this.isvalid = false;
            System.err.println(e.getMessage());
        }
    }

    public Pattern getValidStartLetters() {
        return this.validStartLetters;
    }

    public Pattern getValidLetters() {
        return this.validOtherLetters;
    }

    public Pattern getValidProjectName() {
        return this.validProjectName;
    }

    public boolean isValidationRulesExist() {
        return this.validationRulesExist;
    }

    private String getRegex(Object config, String tag) {
        String regex;
        ArrayList validationRules = ConfigUtil.lookupList((Object)config, (String)TAG_VALIDATE_PROJECT_NAME);
        if (validationRules != null && !validationRules.isEmpty() && (regex = ConfigUtil.lookupString((Object)validationRules, (String)tag)) != null) {
            return regex;
        }
        return null;
    }

    private Pattern compilePattern(String regex) {
        Pattern pattern = null;
        try {
            if (regex != null) {
                pattern = Pattern.compile(regex);
            }
        }
        catch (PatternSyntaxException e) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.project", "Invalid regular expression : '" + regex + "'" + e.getMessage()));
        }
        return pattern;
    }

    @Override
    public String[] getPropertyTypes() {
        return projwizard_types;
    }

    @Override
    public String[] getRequiredPropertyTypes() {
        return projwizard_required_types;
    }

    public boolean isWizardCreatedVIBfiles() {
        return this.is_wizard_create_vib;
    }

    public void setVIBfileCreationInWizard(boolean create) {
        this.is_wizard_create_vib = create;
    }

    public String getCurrentProjectName() {
        return this.current_project_name;
    }

    public void setCurrentProjectName(String name) {
        this.current_project_name = name;
    }

    public String getWizardTitle() {
        String roottitle = this.parent.getRootTitle();
        if (roottitle.equals(this.parent.getTitle())) {
            return roottitle;
        }
        return String.valueOf(roottitle) + " (" + this.parent.getTitle() + ")";
    }

    public String getInitPath() {
        return this.getProperty(TAG_INITPATH, true);
    }

    public String getProjectPath() {
        return this.getProperty(TAG_PROJPATH, true);
    }

    public String getSourcePath() {
        return this.getProperty(TAG_SOURCEPATH, true);
    }

    public String[] getProjectNature() {
        String[] stringArray;
        String id = this.getProperty(TAG_PROJNATURE, true);
        if (id == null) {
            stringArray = new String[]{};
        } else if (id.contains(",")) {
            stringArray = id.split(",");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = id;
        }
        return stringArray;
    }

    public String getProjectFileExt() {
        return this.getProperty(TAG_PROJFILE_EXTENSION, false);
    }

    public String getProjectFileDirectory() {
        return this.getProperty(TAG_PROJFILE_DIRECTORY, false);
    }

    public String getProjectFileName() {
        return this.getProperty(TAG_PROJECT_FILE, false);
    }

    public String getProjectFileReqContent() {
        return this.getProperty(TAG_PROJFILE_REQCONTENT, false);
    }

    public String getProjectDestPath() {
        return this.getProperty(TAG_PROJECT_DESTPATH, true);
    }

    public String getDefaultBuildTarget() {
        return this.getProperty(TAG_DEFAULTBUILDTARGET, false);
    }

    public boolean isProjectDestPathFixed() {
        String destpath = this.getProjectDestPath();
        return destpath != null && !destpath.isEmpty();
    }

    public String getFilePermissionText() {
        return this.getProperty(TAG_FILE_PERMISSION, true);
    }

    public File getProjectFile(File file, Map<String, String> props) {
        File projectFile = this.findMatchedFile(file, this.getProjectFileDirectory(), this.getProjectFileName(), this.getProjectFileExt(), this.getProjectFileReqContent());
        if (projectFile != null && this.validators != null && !this.runValidators(file, props)) {
            projectFile = null;
        }
        return projectFile;
    }

    public boolean isFileMatched(File file, String filename, String ext, String reqcontent) {
        String content;
        Path filepath;
        if ((filename == null || filename.isEmpty()) && (ext == null || ext.isEmpty())) {
            return false;
        }
        if (filename != null && !filename.isEmpty()) {
            String pattern = filename.replace(".", "\\.").replace("*", ".+");
            if (!file.getName().matches(pattern)) {
                return false;
            }
        }
        if (!(ext == null || ext.isEmpty() || (filepath = new Path(file.toString())).getFileExtension() != null && filepath.getFileExtension().equals(ext))) {
            return false;
        }
        return reqcontent == null || reqcontent.isEmpty() || (content = Utils.getFileContent(file, true)).indexOf(reqcontent) != -1;
    }

    private File findMatchedFile(File directory, String fixedpath, String filename, String extension, String reqcontent) {
        File[] filelist = directory.listFiles();
        int i = 0;
        while (i < filelist.length) {
            if (fixedpath != null && !fixedpath.isEmpty()) {
                if (filelist[i].isDirectory() && fixedpath.equals(filelist[i].getName())) {
                    File[] subfilelist = filelist[i].listFiles();
                    int j = 0;
                    while (j < subfilelist.length) {
                        if (subfilelist[j].isFile() && this.isFileMatched(subfilelist[j], filename, extension, reqcontent)) {
                            return subfilelist[j];
                        }
                        ++j;
                    }
                }
            } else if (filelist[i].isFile() && this.isFileMatched(filelist[i], filename, extension, reqcontent)) {
                return filelist[i];
            }
            ++i;
        }
        return null;
    }

    public String getDevkitProjectRootPath() {
        String root = this.getPropertyValue(ProjectProperty.getProjectRootPathPropertyID(), null);
        if (root != null) {
            root = Utils.replaceContent(root, this.getPropertyValues(null));
        }
        return root;
    }

    public String getParsedMessage(String message, String pattern, String pattern_value) {
        String searchpattern = "{{" + pattern + "}}";
        if (message == null || message.isEmpty() || pattern_value == null || message.indexOf(searchpattern) == -1) {
            return message;
        }
        return message.replace(searchpattern, pattern_value);
    }

    public List<Template> getTemplates() {
        ArrayList<Template> files = new ArrayList<Template>();
        files.addAll(this.parent.getTemplates());
        files.addAll(this.templates);
        return files;
    }

    public String getPropertyValue(String property, IProject project) {
        Hashtable<String, String> properties = this.getPropertyValues(project);
        if (properties.containsKey(property)) {
            return properties.get(property);
        }
        return null;
    }

    public IProject createIProject(String projectname, String projectpath, IProgressMonitor monitor) throws Exception {
        if (projectname == null || projectpath == null) {
            throw Utils.createProjectCreationException("Insufficient project information ", null);
        }
        IProject project = this.getDevkitInfo().getProjectIdentity().createIProject(projectname, projectpath, this.getPropertyValues(null), monitor);
        project.setSessionProperty(new QualifiedName("com.vmware.vide.project", "projectdata"), (Object)this);
        this.setExtraNatures(project, this.getPropertyValues(null));
        this.configureBuilders(project, this.getPropertyValues(null));
        String id = this.getPropertyValue(PROP_PROJECT_ID, null);
        String subProgramId = null;
        if (id != null && !id.isEmpty()) {
            StringBuilder sb = new StringBuilder("project_id=").append(id);
            subProgramId = sb.toString();
        } else {
            String titles = this.getTitles();
            if (titles != null) {
                id = this.encode(titles);
                if (id != null) {
                    StringBuilder sb = new StringBuilder("project_id=NOID:[").append(id).append(']');
                    subProgramId = sb.toString();
                }
            } else {
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", "Project has no title."));
            }
        }
        HttpLogger.logActivity((String)"devkits", (String)this.getDevkitInfo().getId(), (String)subProgramId);
        return project;
    }

    private void setExtraNatures(IProject project, Map<String, String> properties) throws CoreException {
        String[] extNatures;
        if (properties.containsKey(PROP_EXT_NATURES) && (extNatures = properties.get(PROP_EXT_NATURES).split("\\s*,\\s*")).length > 0 && !extNatures[0].isEmpty()) {
            String[] ids;
            ArrayList<String> natures = new ArrayList<String>();
            IProjectDescription desc = project.getDescription();
            String[] stringArray = ids = desc.getNatureIds();
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (!this.findInArray(id, extNatures)) {
                    natures.add(id);
                }
                ++n2;
            }
            HashSet<String> existingNatures = new HashSet<String>();
            Object[] objectArray = ResourcesPlugin.getWorkspace().getNatureDescriptors();
            int n3 = objectArray.length;
            n = 0;
            while (n < n3) {
                IProjectNatureDescriptor natureDesc = objectArray[n];
                existingNatures.add(natureDesc.getNatureId());
                ++n;
            }
            objectArray = extNatures;
            n3 = extNatures.length;
            n = 0;
            while (n < n3) {
                IProjectNatureDescriptor n4 = objectArray[n];
                if (existingNatures.contains(n4)) {
                    natures.add((String)n4);
                } else {
                    String msg = String.format("The project nature [%s] does not exist.", n4);
                    logger.log((IStatus)new Status(2, "com.vmware.vide.project", msg));
                }
                ++n;
            }
            desc.setNatureIds(natures.toArray(new String[natures.size()]));
            project.setDescription(desc, null);
        }
    }

    private boolean findInArray(String s, String[] array) {
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (a.equals(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void configureBuilders(IProject project, Map<String, String> properties) throws CoreException {
        if (!this.builders.isEmpty()) {
            ArrayList<ICommand> cmds = new ArrayList<ICommand>();
            IProjectDescription desc = project.getDescription();
            for (List<Builder> builds : this.builders.values()) {
                this.addBuildCommands(cmds, builds, desc);
            }
            desc.setBuildSpec(cmds.toArray(new ICommand[cmds.size()]));
            project.setDescription(desc, null);
        }
    }

    private List<ICommand> getReferencedBuilders(String buildersName, IProjectDescription desc) {
        ArrayList<ICommand> cmds = new ArrayList<ICommand>();
        if (this.parent instanceof WizardCategory) {
            List<Builder> builds = this.parent.lookupBuilders(buildersName);
            this.addBuildCommands(cmds, builds, desc);
        }
        return cmds;
    }

    private void addBuildCommands(List<ICommand> cmds, List<Builder> builds, IProjectDescription desc) {
        for (Builder build : builds) {
            if (build.isReference()) {
                List<ICommand> refs = this.getReferencedBuilders(build.getReference(), desc);
                if (refs == null || refs.isEmpty()) {
                    System.err.println(String.format(ERR_MISSING_BUILDER, build.getReference()));
                    continue;
                }
                cmds.addAll(refs);
                continue;
            }
            cmds.add(this.newCommand(build, desc));
        }
    }

    private ICommand newCommand(Builder builder, IProjectDescription desc) {
        ICommand cmd = desc.newCommand();
        cmd.setBuilderName(builder.getName());
        if (builder.hasArguments()) {
            HashMap<String, String> args = new HashMap<String, String>();
            for (Map<String, String> arg : builder.getArguments()) {
                args.putAll(arg);
            }
            cmd.setArguments(args);
        }
        return cmd;
    }

    private String[] getInvalidProjectPath() {
        String pathstring = this.getProperty(TAG_INVALID_PROJECT_PATH, true);
        if (pathstring != null && !pathstring.isEmpty()) {
            if ((pathstring = Utils.replaceContent(pathstring, this.getPropertyValues(null))).indexOf(",") != -1) {
                return pathstring.split(",");
            }
            return new String[]{pathstring};
        }
        return new String[0];
    }

    public boolean isValidProjectPath(String projpath) {
        if (projpath == null || projpath.isEmpty()) {
            return false;
        }
        String[] invalidpaths = this.getInvalidProjectPath();
        if (invalidpaths.length > 0) {
            String[] stringArray = invalidpaths;
            int n = invalidpaths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                if (path.trim().equals(projpath.trim())) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public void configureProject(IProject project, File projectfile, boolean onFinish, IProgressMonitor monitor) throws VIDEProjectException {
        if (project == null) {
            throw Utils.createProjectCreationException("Insufficient project information ", null);
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                String MONITOR_TASK = "Configure " + project.getName();
                monitor.beginTask(MONITOR_TASK, 100);
                Hashtable<String, String> projectInfo = this.getPropertyValues(project);
                if (projectfile != null) {
                    projectInfo.put(PROP_PROJECT_INFO_FILE_NAME, projectfile.getName());
                    projectInfo.put(PROP_PROJECT_INFO_FILE_LOCATION, projectfile.getParentFile().getAbsolutePath());
                }
                this.runConfigurators(project, projectInfo, monitor);
                monitor.worked(10);
                ProjectNatureInfo[] projectnatures = this.getDevkitInfo().getProjectNatureInfo(this.getProjectNature());
                monitor.worked(40);
                this.getDevkitInfo().getProjectIdentity().configureProject(project, projectfile, projectnatures, this.getPropertyValues(project), onFinish, monitor);
                monitor.worked(30);
                this.getDevkitInfo().updateProjectNature(this.getProjectNature(), project, null);
                this.getDevkitInfo().getProjectIdentity().putProjectProperties(project, this.getPropertyValues(project), true);
            }
            catch (Exception e) {
                throw Utils.createProjectCreationException("Failed to create the project ", e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public File createProjectDirectory(IProject project) throws VIDEProjectException {
        List<Template> templs = this.getTemplates();
        if (templs == null || templs.isEmpty()) {
            return null;
        }
        List<ProjectFile> projectfiles = ProjectFile.getProjectFiles(project, templs, this);
        if (projectfiles == null || projectfiles.isEmpty()) {
            return null;
        }
        Hashtable<String, String> properties = this.getPropertyValues(project);
        File projfile = null;
        int i = 0;
        while (i < projectfiles.size()) {
            ProjectFile file = projectfiles.get(i);
            if (file.isFileNeeded(this, project)) {
                File destfile = file.copyFileToProjectDir(this, project, properties);
                if (destfile == null) {
                    throw Utils.createProjectCreationException("Unable to create the file ", null);
                }
                if (file.isProjectFile()) {
                    projfile = destfile;
                }
            }
            ++i;
        }
        return projfile;
    }

    public Hashtable<String, ProjectOption> getProjectOptions() {
        Hashtable<String, ProjectOption> opts = new Hashtable<String, ProjectOption>();
        if (this.parent != null) {
            opts.putAll(this.parent.getAllProjectOptions());
        }
        opts.putAll(this.options);
        return opts;
    }

    public Hashtable<String, ProjectOption> getOptions() {
        return this.options;
    }

    public Hashtable<String, String> getPropertyValues(IProject project) {
        String string;
        LinkedHashMap<String, ProjectProperty> projectprops;
        final Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.putAll(AbstractWizardData.globalInfo);
        if (project != null) {
            int i = 0;
            while (i < project_property_types.length) {
                IPath path;
                Path ipath;
                String devkitpath;
                String value = null;
                if (project_property_types[i].equals(PROP_PROJECT_NAME)) {
                    value = project.getName();
                } else if (project_property_types[i].equals(PROP_ABSOLUTE_PROJECT_PATH)) {
                    value = project.getLocation().toOSString();
                } else if (project_property_types[i].equals(PROP_RELATIVE_PROJECT_PATH) && (devkitpath = this.getDevkitProjectRootPath()) != null && !devkitpath.isEmpty() && (ipath = new Path(devkitpath)).isPrefixOf(path = project.getLocation())) {
                    value = path.removeFirstSegments(ipath.segmentCount() - 1).makeRelative().toOSString();
                }
                if (value != null && !value.isEmpty()) {
                    properties.put(project_property_types[i], value);
                }
                ++i;
            }
        } else if (this.current_project_name != null && !this.current_project_name.isEmpty()) {
            properties.put(PROP_PROJECT_NAME, this.current_project_name);
        }
        Location loc = Platform.getInstallLocation();
        if (loc == null) {
            throw new IllegalStateException("Cannot get the Eclipse installed location.");
        }
        String installedPath = new Path(loc.getURL().getFile()).removeTrailingSeparator().toOSString();
        properties.put(PROP_WORKBENCH_INSTALLED_PATH, installedPath);
        Map<String, String> systemprops = this.getDevkitInfo().getSystemProperties();
        if (systemprops != null) {
            for (String name : systemprops.keySet()) {
                String string2 = systemprops.get(name);
                if (string2 == null || string2.isEmpty()) continue;
                properties.put(name, string2);
            }
        }
        if ((projectprops = this.getDevkitInfo().getOrderedProjectProperties(this.getProjectNature())) != null) {
            for (String string3 : projectprops.keySet()) {
                String string4 = projectprops.get(string3).getValue();
                if (string4 == null) continue;
                properties.put(string3, string4);
            }
        }
        for (Map.Entry<String, String> ent : this.projectNaturePathProperties.entrySet()) {
            properties.put(ent.getKey(), ent.getValue());
        }
        Hashtable<String, ProjectOption> opts = this.getProjectOptions();
        for (String string5 : opts.keySet()) {
            String value = opts.get(string5).getValue();
            if (value == null) continue;
            properties.put(string5, value);
        }
        LinkedHashMap<String, UserInput> linkedHashMap = this.getOrderedUserInputs();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            UserInput input = (UserInput)entry.getValue();
            if (!input.isUserInputEnabled()) continue;
            String value = input.getValue();
            if (value != null && !value.isEmpty()) {
                properties.put((String)entry.getKey(), value);
            }
            if (!input.hasMultipleValues()) continue;
            for (Map.Entry<String, String> e : input.getValues().entrySet()) {
                properties.put(e.getKey(), e.getValue());
            }
        }
        if (this.configuratorProperties != null && !this.configuratorProperties.isEmpty()) {
            properties.putAll(this.configuratorProperties);
        }
        if ((string = this.getDefaultBuildTarget()) != null && !string.isEmpty()) {
            properties.put(ProjectProperty.getDefaultBuildTargetPropertyID(), string);
        }
        if (projectprops != null) {
            for (String name : projectprops.keySet()) {
                if (properties.containsKey(name)) continue;
                IProjectDataAccessor accessor = new IProjectDataAccessor(){

                    @Override
                    public File getFirstFindProjectFile() {
                        return ProjectData.this.getProjectFileInTemplate(properties);
                    }

                    @Override
                    public Map<String, String> getCurrentProperties() {
                        return properties;
                    }
                };
                String value = projectprops.get(name).getValue(accessor);
                if (value == null) continue;
                properties.put(name, value);
            }
        }
        return properties;
    }

    private File getProjectFileInTemplate(Map<String, String> properties) {
        if (this.projectFile != null) {
            return this.projectFile;
        }
        File srcpathfile = null;
        for (Template t : this.getTemplates()) {
            String[] patterns;
            String srcpath = this.replace(t.getSourcepath(), properties);
            if (t.isRemote()) continue;
            String rootsrcpath = this.replace(t.getBaseSourcePath(), properties);
            if (srcpath != null) {
                if (srcpathfile == null || !srcpathfile.toString().equals(srcpath)) {
                    srcpathfile = new File(srcpath);
                }
            } else if (srcpathfile == null && rootsrcpath != null) {
                srcpathfile = new File(rootsrcpath);
            }
            if (!t.isProjectfile()) continue;
            File[] files = srcpathfile.listFiles();
            if (files != null && (patterns = t.getFile().split(";")) != null && !patterns[0].isEmpty()) {
                Pattern p = Pattern.compile(patterns[0]);
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (p.matcher(f.getName()).matches()) {
                        this.projectFile = f;
                        return f;
                    }
                    ++n2;
                }
            }
            if (!t.ignoreNoSrc()) {
                ILog log = ProjectPlugin.getDefault().getLog();
                String msg = String.format("Could not find the project file [%s].", t.getFile());
                Status status = new Status(2, "com.vmware.vide.project", msg);
                log.log((IStatus)status);
            }
            return null;
        }
        return null;
    }

    private String replace(String contents, Map<String, String> properties) {
        if (contents == null) {
            return null;
        }
        return Utils.replaceContent(contents, properties);
    }

    public void setProjectNatureProperty(String name, String value) {
        this.projectNaturePathProperties.put(name, value);
    }

    public VIBData getVIBData() {
        ArrayList<VIBData> data;
        if (this.vibdata != null) {
            return this.vibdata;
        }
        String devkitid = null;
        Object pwizard = this.parent;
        while (pwizard instanceof WizardCategory) {
            pwizard = ((WizardCategory)pwizard).getParent();
        }
        if (pwizard != null && pwizard instanceof AbstractWizardType && (devkitid = ((AbstractWizardType)pwizard).getDevkitId()) != null && (data = ProjectPlugin.getConfig().getVIBData(devkitid)) != null && data.size() > 0) {
            this.vibdata = data.get(0).clone();
        }
        return this.vibdata;
    }

    public void createVIBFiles(IProject project) throws VIDEProjectException {
        VIBData vdata = this.getVIBData();
        if (vdata == null) {
            throw Utils.createFileAccessException("Insufficient project information ", null);
        }
        vdata.createVIBFiles(project, this.getPropertyValues(project));
    }

    public void saveVIBData(IProject project) throws VIDEProjectException {
        VIBData vdata = this.getVIBData();
        if (vdata == null) {
            throw Utils.createFileAccessException("Insufficient project information ", null);
        }
        vdata.saveVIBData(project);
    }

    public static boolean isProjectInWorkspace(String projectName) {
        if (projectName == null) {
            return false;
        }
        IProject[] workspaceProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < workspaceProjects.length) {
            if (projectName.equals(workspaceProjects[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public LinkedHashMap<String, UserInput> getOrderedUserInputs() {
        LinkedHashMap<String, UserInput> inputs = new LinkedHashMap<String, UserInput>();
        inputs.putAll(this.orderedUserInputs);
        LinkedHashMap<String, UserInput> parentinputs = this.parent.getOrderedUserInputs();
        for (UserInput input : parentinputs.values()) {
            if (inputs.containsKey(input.getOptionVariable())) continue;
            inputs.put(input.getOptionVariable(), input);
        }
        return inputs;
    }

    public boolean addAdditionalProjectNatures(IProject project) {
        boolean result = true;
        if (this.additional_projnatures.size() > 0) {
            for (AdditionalProjectNature nature : this.additional_projnatures) {
                if (!nature.isSatisfied(project) || this.getDevkitInfo().updateProjectNature(new String[]{nature.getProjectNatureID()}, project, null)) continue;
                result = false;
            }
        }
        return result;
    }

    private ArrayList<AdditionalProjectNature> getAdditionalProjectNatures(Object config) {
        ArrayList<AdditionalProjectNature> natures = new ArrayList<AdditionalProjectNature>();
        ArrayList nodes = ConfigUtil.lookupList((Object)config, (String)TAG_ADDITONAL_PROJECTNATURE);
        if (nodes == null || nodes.size() == 0) {
            return natures;
        }
        for (Object node : nodes) {
            String when;
            String natureid = ConfigUtil.lookupString(node, (String)TAG_PROJNATURE);
            AdditionalProjectNature nature = new AdditionalProjectNature(natureid, when = ConfigUtil.lookupString(node, (String)TAG_WHEN), node);
            if (!nature.isValid()) continue;
            natures.add(nature);
        }
        return natures;
    }

    public static Map<String, List<Builder>> getBuilders(Object config, boolean named) {
        LinkedHashMap<String, List<Builder>> builders = new LinkedHashMap<String, List<Builder>>();
        ArrayList nodes = ConfigUtil.lookupList((Object)config, (String)"builders");
        if (nodes != null && nodes.size() > 0) {
            int nameCount = 0;
            for (Object n : nodes) {
                String buildersName = ConfigUtil.lookupString(n, (String)"name");
                if (named && (buildersName == null || buildersName.isEmpty())) {
                    System.err.println(ERR_BUILDER_UNNAMED);
                    continue;
                }
                ArrayList buildNodes = ConfigUtil.lookupList(n, (String)TAG_BUILD);
                if (buildNodes == null || buildNodes.isEmpty()) {
                    System.err.println(ERR_NO_BUILD_NODE);
                    continue;
                }
                ArrayList<Builder> builds = new ArrayList<Builder>();
                for (Object b : buildNodes) {
                    String name = ConfigUtil.lookupString(b, (String)"name");
                    String reference = ConfigUtil.lookupString(b, (String)"builders");
                    if (name != null && reference != null) {
                        System.err.println(String.format(ERR_CONFLICT_NODES, name, reference));
                        continue;
                    }
                    if (name != null && !name.isEmpty()) {
                        ArrayList<Map<String, String>> args = new ArrayList<Map<String, String>>();
                        ArrayList argNodes = ConfigUtil.lookupList(b, (String)"arg");
                        if (argNodes != null && argNodes.size() > 0) {
                            for (Object argNode : argNodes) {
                                String key = ConfigUtil.lookupString(argNode, (String)TAG_ARG_KEY);
                                String val = ConfigUtil.lookupString(argNode, (String)"value");
                                if (key != null && !key.isEmpty() && val != null) {
                                    HashMap<String, String> m = new HashMap<String, String>();
                                    m.put(key, val);
                                    args.add(m);
                                    continue;
                                }
                                System.err.println(String.format(ERR_BAD_ARG_KEY_VALUE, name));
                            }
                        }
                        builds.add(new Builder(name, args));
                    } else if (reference != null && !reference.isEmpty()) {
                        builds.add(new Builder(reference));
                    } else {
                        System.err.println(ERR_NO_NAME_NO_REFERENCE);
                    }
                    if (buildersName == null || buildersName.isEmpty()) {
                        buildersName = "Unnamed" + nameCount;
                        ++nameCount;
                    }
                    builders.put(buildersName, builds);
                }
            }
        }
        return builders;
    }

    public static List<ProjectCommand> getProjectConfigurators(Object config) {
        return ProjectData.getProjectCommands(config, TAG_PROJECT_CONFIGURATOR);
    }

    public static List<ProjectCommand> getProjectValidators(Object config) {
        return ProjectData.getProjectCommands(config, TAG_PROJECT_VALIDATOR);
    }

    private static List<ProjectCommand> getProjectCommands(Object config, String tag) {
        ArrayList<ProjectCommand> configs = null;
        ArrayList nodes = ConfigUtil.lookupList((Object)config, (String)tag);
        if (nodes != null && nodes.size() > 0) {
            ArrayList cmd_nodes = ConfigUtil.lookupList((Object)nodes, (String)TAG_COMMAND);
            for (Object cmd : cmd_nodes) {
                if (configs == null) {
                    configs = new ArrayList<ProjectCommand>();
                }
                String command = null;
                ArrayList<String> args = new ArrayList<String>();
                for (Map elem : (List)cmd) {
                    if (elem.containsKey(TAG_ID)) {
                        if (command == null) {
                            command = (String)elem.get(TAG_ID);
                            continue;
                        }
                        String msg = String.format("An extra id [%s] is specified in a command element. Ignoring the extra id.", elem.get(TAG_ID));
                        logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                        continue;
                    }
                    if (!elem.containsKey("arg")) continue;
                    args.add((String)elem.get("arg"));
                }
                if (command == null) {
                    logger.log((IStatus)new Status(4, "com.vmware.vide.project", "No id is specified in a command element."));
                    continue;
                }
                configs.add(new ProjectCommand(command, args));
            }
        }
        return configs;
    }

    private List<ProjectCommand> collectConfigurators() {
        ArrayList<ProjectCommand> confs = new ArrayList<ProjectCommand>();
        Object o = this.parent;
        while (o != null) {
            WizardCategory c;
            List<ProjectCommand> configs;
            if (o instanceof WizardCategory && (configs = (c = o).getConfigurators()) != null) {
                confs.addAll(0, c.getConfigurators());
            }
            o = ((AbstractContent)o).getParent();
        }
        if (this.configurators != null) {
            confs.addAll(this.configurators);
        }
        return confs;
    }

    private void runConfigurators(IProject project, Map<String, String> properties, IProgressMonitor monitor) {
        List<ProjectCommand> configurators = this.collectConfigurators();
        if (configurators.isEmpty()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)configurators.size());
        for (ProjectCommand config : configurators) {
            ProjectCommandRunner runner = ProjectCommandRunner.createProjectCommandRunner(project, config, properties);
            runner.start();
            Map<String, String> configProperties = runner.getProjectCommandProperties();
            if (configProperties != null) {
                if (this.configuratorProperties == null) {
                    this.configuratorProperties = new HashMap<String, String>();
                }
                this.configuratorProperties.putAll(configProperties);
            }
            progress.worked(1);
        }
    }

    public void cleanConfiguratorProperties() {
        if (this.configuratorProperties != null) {
            this.configuratorProperties.clear();
        }
    }

    private boolean isValidProjectDirectory(Map<String, String> properties) {
        return properties != null && properties.containsKey(VALID_KEY) && Boolean.parseBoolean(properties.get(VALID_KEY));
    }

    private boolean runValidators(File file, Map<String, String> properties) {
        properties.put(IMPORT_PROJECT_DIR_KEY, file.getAbsolutePath());
        for (ProjectCommand validator : this.validators) {
            ProjectCommandRunner runner = ProjectCommandRunner.createProjectCommandRunner(null, validator, properties);
            runner.start();
            Map<String, String> cmdProperties = runner.getProjectCommandProperties();
            if (this.isValidProjectDirectory(cmdProperties)) continue;
            return false;
        }
        return true;
    }

    public boolean hasValidators() {
        return this.validators != null;
    }

    private String getTitles() {
        LinkedList<String> titleList = new LinkedList<String>();
        Object o = this.getParent();
        while (o instanceof WizardCategory) {
            WizardCategory wizardCategory = (WizardCategory)o;
            String title = wizardCategory.getTitle();
            if (title != null && !title.isEmpty()) {
                titleList.addFirst(title);
            }
            o = wizardCategory.getParent();
        }
        if (titleList.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder((String)titleList.removeFirst());
        for (String title : titleList) {
            sb.append('\f');
            sb.append(title);
        }
        return sb.toString();
    }

    private String encode(String str) {
        try {
            byte[] data = str.getBytes("UTF-8");
            Deflater deflater = new Deflater();
            deflater.setInput(data);
            deflater.finish();
            byte[] out = new byte[data.length << 1];
            int len = deflater.deflate(out);
            byte[] bytes = Arrays.copyOf(out, len);
            return this.base64encode(bytes);
        }
        catch (UnsupportedEncodingException e) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.project", "Failed to encode.", (Throwable)e));
            return null;
        }
    }

    private String base64encode(byte[] bytes) {
        byte[] out = Base64.encode((byte[])bytes);
        StringBuilder sb = new StringBuilder();
        byte[] byArray = out;
        int n = out.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append((char)b);
            ++n2;
        }
        return sb.toString();
    }

    public class AdditionalProjectNature {
        final String CONDITION_FILEFOUND = "filefound";
        final String WHEN_ALLCONDITION = "allcondition";
        final String WHEN_ANYCONDITION = "anycondition";
        private final String natureid;
        private final String when;
        ArrayList<Condition> conditions;

        public AdditionalProjectNature(String natureid, String when, Object config) {
            this.natureid = natureid;
            this.when = when == null ? "allcondition" : when;
            this.conditions = this.getConditions(config);
        }

        public boolean isValid() {
            return this.natureid != null && !this.natureid.isEmpty();
        }

        public String getProjectNatureID() {
            return this.natureid;
        }

        public boolean isSatisfied(IProject project) {
            if (this.conditions.size() == 0) {
                return true;
            }
            if (this.when.equals("anycondition")) {
                boolean result = false;
                for (Condition condition : this.conditions) {
                    if (!condition.isSatisfied(project)) continue;
                    result = true;
                    break;
                }
                return result;
            }
            for (Condition condition : this.conditions) {
                if (condition.isSatisfied(project)) continue;
                return false;
            }
            return true;
        }

        public ArrayList<Condition> getConditions(Object config) {
            ArrayList<Condition> conds = new ArrayList<Condition>();
            ArrayList nodes = ConfigUtil.lookupList((Object)config, (String)ProjectData.TAG_CONDITION);
            if (nodes == null || nodes.size() == 0) {
                return this.conditions;
            }
            for (Object node : nodes) {
                ArrayList filefoundnodes = ConfigUtil.lookupList(node, (String)ProjectData.TAG_FILEFOUND);
                if (filefoundnodes == null || filefoundnodes.size() <= 0) continue;
                for (Object filefoundnode : filefoundnodes) {
                    String filename = ConfigUtil.lookupString(filefoundnode, (String)ProjectData.TAG_FILENAME);
                    String content = ConfigUtil.lookupString(filefoundnode, (String)ProjectData.TAG_REQUIRED_CONTENT);
                    if (filename != null && !filename.isEmpty()) {
                        FileFoundCondition cond = new FileFoundCondition(filename, content);
                        conds.add(cond);
                        continue;
                    }
                    System.err.println("no file information in the filefound tag");
                }
            }
            return conds;
        }

        public abstract class Condition {
            public String conditiontype;

            public Condition(String type) {
                this.conditiontype = type;
            }

            public abstract boolean isSatisfied(IProject var1);
        }

        private class FileFoundCondition
        extends Condition {
            private final String filename;
            private final String requiredcontent;

            public FileFoundCondition(String filename, String requiredcontent) {
                super(ProjectData.TAG_FILEFOUND);
                this.filename = filename;
                this.requiredcontent = requiredcontent;
            }

            @Override
            public boolean isSatisfied(IProject project) {
                return ProjectData.this.findMatchedFile(project.getLocation().toFile(), null, this.filename, null, this.requiredcontent) != null;
            }
        }
    }
}

