/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.editor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.XMLContentDescriber;

public class HostExtensionPluginXMLDescriber
extends XMLContentDescriber {
    public int describe(InputStream input, IContentDescription description) throws IOException {
        HashMap properties = new HashMap();
        int result = 0;
        String charsetKey = null;
        String bomKey = null;
        try {
            Class<XMLContentDescriber> c = XMLContentDescriber.class;
            Method m = null;
            m = c.getDeclaredMethod("describe2", InputStream.class, IContentDescription.class, Map.class);
            m.setAccessible(true);
            result = (Integer)m.invoke((Object)this, input, description, properties);
            Field f = c.getDeclaredField("CHARSET");
            f.setAccessible(true);
            charsetKey = (String)f.get(null);
            f = c.getDeclaredField("BOM");
            f.setAccessible(true);
            bomKey = (String)f.get(null);
        }
        catch (SecurityException e) {
            throw new IOException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        catch (InvocationTargetException e) {
            throw new IOException(e);
        }
        catch (NoSuchFieldException e) {
            throw new IOException(e);
        }
        if (result != 2) {
            return result;
        }
        if (charsetKey != null && properties.containsKey(charsetKey) && !((String)properties.get(charsetKey)).equals("UTF-8")) {
            return 0;
        }
        String encoding = "UTF-8";
        if (bomKey != null && properties.containsKey(bomKey)) {
            byte[] bom = (byte[])properties.get(bomKey);
            if (Arrays.equals(bom, IContentDescription.BOM_UTF_16BE)) {
                encoding = "UTF-16BE";
            } else if (Arrays.equals(bom, IContentDescription.BOM_UTF_16LE)) {
                encoding = "UTF-16LE";
            } else if (Arrays.equals(bom, IContentDescription.BOM_UTF_8)) {
                encoding = "UTF-8";
            } else {
                return 0;
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, encoding));
        return this.checkElements(reader);
    }

    public int describe(Reader input, IContentDescription description) throws IOException {
        int result = super.describe(input, description);
        if (result != 2) {
            return result;
        }
        BufferedReader reader = new BufferedReader(input);
        return this.checkElements(reader);
    }

    private int checkElements(BufferedReader reader) throws IOException {
        String line;
        boolean foundPlugin = false;
        boolean foundVersion = false;
        boolean foundNamespaces = false;
        int limitLine = 50;
        while ((line = reader.readLine()) != null) {
            if (limitLine > 0) {
                --limitLine;
            } else if (!foundNamespaces) {
                return 0;
            }
            if (line.contains("<plugin ") || line.contains("<plugin>")) {
                if (foundPlugin || foundVersion || foundNamespaces) {
                    return 0;
                }
                foundPlugin = true;
            }
            if (line.contains("<version>")) {
                if (!foundPlugin || foundVersion || foundNamespaces) {
                    return 0;
                }
                foundVersion = true;
            }
            if (line.contains("<namespaces>")) {
                if (!foundPlugin || !foundVersion || foundNamespaces) {
                    return 0;
                }
                foundNamespaces = true;
            }
            if (!line.contains("<commands>")) continue;
            if (!(foundPlugin && foundVersion && foundNamespaces)) {
                return 0;
            }
            return 2;
        }
        return 0;
    }
}

