/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.manager;

import com.vmware.vide.project.manager.ProjectDescription;
import com.vmware.vide.project.manager.ProjectManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class DevkitProjectDescription
extends ProjectDescription {
    public static final String PROJECTTYPE_DEVKIT = "com.vmware.vide.core.vproj.devkit";
    private static final String PROPERTY_DEVKITID = "DEVKIT_ID";
    private static final String PROPERTY_DEVKITTYPE = "DEVKIT_TYPE";

    public DevkitProjectDescription(IProject project) {
        super(project);
        ProjectManager.getDefault().addProjectNature(project, "com.vmware.vide.core.devkitnature");
    }

    public DevkitProjectDescription(IProject project, String natureid, String devkitid, String devkittype) {
        this(project);
        if (natureid != null && !natureid.isEmpty()) {
            ProjectManager.getDefault().addProjectNature(project, natureid);
        }
        if (devkitid != null && !devkitid.isEmpty()) {
            this.putProperty(PROPERTY_DEVKITID, devkitid, false);
            try {
                project.setPersistentProperty(new QualifiedName("com.vmware.vide.project", PROPERTY_DEVKITID), devkitid);
            }
            catch (CoreException coreException) {}
        }
        if (devkittype != null && !devkittype.isEmpty()) {
            this.putProperty(PROPERTY_DEVKITTYPE, devkittype, false);
            try {
                project.setPersistentProperty(new QualifiedName("com.vmware.vide.project", PROPERTY_DEVKITTYPE), devkittype);
            }
            catch (CoreException coreException) {}
        }
    }

    public String getDevkitId() {
        String id = null;
        try {
            id = this.getProject().getPersistentProperty(new QualifiedName("com.vmware.vide.project", PROPERTY_DEVKITID));
        }
        catch (CoreException coreException) {}
        if (id == null) {
            id = this.getProperty(PROPERTY_DEVKITID);
            try {
                this.getProject().setPersistentProperty(new QualifiedName("com.vmware.vide.project", PROPERTY_DEVKITID), id);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return id;
    }

    public String getDevkitType() {
        String t = null;
        try {
            t = this.getProject().getPersistentProperty(new QualifiedName("com.vmware.vide.project", PROPERTY_DEVKITTYPE));
        }
        catch (CoreException coreException) {}
        if (t == null) {
            t = this.getProperty(PROPERTY_DEVKITTYPE);
            try {
                this.getProject().setPersistentProperty(new QualifiedName("com.vmware.vide.project", PROPERTY_DEVKITTYPE), t);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return t;
    }
}

