/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.manager;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.manager.AbstractProjectIdentity;
import com.vmware.vide.project.manager.DevkitProjectDescription;
import com.vmware.vide.project.manager.ProjectDescription;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class ProjectManager {
    private static final ILog logger = ProjectPlugin.getDefault().getLog();
    public static final String NATUREID_VPROJECT = "com.vmware.vide.core.vnature";
    public static final String NATUREID_DEVKITPROJECT = "com.vmware.vide.core.devkitnature";
    private static final String EXTPOINT_PROJECTIDENTITY = "projectidentity";
    private HashMap<String, AbstractProjectIdentity> projectidentities;
    private static ProjectManager projectmanager = new ProjectManager();
    private static HashMap<IProject, DevkitProjectDescription> devkitProjectDescriptions = new HashMap();

    public static ProjectManager getDefault() {
        return projectmanager;
    }

    public ProjectDescription createVMwareDevkitProjectNature(IProject project, String natureid, String devkitid, String type) {
        DevkitProjectDescription desc = null;
        if (this.hasProjectNature(project, natureid)) {
            desc = this.getDevkitProjectDescription(project);
        } else {
            try {
                desc = new DevkitProjectDescription(project, natureid, devkitid, type);
                devkitProjectDescriptions.put(project, desc);
            }
            catch (IllegalArgumentException e) {
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", e.getMessage()));
            }
        }
        return desc;
    }

    public boolean hasProjectNature(IProject project, String natureid) {
        if (project == null || natureid == null) {
            return false;
        }
        try {
            return project.hasNature(natureid);
        }
        catch (CoreException e) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.project", e.getMessage()));
            return false;
        }
    }

    public boolean addProjectNature(IProject project, String natureid) {
        block3: {
            try {
                if (!project.hasNature(natureid)) break block3;
                return true;
            }
            catch (CoreException e) {
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", e.getMessage()));
                return false;
            }
        }
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        String[] newnatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newnatures, 0, natures.length);
        newnatures[natures.length] = natureid;
        description.setNatureIds(newnatures);
        project.setDescription(description, null);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeProjectNature(IProject project, String natureid) {
        try {
            if (!project.hasNature(natureid)) {
                return true;
            }
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (true) {
                if (i >= natures.length) {
                    return false;
                }
                if (natureid.equals(natures[i])) {
                    String[] newnatures = new String[natures.length - 1];
                    System.arraycopy(natures, 0, newnatures, 0, i);
                    System.arraycopy(natures, i + 1, newnatures, i, natures.length - i - 1);
                    description.setNatureIds(newnatures);
                    project.setDescription(description, null);
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.project", e.getMessage()));
        }
        return false;
    }

    public Map<String, AbstractProjectIdentity> findProjectIdentities() {
        if (this.projectidentities == null) {
            this.projectidentities = new HashMap();
            try {
                IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("com.vmware.vide.project", EXTPOINT_PROJECTIDENTITY);
                if (extension != null) {
                    IExtension[] extensions;
                    IExtension[] iExtensionArray = extensions = extension.getExtensions();
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExtension e = iExtensionArray[n2];
                        IConfigurationElement[] iConfigurationElementArray = e.getConfigurationElements();
                        int n3 = iConfigurationElementArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement ce = iConfigurationElementArray[n4];
                            String natureid = ce.getAttribute("projectnatureid");
                            String name = ce.getAttribute("name");
                            Object obj = ce.createExecutableExtension("class");
                            if (obj instanceof AbstractProjectIdentity) {
                                AbstractProjectIdentity identity = (AbstractProjectIdentity)obj;
                                if (name != null) {
                                    identity.setName(name);
                                }
                                if (identity.isValid()) {
                                    this.projectidentities.put(natureid, identity);
                                }
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", e.getMessage()));
            }
        }
        return this.projectidentities;
    }

    public static ProjectDescription getProjectDescription(IProject project) {
        return ProjectDescription.getProjectDescription(project);
    }

    public static String getDevkitId(IProject project) {
        DevkitProjectDescription desc = ProjectManager.getDefault().getDevkitProjectDescription(project);
        if (desc != null) {
            return desc.getDevkitId();
        }
        return null;
    }

    private DevkitProjectDescription getDevkitProjectDescription(IProject project) {
        if (devkitProjectDescriptions.containsKey(project)) {
            return devkitProjectDescriptions.get(project);
        }
        ProjectDescription projectDesc = ProjectManager.getProjectDescription(project);
        if (projectDesc != null && projectDesc instanceof DevkitProjectDescription) {
            devkitProjectDescriptions.put(project, (DevkitProjectDescription)projectDesc);
            return (DevkitProjectDescription)projectDesc;
        }
        return null;
    }

    public static Map<String, String> getAllProjectProperties(IProject project) {
        ProjectDescription projdesc = ProjectManager.getProjectDescription(project);
        if (projdesc != null) {
            return projdesc.getAllProperties();
        }
        return new HashMap<String, String>();
    }

    public static String getProjectProperty(IProject project, String property) {
        ProjectDescription projdesc = ProjectManager.getProjectDescription(project);
        if (projdesc != null) {
            return projdesc.getProperty(property);
        }
        return null;
    }

    public static boolean putProjectProperties(IProject project, Map<String, String> properties, boolean overwrite) {
        ProjectDescription projdesc = ProjectManager.getProjectDescription(project);
        if (projdesc != null) {
            return projdesc.putProperties(properties, overwrite);
        }
        return false;
    }

    public static boolean putProjectProperty(IProject project, String property, String value, boolean overwrite) {
        ProjectDescription projdesc = ProjectManager.getProjectDescription(project);
        if (projdesc != null) {
            return projdesc.putProperty(property, value, overwrite);
        }
        return false;
    }

    public static final AbstractProjectIdentity getProjectIdentity(String id) {
        Map<String, AbstractProjectIdentity> identities;
        if (id != null && !id.isEmpty() && (identities = projectmanager.findProjectIdentities()) != null && identities.containsKey(id)) {
            return identities.get(id);
        }
        return null;
    }

    public static AbstractProjectIdentity findProjectIdentity(IProject project) {
        try {
            String[] natureids = project.getDescription().getNatureIds();
            Map<String, AbstractProjectIdentity> identities = projectmanager.findProjectIdentities();
            String[] stringArray = natureids;
            int n = natureids.length;
            int n2 = 0;
            while (n2 < n) {
                String natureid = stringArray[n2];
                if (identities.containsKey(natureid)) {
                    return identities.get(natureid);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.project", e.getMessage()));
        }
        return null;
    }
}

