/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.manager;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProjectStorage
implements IResourceChangeListener {
    private static final String STORE_FILE_NAME = ".vmwbproject";
    private volatile IProject project;
    private volatile IFile xmlfile;
    private StorageDocument storagedoc;

    public ProjectStorage(IProject project) {
        this.project = project;
        if (project != null) {
            this.xmlfile = project.getFile(STORE_FILE_NAME);
            IPath path = this.xmlfile.getRawLocation();
            if (path != null) {
                this.storagedoc = new StorageDocument(path.toFile());
            }
        }
    }

    public boolean isStorageValid() {
        return this.storagedoc != null && this.storagedoc.isStorageDocumentValid();
    }

    public boolean hasproperties() {
        return this.storagedoc != null && this.storagedoc.hasProperties();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.project.isOpen()) {
            return;
        }
        IResourceDelta eventDelta = event.getDelta();
        if (eventDelta == null) {
            return;
        }
        IResourceDelta delta = eventDelta.findMember(this.xmlfile.getFullPath());
        if (delta != null) {
            this.storagedoc.refresh();
        }
    }

    public Map<String, String> getAllProperties(IProject project, String sectionid) {
        return this.storagedoc == null ? new HashMap() : this.storagedoc.getAllProperties(sectionid);
    }

    public boolean putProperties(IProject project, String sectionid, Map<String, String> properties, boolean overwrite) {
        return this.storagedoc == null ? false : this.storagedoc.putProperties(sectionid, properties, overwrite);
    }

    private class StorageDocument {
        private final String TAG_ROOT = "vmwbproperties";
        File storagefile;
        Document document;
        private Map<String, StorageSection> sections = new HashMap<String, StorageSection>();

        public StorageDocument(File file) {
            this.storagefile = file;
            this.loadFromStorageFile();
        }

        public boolean isStorageDocumentValid() {
            return this.document != null;
        }

        public boolean hasProperties() {
            return this.sections.size() > 0;
        }

        public void refresh() {
            this.loadFromStorageFile();
        }

        public synchronized Map<String, String> getAllProperties(String sectionid) {
            if (this.sections.containsKey(sectionid)) {
                return this.sections.get(sectionid).getAllProperties();
            }
            return new HashMap<String, String>();
        }

        public synchronized boolean putProperties(String sectionid, Map<String, String> properties, boolean overwrite) {
            block5: {
                try {
                    StorageSection section = null;
                    if (this.sections.containsKey(sectionid)) {
                        section = this.sections.get(sectionid);
                    } else {
                        Element node = this.document.createElement(sectionid);
                        this.getRootNode().appendChild(node);
                        section = new StorageSection(node);
                        this.sections.put(sectionid, section);
                    }
                    if (section.putProperties(this.document, properties, overwrite)) break block5;
                    return false;
                }
                catch (CoreException e) {
                    System.out.println(e.getMessage());
                    return false;
                }
            }
            this.SaveToStorageFile();
            return true;
        }

        private synchronized void loadFromStorageFile() {
            if (this.storagefile == null || !this.storagefile.exists()) {
                this.document = this.createDocument();
                return;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                dbf.setIgnoringComments(true);
                this.document = db.parse(this.storagefile);
                Node rootnode = this.getRootNode();
                if (rootnode != null) {
                    NodeList nodelist = rootnode.getChildNodes();
                    int i = 0;
                    while (i < nodelist.getLength()) {
                        Node sectionnode = nodelist.item(i);
                        if (sectionnode.hasChildNodes()) {
                            String sectionid = sectionnode.getNodeName();
                            StorageSection section = this.sections.containsKey(sectionid) ? this.sections.get(sectionid) : new StorageSection(sectionnode);
                            section.setProperties(sectionnode);
                            if (section.hasProperties()) {
                                this.sections.put(sectionid, section);
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
            if (this.document == null) {
                this.document = this.createDocument();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean SaveToStorageFile() throws CoreException {
            StorageDocument storageDocument = this;
            synchronized (storageDocument) {
                block6: {
                    if (this.document != null) break block6;
                    return false;
                }
                try {
                    DOMSource source = new DOMSource(this.document);
                    StreamResult result = new StreamResult(this.storagefile);
                    Transformer xformer = TransformerFactory.newInstance().newTransformer();
                    xformer.setOutputProperty("indent", "yes");
                    xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                    xformer.transform(source, result);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return true;
        }

        private Node getRootNode() {
            NodeList nodes = this.document.getElementsByTagName("vmwbproperties");
            if (nodes.getLength() > 0) {
                return nodes.item(0);
            }
            return null;
        }

        private Document createDocument() {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.newDocument();
                Element rootnode = doc.createElement("vmwbproperties");
                doc.appendChild(rootnode);
                return doc;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                return null;
            }
        }
    }

    private class StorageSection {
        private final String TAG_PROPERTY = "property";
        private final String ATTRIBUTE_KEY = "key";
        private final String ATTRIBUTE_VALUE = "value";
        private Node sectionnode;
        private Map<String, String> properties;
        private Map<String, Node> propertynodes;

        public StorageSection(Node node) {
            this.sectionnode = node;
            this.properties = new HashMap<String, String>();
            this.propertynodes = new HashMap<String, Node>();
        }

        public boolean hasProperties() {
            return this.properties.size() > 0;
        }

        public Map<String, String> getAllProperties() {
            return this.properties;
        }

        public boolean putProperties(Document doc, Map<String, String> props, boolean overwrite) {
            for (String key : props.keySet()) {
                String value = props.get(key);
                if (this.properties.containsKey(key) && this.properties.get(key).equals(value) || this.properties.containsKey(key) && !overwrite) continue;
                this.properties.put(key, value);
                Node node = this.propertynodes.get(key);
                if (node == null || node.getAttributes() == null) {
                    if (node != null) {
                        this.sectionnode.removeChild(node);
                    }
                    Element element = doc.createElement("property");
                    this.sectionnode.appendChild(element);
                    element.setAttribute("key", key);
                    element.setAttribute("value", value);
                    this.propertynodes.put(key, element);
                    continue;
                }
                Node valuenode = node.getAttributes().getNamedItem("value");
                valuenode.setNodeValue(value);
            }
            return true;
        }

        public void setProperties(Node xmlnode) {
            NodeList childnodes = xmlnode.getChildNodes();
            if (childnodes == null || childnodes.getLength() == 0) {
                return;
            }
            int i = 0;
            while (i < childnodes.getLength()) {
                NamedNodeMap attributes;
                Node childnode = childnodes.item(i);
                if (childnode.getNodeName().equals("property") && (attributes = childnode.getAttributes()) != null) {
                    String value;
                    Node namenode = attributes.getNamedItem("key");
                    String name = namenode != null ? namenode.getNodeValue() : "";
                    Node valuenode = attributes.getNamedItem("value");
                    String string = value = valuenode != null ? valuenode.getNodeValue() : "";
                    if (!name.isEmpty() && !value.isEmpty()) {
                        this.properties.put(name, value);
                        this.propertynodes.put(name, childnode);
                    }
                }
                ++i;
            }
        }
    }
}

