/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.manager;

import com.vmware.vide.project.manager.IProjectStorage;
import com.vmware.vide.project.manager.ProjectStorage;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;

public class ProjectStorageManager
implements IProjectStorage {
    public static String ID_PROJECTSECTION = "vmwbproject";
    private static ProjectStorageManager storagemanager = new ProjectStorageManager();
    private Map<IProject, ProjectStorage> projectstorages = new HashMap<IProject, ProjectStorage>();

    public static ProjectStorageManager getDefault() {
        return storagemanager;
    }

    @Override
    public boolean isProjectStorageAvailable() {
        return true;
    }

    @Override
    public Map<String, String> getAllProjectProperties(IProject project) {
        return this.getAllProperties(project, ID_PROJECTSECTION);
    }

    @Override
    public boolean putProjectProperties(IProject project, Map<String, String> properties, boolean overwrite) {
        return this.putProperties(project, ID_PROJECTSECTION, properties, overwrite);
    }

    @Override
    public String getProjectProperty(IProject project, String key) {
        return this.getProperty(project, ID_PROJECTSECTION, key);
    }

    @Override
    public boolean putProjectProperty(IProject project, String key, String value, boolean overwrite) {
        return this.putProperty(project, ID_PROJECTSECTION, key, value, overwrite);
    }

    public String getProperty(IProject project, String sectionid, String key) {
        Map<String, String> properties = this.getAllProperties(project, sectionid);
        if (properties.containsKey(key)) {
            return properties.get(key);
        }
        return null;
    }

    public Map<String, String> getAllProperties(IProject project, String sectionid) {
        ProjectStorage storage = this.getProjectStorage(project);
        if (storage != null) {
            return storage.getAllProperties(project, sectionid);
        }
        return new HashMap<String, String>();
    }

    public boolean putProperty(IProject project, String sectionid, String key, String value, boolean overwrite) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(key, value);
        return this.putProperties(project, sectionid, properties, overwrite);
    }

    public boolean putProperties(IProject project, String sectionid, Map<String, String> properties, boolean overwrite) {
        ProjectStorage storage = this.getProjectStorage(project);
        if (storage != null) {
            return storage.putProperties(project, sectionid, properties, overwrite);
        }
        return false;
    }

    private ProjectStorage getProjectStorage(IProject project) {
        if (this.projectstorages.containsKey(project)) {
            return this.projectstorages.get(project);
        }
        ProjectStorage storage = new ProjectStorage(project);
        if (storage.isStorageValid()) {
            this.projectstorages.put(project, storage);
            return storage;
        }
        return null;
    }
}

