/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.utils;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.utils.NameValueData;
import com.vmware.vide.project.utils.OperationData;
import com.vmware.vide.project.utils.UtilDialog;
import com.vmware.vide.project.utils.VIDEProjectException;
import com.vmware.vide.project.utils.VariableOperator;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class Utils {
    public static final String ERROR_FILECONTENT = "Failed to get the content of ";
    public static final String ERROR_PATTERNPARSE = "Failed to parse a pattern ";
    public static final String ERROR_INSUFFICIENT_PROJECT_INFO = "Insufficient project information ";
    public static final String ERROR_CREATE_PROJECT = "Failed to create the project ";
    public static final String ERROR_CREATE_DIRECTORY = "Unable to create the directory ";
    public static final String ERROR_CREATE_PROJECTFILE = "Unable to create the project file ";
    public static final String ERROR_CREATE_VIBFILE = "Unable to create VIB related XML files ";
    public static final String ERROR_CREATE_FILE = "Unable to create the file ";
    public static final String ERROR_ACCESS_FILE = "Unable to access the file ";
    public static final String ERROR_SEARCH_PROJECT = "Failed to search projects ";
    public static final String ERROR_SET_ERRORPARSER = "Failed to add the VMware Workbench errorparser";
    public static final String ERROR_SET_BUILDTARGET = "Failed to update the build target";
    public static final String ERROR_EXEC_COMMAND = "Failed to execute command ";
    public static final String ERROR_RESOURCE_ACCESS = "Unable to access resources ";
    public static final String ERROR_INSUFFICIENT_INFO = "Insufficient information ";
    public static final String ERROR_DISABLE_AUTO_BUILD = "Failed to disable auto build feature";
    public static final String ERROR_UPDATE_FILES = "Failed to update project files";
    public static final String PATTERN_START = "{{";
    public static final String PATTERN_END = "}}";
    public static final String REGEXP_VALUE = "{{VALUE}}";
    public static final String PATTERN_VALUE = "[\\w\\s'\"-]*";
    private static final String OP_S = "(";
    private static final String OP_E = ")";
    private static final VariableOperator nop = VariableOperator.getNop();
    private static final List<VariableOperator> variableOperators = VariableOperator.getVariableOperators();

    public static VIDEProjectException createException(String category, String message, Exception e) {
        return new VIDEProjectException(category, message, e);
    }

    public static VIDEProjectException createProjectCreationException(String message, Exception e) {
        return Utils.createException("Project Creation", message, e);
    }

    public static VIDEProjectException createImportWizardException(String message, Exception e) {
        return Utils.createException("Import Wizard", message, e);
    }

    public static VIDEProjectException createNewWizardException(String message, Exception e) {
        return Utils.createException("New Wizard", message, e);
    }

    public static VIDEProjectException createFileAccessException(String message, Exception e) {
        return Utils.createException("File Access", message, e);
    }

    public static VIDEProjectException createPatternParserException(String message, Exception e) {
        return Utils.createException("Pattern Parser", message, e);
    }

    public static VIDEProjectException createProjectNatureException(String message, Exception e) {
        return Utils.createException("Project Information", message, e);
    }

    public static VIDEProjectException createCommandExecutionException(String message, Exception e) {
        return Utils.createException("Command Execution", message, e);
    }

    public static VIDEProjectException createProjectUpdateException(String message, Exception e) {
        return Utils.createException("Project Update", message, e);
    }

    public static void openDialog(VIDEProjectException e) {
        Utils.openDialog(e.getCategory(), e.getMessage(), e.getMessageDialogType(), e.getActualException());
    }

    public static void openInfoDialog(String info) {
        Utils.openDialog("Information", info, 2, null);
    }

    public static void openDialog(String category, String message, int messagetype, Exception exp) {
        final Exception fexp = exp;
        final String fcategory = category;
        final String fmessage = message;
        final int fmessagetype = messagetype;
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell activeShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                UtilDialog dialog = new UtilDialog(activeShell, fcategory, null, fmessage, fmessagetype, new String[]{IDialogConstants.OK_LABEL}, 0);
                if (fexp != null) {
                    dialog.setMessage(Utils.getStackTrace(fexp));
                }
                dialog.open();
            }
        });
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter traceWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(traceWriter);
        throwable.printStackTrace(printWriter);
        return traceWriter.toString();
    }

    public static String getFileContent(File file, boolean errordialog) {
        StringBuffer stringbuffer;
        block17: {
            stringbuffer = new StringBuffer();
            String linesep = System.getProperty("line.separator");
            if (file == null || !file.exists()) {
                return stringbuffer.toString();
            }
            BufferedReader br = null;
            try {
                try {
                    String line;
                    FileInputStream fstream = new FileInputStream(file.getAbsoluteFile());
                    br = new BufferedReader(new InputStreamReader(new DataInputStream(fstream)));
                    while ((line = br.readLine()) != null) {
                        stringbuffer.append(line).append(linesep);
                    }
                }
                catch (Exception e) {
                    if (errordialog) {
                        Utils.openDialog(Utils.createFileAccessException(ERROR_FILECONTENT + file.getName(), e));
                    }
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e2) {
                            ILog logger = ProjectPlugin.getDefault().getLog();
                            logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e2));
                        }
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        ILog logger = ProjectPlugin.getDefault().getLog();
                        logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e));
                    }
                }
                throw throwable;
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    ILog logger = ProjectPlugin.getDefault().getLog();
                    logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e));
                }
            }
        }
        return stringbuffer.toString();
    }

    public static boolean copyFile(File sourcefile, File destfile, boolean overwrite, boolean errordialog) {
        if (sourcefile == null || !sourcefile.exists() || !sourcefile.isFile()) {
            return false;
        }
        if (destfile == null || !overwrite && destfile.exists()) {
            return false;
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            in = new FileInputStream(sourcefile);
            out = new FileOutputStream(destfile);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            if (errordialog) {
                Utils.openDialog(Utils.createFileAccessException(ERROR_ACCESS_FILE + sourcefile.getName(), e));
            }
            return false;
        }
        return true;
    }

    public static String getRegExpValue(String content, String regexp, String value_pattern, String value_regexp, boolean errordialog) {
        block9: {
            int index;
            String pattern = regexp;
            if (value_pattern == null || value_pattern.isEmpty()) {
                value_pattern = REGEXP_VALUE;
            }
            if (value_regexp == null || value_regexp.isEmpty()) {
                value_regexp = PATTERN_VALUE;
            }
            if ((index = pattern.indexOf(value_pattern)) == -1) {
                return "";
            }
            try {
                StringBuilder sb = new StringBuilder();
                sb.append('(').append(value_regexp).append(')');
                pattern = pattern.replace(value_pattern, sb.toString());
                Pattern repattern = Pattern.compile(pattern);
                Matcher match = repattern.matcher(content);
                if (match.find()) {
                    if (match.groupCount() == 1) {
                        return match.group(1);
                    }
                    Pattern p = Pattern.compile(value_regexp);
                    int i = 2;
                    while (i <= match.groupCount()) {
                        String s = match.group(i);
                        if (p.matcher(s).matches()) {
                            return s;
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                if (!errordialog) break block9;
                Utils.openDialog(Utils.createPatternParserException(ERROR_PATTERNPARSE + regexp, e));
            }
        }
        return null;
    }

    public static String replaceContent(String content, Map<String, String> properties) {
        return Utils._replace(content, properties, new HashSet<String>());
    }

    private static String _replace(String content, Map<String, String> properties, Set<String> haveSeen) {
        if (content.indexOf(PATTERN_START) == -1) {
            return content;
        }
        StringBuilder buffer = new StringBuilder(content);
        for (String key : properties.keySet()) {
            List<OperationData> operationData = Utils.findKey(content, key);
            if (operationData.isEmpty()) continue;
            String propvalue = properties.get(key);
            if (propvalue.contains(PATTERN_START)) {
                if (haveSeen.contains(propvalue)) {
                    System.err.println("Found circular definition: [" + key + " : " + propvalue + "] in " + haveSeen.toString());
                    return buffer.toString();
                }
                haveSeen.add(propvalue);
                String replacedValue = Utils._replace(propvalue, properties, haveSeen);
                haveSeen.remove(propvalue);
                propvalue = replacedValue;
            }
            for (OperationData op : operationData) {
                propvalue = op.getOp().convert(new String[]{propvalue, key});
                int len = propvalue.length();
                int pos = 0;
                while ((pos = buffer.indexOf(op.getPattern(), pos)) >= 0) {
                    buffer.replace(pos, pos + op.getPattern().length(), propvalue);
                    pos += len;
                }
            }
        }
        return buffer.toString();
    }

    private static List<OperationData> findKey(String content, String key) {
        ArrayList<OperationData> patterns = new ArrayList<OperationData>();
        String pattern = String.valueOf(key) + PATTERN_END;
        int idx = content.indexOf(pattern);
        if (idx == -1) {
            return patterns;
        }
        if (content.indexOf(PATTERN_START + key + PATTERN_END) != -1) {
            OperationData p = new OperationData(nop, PATTERN_START + key + PATTERN_END);
            patterns.add(p);
        }
        for (VariableOperator op : variableOperators) {
            pattern = "{{(" + op.getName() + OP_E + key + PATTERN_END;
            if (content.indexOf(pattern) == -1) continue;
            patterns.add(new OperationData(op, pattern));
        }
        return patterns;
    }

    public static String replaceEscapeCharsForXML(String source) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator it = new StringCharacterIterator(source);
        char c = it.current();
        while (c != '\uffff') {
            if (c == '<') {
                result.append("&lt;");
            } else if (c == '>') {
                result.append("&gt;");
            } else if (c == '\"') {
                result.append("&quot;");
            } else if (c == '\'') {
                result.append("&#39;");
            } else if (c == '&') {
                result.append("&amp;");
            } else {
                result.append(c);
            }
            c = it.next();
        }
        return result.toString();
    }

    public static String appendString(String content, String pattern, String before, String after, int[] occurred) {
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while (index < content.length()) {
            int start = content.indexOf(pattern, index);
            if (start == -1) {
                sb.append(content.substring(index));
                break;
            }
            occurred[0] = occurred[0] + 1;
            if (before != null && !before.isEmpty()) {
                sb.append(content.substring(index, start));
                sb.append(before);
                sb.append(content.substring(start, start + pattern.length()));
                index = start + pattern.length();
            }
            if (after == null || after.isEmpty()) continue;
            sb.append(content.substring(index, start + pattern.length()));
            sb.append(after);
            index = start + pattern.length();
        }
        return sb.toString();
    }

    public static ArrayList<NameValueData> parseNameValue(String data, ArrayList<String> errs) {
        ArrayList<NameValueData> namevals = new ArrayList<NameValueData>();
        int index = 0;
        int name_start = 0;
        int name_end = 0;
        while (index < data.length()) {
            name_start = index = Utils.skipBlank(data, index);
            index = name_end = Utils.getName(data, index);
            String name = data.substring(name_start, name_end);
            if ((index = Utils.skipBlank(data, index)) >= data.length()) {
                if (name.isEmpty()) break;
                namevals.add(new NameValueData(name, ""));
                break;
            }
            if (data.charAt(index) == ',') {
                if (!name.isEmpty()) {
                    namevals.add(new NameValueData(name, ""));
                }
                ++index;
                continue;
            }
            if (data.charAt(index) == '=') {
                int err_at = index++;
                String[] val = new String[1];
                index = Utils.getValue(data, index, val, errs);
                if (!name.isEmpty()) {
                    namevals.add(new NameValueData(name, val[0]));
                    continue;
                }
                errs.add("Missing name at " + err_at + ".");
                continue;
            }
            errs.add("Missing separater at " + index + ".");
            break;
        }
        return namevals;
    }

    private static int getValue(String data, int offset, String[] val, ArrayList<String> errs) {
        boolean quoted = false;
        StringBuffer sb = new StringBuffer();
        int index = Utils.skipBlank(data, offset);
        while (index < data.length()) {
            char c = data.charAt(index);
            if (c == '\\') {
                if (++index >= data.length()) continue;
                c = data.charAt(index);
                sb.append(c);
                ++index;
                continue;
            }
            if (c == '\"') {
                quoted = !quoted;
                ++index;
                continue;
            }
            if (c == ',' && !quoted) {
                ++index;
                break;
            }
            if (Character.isWhitespace(c) && !quoted) {
                ++index;
                continue;
            }
            sb.append(c);
            ++index;
        }
        val[0] = sb.toString();
        if (quoted) {
            errs.add("Missing closing double quote at " + index + ".");
        }
        return index;
    }

    private static int skipBlank(String data, int offset) {
        int index = offset;
        while (index < data.length() && Character.isWhitespace(data.charAt(index))) {
            ++index;
        }
        return index;
    }

    private static int getName(String data, int offset) {
        int index = offset;
        while (index < data.length()) {
            char c = data.charAt(index);
            if (c == ',' || c == '=' || Character.isWhitespace(c)) break;
            ++index;
        }
        return index;
    }

    public static boolean isBinaryFile(File file) throws IOException {
        if (file.getAbsolutePath().contains("devKit")) {
            ILog logger = ProjectPlugin.getDefault().getLog();
            logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, null));
        }
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), decoder));){
                while (br.readLine() != null) {
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CharacterCodingException characterCodingException) {
            return true;
        }
        catch (IOException e) {
            throw e;
        }
        return false;
    }
}

