/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.wbis.generator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum Language {
    JAVA("java"),
    PYTHON("python"),
    PHP("php");

    public String language;
    public static final Map<String, Language> STRING_TO_OBJECT_MAP;
    public static final Set<String> ALLOWABLE_VALUES;

    static {
        STRING_TO_OBJECT_MAP = new HashMap<String, Language>();
        ALLOWABLE_VALUES = new HashSet<String>();
        int i = 0;
        while (i < Language.values().length) {
            STRING_TO_OBJECT_MAP.put(Language.values()[i].language, Language.values()[i]);
            ALLOWABLE_VALUES.add(Language.values()[i].language);
            ++i;
        }
    }

    private Language(String language) {
        this.language = language;
    }

    public String toString() {
        return this.language;
    }

    public static Language findLanguage(String language) {
        return STRING_TO_OBJECT_MAP.get(language);
    }

    public static boolean isValid(String language) {
        return Language.findLanguage(language) != null;
    }
}

