/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.wbis.generator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum ProjectType {
    ANT("ant"),
    MAVEN("maven");

    public static final Map<String, ProjectType> STRING_TO_OBJECT_MAP;
    public static final Set<String> ALLOWABLE_VALUES;
    public String type;

    static {
        STRING_TO_OBJECT_MAP = new HashMap<String, ProjectType>();
        ALLOWABLE_VALUES = new HashSet<String>();
        int i = 0;
        while (i < ProjectType.values().length) {
            STRING_TO_OBJECT_MAP.put(ProjectType.values()[i].type, ProjectType.values()[i]);
            ALLOWABLE_VALUES.add(ProjectType.values()[i].type);
            ++i;
        }
    }

    private ProjectType(String type) {
        this.type = type;
    }

    public String toString() {
        return this.type;
    }

    public static ProjectType findProjectType(String type) {
        return STRING_TO_OBJECT_MAP.get(type);
    }

    public static boolean isValid(String type) {
        return ProjectType.findProjectType(type) != null;
    }
}

