/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.wizard.newwizard;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.config.wizard.project.ProjectData;
import com.vmware.vide.project.wizard.ui.DevkitProjectWizardPage;
import com.vmware.vide.project.wizard.ui.UserInputGroupComposite;
import com.vmware.vide.project.wizard.ui.UserInputWidget;
import java.util.HashMap;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class ProjectPropertyPage
extends DevkitProjectWizardPage {
    private static final String MSG_PAGENAME = "Project Information";
    private static final String DESC_INIT = "Specify detailed project information";
    private static final ImageDescriptor IMG_VMWARE = ProjectPlugin.imageDescriptorFromPlugin((String)"com.vmware.vide.project", (String)"resources/images/vmware.png");
    private static final String CONTEXT_HELP_CONTENTS_ID = "context-newwizard-project-property";
    private ProjectData projectdata;
    UserInputGroupComposite inputgroupcomposite;
    boolean yetShown = true;

    protected ProjectPropertyPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(DESC_INIT);
    }

    protected ProjectPropertyPage() {
        this(MSG_PAGENAME, MSG_PAGENAME, IMG_VMWARE);
    }

    public void createControl(Composite parent) {
        Composite maincomposite = new Composite(parent, 0);
        this.setControl((Control)maincomposite);
        maincomposite.setLayout((Layout)new GridLayout());
        maincomposite.setLayoutData((Object)new GridData(1808));
        this.inputgroupcomposite = new UserInputGroupComposite(maincomposite);
        this.inputgroupcomposite.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (event instanceof UserInputWidget.UserInputWidgetEvent) {
                    if (ProjectPropertyPage.this.inputgroupcomposite.hasInputGroupError()) {
                        ProjectPropertyPage.this.setPageComplete(false);
                    } else {
                        ProjectPropertyPage.this.setPageComplete(true);
                    }
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.vmware.vide.project.help.context-newwizard-project-property");
        maincomposite.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                if (ProjectPropertyPage.this.yetShown) {
                    ProjectPropertyPage.this.yetShown = false;
                    int gap = ProjectPropertyPage.this.inputgroupcomposite.getHeightGap();
                    if (gap > 0) {
                        Point point = ProjectPropertyPage.this.getShell().getSize();
                        point.y += gap;
                        Rectangle rec = Display.getCurrent().getBounds();
                        if (point.y > rec.height) {
                            point.y = rec.height - 20;
                        }
                        ProjectPropertyPage.this.getShell().setSize(point);
                    }
                }
            }
        });
    }

    public void updateProjectProperty(ProjectData data) {
        if (data != null) {
            if (!data.equals(this.projectdata)) {
                this.projectdata = data;
                this.inputgroupcomposite.createUserInputs(data.getOrderedUserInputs(), data.getPropertyValues(null), data.getProperty("sortrule", false), "com.vmware.vide.project.ProjectData", new HashMap<QualifiedName, String>());
            } else {
                this.inputgroupcomposite.updateDefaultValueOfUserInputs(data.getPropertyValues(null));
            }
        }
    }

    public ProjectData getProjectData() {
        return this.projectdata;
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && !this.inputgroupcomposite.hasInputGroupError() && this.projectdata.isWizardCreatedVIBfiles();
    }

    @Override
    public boolean okToFinish() {
        return super.isPageComplete() && !this.inputgroupcomposite.hasInputGroupError() && !this.inputgroupcomposite.hasInputGroupWarning();
    }
}

