/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.wizard.ui;

import com.vmware.vide.project.config.vib.UserInput;
import com.vmware.vide.project.config.vib.UserInputHelper;
import com.vmware.vide.project.config.vib.UserInputHelperCommand;
import com.vmware.vide.project.wizard.ui.UserInputHelperCommandRunner;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;

public abstract class BuiltinCommandRunner
extends UserInputHelperCommandRunner {
    private static final String FILTER_PATH = "filter_path";
    private static final String FORCE_FILTER_PATH = "force_filter_path";
    private static final String LAST_PATH_ID = "last_path_id";

    static BuiltinCommandRunner createRunner(SelectionEvent event, UserInputHelperCommand command, Map<String, String> properties, String text, UserInput inputdata, UserInputHelper helper) {
        if (command.getCommand().equals("file")) {
            return new FileDialogCommandRunner(event, command, properties, text, inputdata, helper);
        }
        if (command.getCommand().equals("dir")) {
            return new DirectoryDialogCommandRunner(event, command, properties, text, inputdata, helper);
        }
        return null;
    }

    BuiltinCommandRunner(SelectionEvent event, UserInputHelperCommand command, Map<String, String> properties, String text, UserInput inputdata, UserInputHelper helper) {
        super(event, command, properties, text, inputdata, helper);
    }

    private static String getLastPathKey(BuiltinCommandRunner runner) {
        StringBuilder sb = new StringBuilder(runner.command.getCommand());
        sb.append(".last_path_id");
        String id = runner.getArgValue(LAST_PATH_ID);
        if (id != null) {
            sb.append('.');
            sb.append(id);
        }
        return sb.toString();
    }

    private static String getFilterPath(BuiltinCommandRunner runner) {
        String filter = runner.getArgValue(FILTER_PATH);
        if (filter != null && runner.getArgBooleanValue(FORCE_FILTER_PATH)) {
            return filter;
        }
        String lastPath = runner.helper.getData(BuiltinCommandRunner.getLastPathKey(runner));
        if (lastPath == null && filter != null) {
            return filter;
        }
        return lastPath;
    }

    static class DirectoryDialogCommandRunner
    extends BuiltinCommandRunner {
        private static final String TEXT = "text";
        private static final String MESSAGE = "message";

        DirectoryDialogCommandRunner(SelectionEvent event, UserInputHelperCommand command, Map<String, String> properties, String text, UserInput inputdata, UserInputHelper helper) {
            super(event, command, properties, text, inputdata, helper);
        }

        @Override
        String run(Map<String, String> results) {
            DirectoryDialog dlg = new DirectoryDialog(this.event.display.getActiveShell(), 4096);
            String title = this.getArgValue(TEXT);
            if (title == null) {
                title = this.inputdata.getTitle();
            }
            dlg.setText(title);
            String message = this.getArgValue(MESSAGE);
            if (message == null) {
                message = this.inputdata.getDescription();
            }
            dlg.setMessage(message);
            String filterPath = BuiltinCommandRunner.getFilterPath((BuiltinCommandRunner)this);
            dlg.setFilterPath(filterPath);
            String result = dlg.open();
            this.helper.setData(BuiltinCommandRunner.getLastPathKey((BuiltinCommandRunner)this), dlg.getFilterPath());
            return result;
        }
    }

    static class FileDialogCommandRunner
    extends BuiltinCommandRunner {
        private static final String MULTIPLE = "multiple";
        private static final String TEXT = "text";
        private static final String FILENAME = "filename";
        private static final String FILTER_EXTENSION = "filter_extension";
        private static final String FILTER_INDEX = "filter_index";
        private static final String FILTER_NAME = "filter_name";
        private static final String FULLPATH = "fullpath";
        private static final String SEPARATOR = "separator";
        private static final String DEFAULT_FILE_SEPARATOR = ",";

        FileDialogCommandRunner(SelectionEvent event, UserInputHelperCommand command, Map<String, String> properties, String text, UserInput inputdata, UserInputHelper helper) {
            super(event, command, properties, text, inputdata, helper);
        }

        @Override
        String run(Map<String, String> results) {
            String[] extensions;
            int style = 4096;
            if (this.getArgBooleanValue(MULTIPLE)) {
                style |= 2;
            }
            FileDialog dlg = new FileDialog(this.event.display.getActiveShell(), style);
            String title = this.getArgValue(TEXT);
            if (title == null) {
                title = this.inputdata.getTitle();
            }
            dlg.setText(title);
            String filename = this.getArgValue(FILENAME);
            if (filename != null) {
                dlg.setFileName(filename);
            }
            if ((extensions = this.getArgMultipleValues(FILTER_EXTENSION)) != null) {
                String[] filterNames;
                dlg.setFilterExtensions(extensions);
                Integer index = this.getArgIntValue(FILTER_INDEX);
                if (index != null) {
                    if (index >= extensions.length) {
                        logger.log((IStatus)new Status(4, "com.vmware.vide.project", "Filter index exceeds the size of the filter extensions array. The index is adjusted to 0."));
                        index = 0;
                    }
                    dlg.setFilterIndex(index.intValue());
                }
                if ((filterNames = this.getArgMultipleValues(FILTER_NAME)) != null) {
                    if (extensions.length != filterNames.length) {
                        logger.log((IStatus)new Status(4, "com.vmware.vide.project", "Number of filter names does not mutch with the number of extension filters."));
                    }
                    dlg.setFilterNames(filterNames);
                }
            }
            String filterPath = BuiltinCommandRunner.getFilterPath((BuiltinCommandRunner)this);
            dlg.setFilterPath(filterPath);
            String result = dlg.open();
            if ((style & 2) != 0) {
                String[] files;
                boolean fullpath = this.getArgBooleanValue(FULLPATH);
                String separator = this.getArgValue(SEPARATOR);
                if (separator == null) {
                    separator = DEFAULT_FILE_SEPARATOR;
                }
                if ((files = dlg.getFileNames()).length != 0) {
                    StringBuilder sb = new StringBuilder();
                    String prepPath = "";
                    if (fullpath) {
                        prepPath = String.valueOf(dlg.getFilterPath()) + System.getProperty("file.separator").charAt(0);
                        sb.append(prepPath);
                    }
                    sb.append(files[0]);
                    int i = 1;
                    while (i < files.length) {
                        sb.append(separator);
                        sb.append(prepPath);
                        sb.append(files[i]);
                        ++i;
                    }
                    result = sb.toString();
                }
            }
            this.helper.setData(BuiltinCommandRunner.getLastPathKey((BuiltinCommandRunner)this), dlg.getFilterPath());
            return result;
        }
    }
}

