/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.wizard.ui;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.config.vib.UserInput;
import com.vmware.vide.project.config.vib.UserInputEnableCondition;
import com.vmware.vide.project.config.vib.UserInputHelper;
import com.vmware.vide.project.config.vib.UserInputHelperCommand;
import com.vmware.vide.project.wizard.ui.UserInputGroupComposite;
import com.vmware.vide.project.wizard.ui.UserInputHelperCommandRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class UserInputWidget {
    private static final ILog logger = ProjectPlugin.getDefault().getLog();
    private static final String WIDGETDATA_NAME = "name";
    private final Composite parent;
    private final UserInput inputdata;
    private InputWidget inputwidget;
    private volatile boolean isusermodified;
    private final Map<QualifiedName, String> persistentProp;
    private final String qualifier;
    private ListenerList stateChangedListeners;
    private final UserInputGroupComposite group;

    public UserInputWidget(Composite parent, UserInput input, Map<String, String> properties, String qualifier, Map<QualifiedName, String> persistentProp, UserInputGroupComposite group) {
        this.parent = parent;
        this.inputdata = input;
        this.qualifier = qualifier;
        this.persistentProp = persistentProp;
        this.inputwidget = this.createInputWidget(properties);
        this.isusermodified = false;
        this.group = group;
    }

    private InputWidget createInputWidget(Map<String, String> properties) {
        if (this.inputdata.getWidgetType().equals("text")) {
            this.inputwidget = new InputText(this.parent, properties, true, true);
        } else if (this.inputdata.getWidgetType().equals("label")) {
            this.inputwidget = new InputText(this.parent, properties, true, false);
        } else if (this.inputdata.getWidgetType().equals("textbox")) {
            this.inputwidget = new InputText(this.parent, properties, false, true);
        } else if (this.inputdata.getWidgetType().equals("combo")) {
            this.inputwidget = new InputCombo(this.parent, properties, false);
        } else if (this.inputdata.getWidgetType().equals("combotext")) {
            this.inputwidget = new InputCombo(this.parent, properties, true);
        }
        return this.inputwidget;
    }

    public void updateDefaultValueOfUserInput(Map<String, String> properties) {
        if (this.isusermodified) {
            return;
        }
        String defvalue = this.inputdata.getDefaultValue(properties, true);
        if (defvalue == null || defvalue.isEmpty() || !this.isWidgetValid()) {
            return;
        }
        if (!this.inputwidget.getText().equals(defvalue)) {
            this.inputwidget.modifyText(defvalue);
        }
    }

    public UserInput getInputData() {
        return this.inputdata;
    }

    public void dispose() {
        this.inputwidget.dispose();
    }

    public boolean isWidgetValid() {
        return this.inputwidget != null && !this.inputwidget.isDisposed();
    }

    public Point getSize() {
        return this.inputwidget.getSize();
    }

    private void userInputHasChanged(TypedEvent e, InputWidget widget) {
        if (this.isUserModifyEvent(e)) {
            this.isusermodified = true;
        }
        this.inputdata.setValue(widget.getText());
        Display display = widget.getDisplay();
        Color color = null;
        color = this.inputdata.isInputValueError() ? display.getSystemColor(3) : (this.inputdata.isInputValueWarning() ? display.getSystemColor(7) : (this.inputdata.isInputValueInformational() ? display.getSystemColor(29) : widget.getNormalColor()));
        this.inputwidget.setBackground(color);
        this.parent.notifyListeners(24, (Event)new UserInputWidgetEvent(e, this));
    }

    private boolean isUserModifyEvent(TypedEvent e) {
        Object o = e.data;
        return o == null || !(o instanceof ProgramModifyMarker);
    }

    private boolean hasInputHelpers() {
        List<UserInputHelper> helpers = this.inputdata.getUserInputHelpers();
        return !helpers.isEmpty();
    }

    private int getNumberOfHelpers() {
        return this.inputdata.getUserInputHelpers().size();
    }

    private List<Button> createHelperButtons(final Text text, Composite parent, final Map<String, String> properties) {
        int num = this.getNumberOfHelpers();
        ArrayList<Button> buttons = new ArrayList<Button>();
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(num, true));
        for (UserInputHelper helper : this.inputdata.getUserInputHelpers()) {
            Button b = new Button(comp, 8);
            b.setText(helper.getName());
            final UserInputHelper inputHelper = helper;
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String result = UserInputWidget.this.executeInputHelper(text.getText(), e, inputHelper, properties);
                    if (result != null) {
                        text.setText(result);
                    }
                }
            });
            b.setEnabled(text.getEnabled());
            buttons.add(b);
        }
        return buttons;
    }

    private String executeInputHelper(String text, SelectionEvent event, UserInputHelper helper, Map<String, String> properties) {
        for (UserInputHelperCommand command : helper.getCommands()) {
            HashMap<String, String> results;
            String result = null;
            UserInputHelperCommandRunner runner = UserInputHelperCommandRunner.createCommandRunner(event, command, properties, text, this.inputdata, helper);
            result = runner.run(results = new HashMap<String, String>());
            if (result != null) {
                text = result;
            }
            if (results.isEmpty()) continue;
            for (Map.Entry entry : results.entrySet()) {
                this.inputdata.putValueForMultipleValues((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return text;
    }

    public void addStateChangeListener(UserInputWidget inputWidget) {
        if (this.stateChangedListeners == null) {
            this.stateChangedListeners = new ListenerList();
        }
        this.stateChangedListeners.add((Object)inputWidget);
    }

    public void removeStateChangeListener(UserInputWidget inputWidget) {
        if (this.stateChangedListeners != null) {
            this.stateChangedListeners.remove((Object)inputWidget);
        }
    }

    void fireStateChanged() {
        Object[] objs;
        if (this.stateChangedListeners == null) {
            return;
        }
        Object[] objectArray = objs = this.stateChangedListeners.getListeners();
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            UserInputWidget widget = (UserInputWidget)o;
            widget.stateChanged(this);
            ++n2;
        }
    }

    private void stateChanged(UserInputWidget widget) {
        boolean enable = true;
        block0: for (UserInputEnableCondition condition : this.inputdata.getEnableConditions()) {
            for (UserInputWidget w : this.group.getCurrentInputWidgets()) {
                if (!condition.getTitle().equals(w.getInputData().getTitle())) continue;
                if (condition.isCheckbox()) {
                    if (w.inputdata.isCheckBoxNeeded()) {
                        if (w.inputwidget.isCheckboxSelected() == Boolean.valueOf(condition.getPattern()).booleanValue()) continue;
                        enable = false;
                        break block0;
                    }
                    String msg = String.format("%s is not a checkbox.", w.getInputData().getTitle());
                    logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                    continue;
                }
                Pattern pattern = Pattern.compile(condition.getPattern());
                Matcher m = pattern.matcher(w.inputwidget.getText());
                if (m.matches()) continue;
                enable = false;
                break block0;
            }
        }
        this.inputwidget.setEnabled(enable);
        this.inputdata.setEnabled(enable);
    }

    public class InputCombo
    extends InputWidget {
        private final CCombo inputcombo;
        private final ModifyListener listener;

        public InputCombo(Composite parent, Map<String, String> properties, boolean editable) {
            this.createTitleWidget(parent);
            this.inputcombo = new CCombo(parent, 2060);
            this.inputcombo.setEditable(editable);
            GridData gd = new GridData(768);
            gd.horizontalSpan = UserInputWidget.this.hasInputHelpers() ? 1 : 2;
            this.inputcombo.setLayoutData((Object)gd);
            this.inputcombo.setItems(UserInputWidget.this.inputdata.getInputValues());
            if (UserInputWidget.this.inputdata.getDescription() != null) {
                this.inputcombo.setToolTipText(UserInputWidget.this.inputdata.getDescription());
            }
            QualifiedName qname = UserInputWidget.this.inputdata.getQualifiedName(UserInputWidget.this.qualifier);
            String defvalue = UserInputWidget.this.persistentProp.containsKey(qname) ? (String)UserInputWidget.this.persistentProp.get(qname) : UserInputWidget.this.inputdata.getDefaultValue(properties, true);
            if (defvalue == null || defvalue.isEmpty()) {
                defvalue = UserInputWidget.this.inputdata.getInputValues()[0];
            }
            this.inputcombo.setText(defvalue);
            this.inputcombo.setData((Object)UserInputWidget.this.inputdata);
            this.inputcombo.setData(UserInputWidget.WIDGETDATA_NAME, (Object)UserInputWidget.this.inputdata.getTitle().replace(" ", "_"));
            this.inputcombo.setVisible(true);
            this.inputcombo.setEnabled(this.isCheckboxSelected());
            this.inputcombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UserInputWidget.this.userInputHasChanged((TypedEvent)e, InputCombo.this);
                    UserInputWidget.this.fireStateChanged();
                }
            });
            this.listener = this.getModifyListener(this);
            this.inputcombo.addModifyListener(this.listener);
            this.inputcombo.pack();
        }

        @Override
        public Color getNormalColor() {
            return Display.getDefault().getSystemColor(25);
        }

        @Override
        public Point getSize() {
            return this.inputcombo.getSize();
        }

        @Override
        public String getText() {
            return this.inputcombo.getText();
        }

        @Override
        public Widget getWidget() {
            return this.inputcombo;
        }

        @Override
        public void setBackground(Color color) {
            this.inputcombo.setBackground(color);
        }

        @Override
        public void setText(String text) {
            this.inputcombo.setText(text);
        }

        @Override
        public void dispose() {
            if (this.inputcombo != null) {
                this.inputcombo.dispose();
            }
            if (this.titlewidget != null) {
                this.titlewidget.dispose();
            }
        }

        @Override
        protected void checkboxChanged(SelectionEvent e) {
            if (e.getSource() instanceof Button) {
                Button button = (Button)e.getSource();
                this.inputcombo.setEnabled(button.getSelection());
            }
        }

        @Override
        public ModifyListener removeDefaultModifyListener() {
            this.inputcombo.removeModifyListener(this.listener);
            return this.listener;
        }

        @Override
        public void restoreDefaultModifyListener() {
            this.inputcombo.addModifyListener(this.listener);
        }

        @Override
        void setEnabled(boolean b) {
            this.inputcombo.setEnabled(b);
        }

        @Override
        boolean isEnabled() {
            return this.inputcombo.isEnabled();
        }
    }

    public class InputText
    extends InputWidget {
        private final Text inputtext;
        private final ModifyListener listener;
        private List<Button> buttons;

        public InputText(Composite parent, Map<String, String> properties, boolean issingleline, boolean visible) {
            this.createTitleWidget(parent);
            int style = issingleline ? 2052 : 2818;
            this.inputtext = new Text(parent, style);
            GridData gd = new GridData(768);
            gd.horizontalSpan = UserInputWidget.this.hasInputHelpers() ? 1 : 2;
            this.inputtext.setLayoutData((Object)gd);
            QualifiedName qname = UserInputWidget.this.inputdata.getQualifiedName(UserInputWidget.this.qualifier);
            String defvalue = UserInputWidget.this.persistentProp.containsKey(qname) ? (String)UserInputWidget.this.persistentProp.get(qname) : UserInputWidget.this.inputdata.getDefaultValue(properties, true);
            if (defvalue != null) {
                this.setText(defvalue);
            }
            if (UserInputWidget.this.inputdata.getDescription() != null) {
                this.inputtext.setToolTipText(UserInputWidget.this.inputdata.getDescription());
            }
            this.inputtext.setData((Object)UserInputWidget.this.inputdata);
            this.inputtext.setData(UserInputWidget.WIDGETDATA_NAME, (Object)UserInputWidget.this.inputdata.getTitle().replace(" ", "_"));
            this.listener = this.getModifyListener(this);
            this.inputtext.addModifyListener(this.listener);
            this.inputtext.setVisible(visible);
            this.inputtext.setEnabled(this.isCheckboxSelected());
            if (UserInputWidget.this.hasInputHelpers()) {
                this.buttons = UserInputWidget.this.createHelperButtons(this.inputtext, parent, properties);
            }
            this.inputtext.pack();
        }

        @Override
        public Color getNormalColor() {
            return this.inputtext.getDisplay().getSystemColor(1);
        }

        @Override
        public Point getSize() {
            return this.inputtext.getSize();
        }

        @Override
        public String getText() {
            return this.inputtext.getText();
        }

        @Override
        public Widget getWidget() {
            return this.inputtext;
        }

        @Override
        public void setBackground(Color color) {
            this.inputtext.setBackground(color);
        }

        @Override
        public void setText(String text) {
            this.inputtext.setText(text);
        }

        @Override
        public void dispose() {
            if (this.inputtext != null) {
                this.inputtext.dispose();
            }
            if (this.titlewidget != null) {
                this.titlewidget.dispose();
            }
        }

        @Override
        protected void checkboxChanged(SelectionEvent e) {
            if (e.getSource() instanceof Button) {
                Button button = (Button)e.getSource();
                this.setEnabled(button.getSelection());
                UserInputWidget.this.inputdata.setUserInputEnable(button.getSelection());
            }
        }

        @Override
        public ModifyListener removeDefaultModifyListener() {
            this.inputtext.removeModifyListener(this.listener);
            return this.listener;
        }

        @Override
        public void restoreDefaultModifyListener() {
            this.inputtext.addModifyListener(this.listener);
        }

        @Override
        void setEnabled(boolean b) {
            this.inputtext.setEnabled(b);
            if (this.buttons != null) {
                for (Button button : this.buttons) {
                    button.setEnabled(b);
                }
            }
        }

        @Override
        boolean isEnabled() {
            return this.inputtext.isEnabled();
        }
    }

    public abstract class InputWidget {
        Widget titlewidget;

        public abstract Widget getWidget();

        public abstract String getText();

        public abstract void setText(String var1);

        public abstract Color getNormalColor();

        public abstract Point getSize();

        public abstract void setBackground(Color var1);

        public abstract void dispose();

        protected abstract void checkboxChanged(SelectionEvent var1);

        public abstract ModifyListener removeDefaultModifyListener();

        public abstract void restoreDefaultModifyListener();

        public boolean isDisposed() {
            return this.getWidget().isDisposed();
        }

        public Display getDisplay() {
            return this.getWidget().getDisplay();
        }

        public ModifyListener getModifyListener(final InputWidget inputwidget) {
            return new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    UserInputWidget.this.userInputHasChanged((TypedEvent)e, inputwidget);
                    UserInputWidget.this.fireStateChanged();
                }
            };
        }

        public void createTitleWidget(Composite parent) {
            if (UserInputWidget.this.inputdata.isCheckBoxNeeded()) {
                Button button = new Button(parent, 32);
                button.setText(" " + UserInputWidget.this.inputdata.getTitle() + ": ");
                button.setLayoutData((Object)new GridData());
                QualifiedName qname = UserInputWidget.this.inputdata.getQualifiedCheckboxName(UserInputWidget.this.qualifier);
                if (UserInputWidget.this.persistentProp.containsKey(qname)) {
                    button.setSelection(Boolean.parseBoolean((String)UserInputWidget.this.persistentProp.get(qname)));
                } else {
                    button.setSelection(UserInputWidget.this.inputdata.isCheckBoxSelected());
                }
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        InputWidget.this.checkboxChanged(e);
                        UserInputWidget.this.fireStateChanged();
                    }
                });
                this.titlewidget = button;
                return;
            }
            Label label = new Label(parent, 0);
            label.setText(" " + UserInputWidget.this.inputdata.getTitle() + ": ");
            label.setLayoutData((Object)new GridData());
            this.titlewidget = label;
        }

        public boolean isCheckboxSelected() {
            if (this.titlewidget instanceof Button) {
                return ((Button)this.titlewidget).getSelection();
            }
            return true;
        }

        public void modifyText(String text) {
            ModifyListener listener = this.removeDefaultModifyListener();
            this.setText(text);
            if (listener != null) {
                listener.modifyText(this.createProgramModifyEvent());
            }
            this.restoreDefaultModifyListener();
        }

        private ModifyEvent createProgramModifyEvent() {
            Event e = new Event();
            e.type = 24;
            e.widget = this.getWidget();
            e.display = this.getDisplay();
            e.time = 0;
            e.data = new ProgramModifyMarker();
            return new ModifyEvent(e);
        }

        abstract void setEnabled(boolean var1);

        abstract boolean isEnabled();
    }

    private class ProgramModifyMarker {
        private ProgramModifyMarker() {
        }
    }

    public class UserInputWidgetEvent
    extends Event {
        private static final long serialVersionUID = 1L;
        private final UserInputWidget inputwidget;
        private final TypedEvent typedEvent;

        public UserInputWidgetEvent(TypedEvent event, UserInputWidget widget) {
            this.inputwidget = widget;
            this.typedEvent = event;
        }

        public UserInputWidget getInputWidget() {
            return this.inputwidget;
        }

        public TypedEvent getModifyEvent() {
            return this.typedEvent;
        }
    }
}

