/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.jdt.ant;

import com.vmware.vide.utils.resource.ResourceUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.Property;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntUtils {
    public static final String ANT_PROPERTIES_EXTENSION_ID = "com.vmware.vide.jdt.ant.properties";
    private static final Logger logger = LoggerFactory.getLogger(AntUtils.class);

    public static void scanForAntPropertyExtensions() {
        IConfigurationElement[] configElementList;
        logger.info("Scanning/updating {} extensions.", (Object)ANT_PROPERTIES_EXTENSION_ID);
        IConfigurationElement[] iConfigurationElementArray = configElementList = Platform.getExtensionRegistry().getConfigurationElementsFor(ANT_PROPERTIES_EXTENSION_ID);
        int n = configElementList.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            try {
                String tagName = configElement.getName();
                if (tagName.equals("property")) {
                    String declaringBundleId = configElement.getNamespaceIdentifier();
                    String propertyName = configElement.getAttribute("name");
                    String propertyValue = configElement.getAttribute("value");
                    logger.info("    Adding ant property variable from bundle={} name='{}' value='{}", new Object[]{declaringBundleId, propertyName, propertyValue});
                    if (propertyValue.startsWith("./")) {
                        File resolvedDirectory = ResourceUtils.getFileRelativeToBundle((String)declaringBundleId, (String)propertyValue);
                        AntUtils.setAntProperty(propertyName, resolvedDirectory.getAbsolutePath());
                    } else {
                        AntUtils.setAntProperty(propertyName, propertyValue);
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
    }

    public static void setAntProperty(String propertyName, String propertyValue) {
        Property[] properties;
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        boolean propertyExists = false;
        ArrayList<Property> temp = new ArrayList<Property>();
        List<Property> propertyList = Arrays.asList(prefs.getCustomProperties());
        for (Property p : propertyList) {
            if (!propertyName.equals(p.getName())) continue;
            p.setValue(propertyValue);
            logger.info("Updated ant property name='{}' to value='{}'", (Object)propertyName, (Object)propertyValue);
            propertyExists = true;
            break;
        }
        if (propertyExists) {
            properties = propertyList.toArray(new Property[0]);
            prefs.setCustomProperties(properties);
        } else {
            temp.add(new Property(propertyName, propertyValue));
            temp.addAll(Arrays.asList(prefs.getCustomProperties()));
            properties = temp.toArray(new Property[0]);
            prefs.setCustomProperties(properties);
            logger.info("Added new ant property name='{}' to value='{}'", (Object)propertyName, (Object)propertyValue);
        }
        prefs.updatePluginPreferences();
    }
}

