/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.manager;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.manager.AbstractProjectIdentity;
import com.vmware.vide.project.manager.DevkitProjectDescription;
import com.vmware.vide.project.manager.IProjectStorage;
import com.vmware.vide.project.manager.ProjectManager;
import com.vmware.vide.project.manager.ProjectStorageManager;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ProjectDescription {
    private static final ILog logger = ProjectPlugin.getDefault().getLog();
    private final IProject project;
    private final IProjectStorage projectstorage;

    protected ProjectDescription(IProject project) {
        this.project = project;
        this.projectstorage = ProjectDescription.getProjectStorage(project);
        if (this.projectstorage == null) {
            String msg = String.format("Failed to get a storage for the project [%s].", project.getName());
            throw new IllegalArgumentException(msg);
        }
        ProjectManager.getDefault().addProjectNature(project, "com.vmware.vide.core.vnature");
    }

    public Map<String, String> getAllProperties() {
        return this.projectstorage.getAllProjectProperties(this.project);
    }

    public String getProperty(String property) {
        return this.projectstorage.getProjectProperty(this.project, property);
    }

    public boolean putProperties(Map<String, String> properties, boolean overwrite) {
        return this.projectstorage.putProjectProperties(this.project, properties, overwrite);
    }

    public boolean putProperty(String property, String value, boolean overwrite) {
        return this.projectstorage.putProjectProperty(this.project, property, value, overwrite);
    }

    public static ProjectDescription getProjectDescription(IProject project) {
        if (project == null) {
            return null;
        }
        IProjectStorage storage = ProjectDescription.getProjectStorage(project);
        if (storage == null) {
            return null;
        }
        return new DevkitProjectDescription(project);
    }

    private static IProjectStorage getProjectStorage(IProject project) {
        try {
            String[] natureids = project.getDescription().getNatureIds();
            Map<String, AbstractProjectIdentity> identities = ProjectManager.getDefault().findProjectIdentities();
            String[] stringArray = natureids;
            int n = natureids.length;
            int n2 = 0;
            while (n2 < n) {
                String natureid = stringArray[n2];
                if (identities.containsKey(natureid)) {
                    AbstractProjectIdentity identity = identities.get(natureid);
                    if (identity.isProjectStorageAvailable()) {
                        return identity;
                    }
                    return ProjectStorageManager.getDefault();
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            String msg = String.format("Failed to get a project storage for the project [%s].", project.getName());
            logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg, (Throwable)e));
        }
        return null;
    }

    protected IProject getProject() {
        return this.project;
    }
}

