/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.preferences;

import com.vmware.vide.project.ProjectPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreferencePage
extends org.eclipse.jface.preference.PreferencePage
implements IWorkbenchPreferencePage {
    protected Button mySwitchPerspective;

    public PreferencePage() {
    }

    public PreferencePage(String title) {
        super(title);
    }

    public PreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
        IPreferenceStore store = ProjectPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
    }

    protected Control createContents(Composite parent) {
        IPreferenceStore store = ProjectPlugin.getDefault().getPreferenceStore();
        Composite box = new Composite(parent, 0);
        GridData gd = new GridData(768);
        parent.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        box.setLayout((Layout)layout);
        this.mySwitchPerspective = new Button(box, 32);
        this.mySwitchPerspective.setText("Automatically switch perspectives when project is opened.");
        String perspectivemode = store.getString("SWITCH_PERSPECTIVE_MODE");
        if (perspectivemode.equals("YES")) {
            this.mySwitchPerspective.setSelection(true);
        }
        return box;
    }

    protected void performDefaults() {
        IPreferenceStore store = ProjectPlugin.getDefault().getPreferenceStore();
        store.setValue("SWITCH_PERSPECTIVE_MODE", "No");
        store.setValue("KEEP_SWITCH_PERSPECTIVE_MODE", "never");
        this.mySwitchPerspective.setSelection(false);
    }

    public boolean performOk() {
        IPreferenceStore store = ProjectPlugin.getDefault().getPreferenceStore();
        String value = this.mySwitchPerspective.getSelection() ? "YES" : "No";
        store.setValue("SWITCH_PERSPECTIVE_MODE", value);
        return super.performOk();
    }
}

