/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.vib.ui;

import com.vmware.vide.project.vib.PropertyManager;
import com.vmware.vide.project.vib.VIBFileInfo;
import com.vmware.vide.project.vib.VIBProperty;
import com.vmware.vide.project.vib.ui.IVIBFormPage;
import com.vmware.vide.project.vib.ui.UIBlock;
import com.vmware.vide.project.vib.ui.VIBEditor;
import com.vmware.vide.vxmleditor.Activator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class VIBOverviewPage
extends FormPage
implements IVIBFormPage {
    private static final String ID_PAGE = "VIBOverviewPage";
    private static final String PAGE_TITLE = "VIB Editor";
    private static final String VIBINFO_SECTION = "VIB Package Information";
    private static final String KEY_HREF = "href";
    private VIBEditor vibeditor;
    private List<UIBlock> uiblocks = new ArrayList<UIBlock>();
    private List<VIBProperty> vibproperties;
    private List<VIBProperty> hyperlinkproperties;
    private String buildtype;
    private boolean isupdated;
    public Button buildvibbutton;
    private Set<VIBProperty> errorSet;

    public VIBOverviewPage(VIBEditor editor) {
        super((FormEditor)editor, ID_PAGE, PAGE_TITLE);
        this.vibeditor = editor;
        this.isupdated = false;
        this.errorSet = new HashSet<VIBProperty>();
    }

    public boolean isDirty() {
        return this.isupdated;
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        this.isupdated = false;
    }

    @Override
    public void setDirty(boolean b) {
        this.isupdated = b;
    }

    @Override
    public VIBEditor getVIBEditor() {
        return this.vibeditor;
    }

    @Override
    public VIBFileInfo getVIBFileInfo() {
        return null;
    }

    public void refresh(VIBFileInfo basevibfile) {
        for (UIBlock uiblock : this.uiblocks) {
            uiblock.refresh(basevibfile);
        }
    }

    private void collectVIBProperties() {
        this.vibproperties = new ArrayList<VIBProperty>();
        this.hyperlinkproperties = new ArrayList<VIBProperty>();
        PropertyManager manager = this.vibeditor.getVIBFileManager().getPropertyManager();
        VIBProperty[] vIBPropertyArray = manager.getAllProperties();
        int n = vIBPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            VIBProperty property = vIBPropertyArray[n2];
            if (property != null) {
                if (property.isHyperlinkProperty()) {
                    if (property.getVIBFile() != null) {
                        this.hyperlinkproperties.add(property);
                    }
                } else if (!property.isRelationshipsProperty() && !property.isPlatformsProperty() && !property.isHyperlinkWidget() && property.isVIB() && property.getVIBFile() != null) {
                    this.vibproperties.add(property);
                }
            }
            ++n2;
        }
    }

    protected void createFormContent(IManagedForm mform) {
        this.collectVIBProperties();
        super.createFormContent(mform);
        ScrolledForm form = mform.getForm();
        FormToolkit toolkit = mform.getToolkit();
        form.setText(PAGE_TITLE);
        form.setBackgroundImage(Activator.getDefault().getImage("from_background.gif"));
        toolkit.getHyperlinkGroup().setHyperlinkUnderlineMode(2);
        toolkit.decorateFormHeading(form.getForm());
        IMessageManager msgmanager = mform.getMessageManager();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 10;
        layout.marginWidth = 6;
        layout.horizontalSpacing = 20;
        form.getBody().setLayout((Layout)layout);
        GridData griddata = new GridData(1808);
        griddata.horizontalAlignment = 4;
        griddata.grabExcessHorizontalSpace = true;
        griddata.heightHint = 300;
        form.setLayoutData((Object)griddata);
        if (!this.vibproperties.isEmpty()) {
            this.createVIBPropertySection(form, msgmanager, toolkit);
        }
        this.createLinkSections(form, toolkit);
        msgmanager.update();
    }

    private void createVIBPropertySection(ScrolledForm form, IMessageManager mmanager, FormToolkit toolkit) {
        Section section = toolkit.createSection(form.getBody(), 322);
        section.setText(VIBINFO_SECTION);
        Composite parent = toolkit.createComposite((Composite)section);
        section.setClient((Control)parent);
        GridData gd = new GridData(1808);
        gd.horizontalAlignment = 4;
        section.setLayoutData((Object)gd);
        GridLayout glayout = new GridLayout();
        glayout.horizontalSpacing = 10;
        glayout.numColumns = 3;
        glayout.marginTop = 10;
        parent.setLayout((Layout)glayout);
        for (VIBProperty property : this.vibproperties) {
            this.uiblocks.add(new UIBlock(this, toolkit, parent, mmanager, property));
        }
    }

    private void createLinkSections(ScrolledForm form, FormToolkit toolkit) {
        Composite parent = toolkit.createComposite(form.getBody());
        GridData gd = new GridData(1808);
        parent.setLayoutData((Object)gd);
        GridLayout glayout = new GridLayout();
        glayout.horizontalSpacing = 10;
        glayout.numColumns = 1;
        parent.setLayout((Layout)glayout);
        toolkit.paintBordersFor(parent);
        for (VIBProperty property : this.hyperlinkproperties) {
            String title = property.getHyperlinkTitle();
            String formtext = property.getHyperlinkFormText();
            if (title == null || formtext == null) continue;
            this.createHyperlinkSection(parent, toolkit, title, property.getDescription(), formtext);
        }
        if (this.vibeditor.getVIBFileManager().isVIBBuildCommandAvailable()) {
            this.createBuildSection(parent, toolkit);
        }
    }

    private void createHyperlinkSection(Composite parent, FormToolkit toolkit, String title, String description, String formtext) {
        Section section = toolkit.createSection(parent, 322);
        Composite composite = toolkit.createComposite((Composite)section);
        section.setClient((Control)composite);
        section.setText(VIBOverviewPage.capitalizeFirstCharOnly(title));
        section.setDescription(description);
        GridData gd = new GridData(768);
        gd.widthHint = 100;
        section.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        layout.marginTop = 10;
        composite.setLayout((Layout)layout);
        final FormText hyperlinktext = toolkit.createFormText(composite, true);
        gd = new GridData(512);
        hyperlinktext.setLayoutData((Object)gd);
        hyperlinktext.setText(formtext, true, false);
        hyperlinktext.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkEntered(HyperlinkEvent e) {
                if (e.getHref() != null) {
                    hyperlinktext.setData(VIBOverviewPage.KEY_HREF, e.getHref());
                }
            }

            public void linkExited(HyperlinkEvent e) {
                hyperlinktext.setData(VIBOverviewPage.KEY_HREF, null);
            }
        });
        hyperlinktext.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                Object o = hyperlinktext.getData(VIBOverviewPage.KEY_HREF);
                if (o != null) {
                    VIBOverviewPage.this.vibeditor.getVIBFileManager().activateDesignPage(o.toString(), true);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }
        });
    }

    private void createBuildSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 322);
        Composite composite = toolkit.createComposite((Composite)section);
        section.setClient((Control)composite);
        section.setText("Build VIB Package");
        GridData gd = new GridData(1808);
        section.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        String[] types = this.vibeditor.getVIBFileManager().getBuildTypes();
        if (types.length > 0) {
            this.createBuildTypeSelection(toolkit, composite, this.vibeditor.getVIBFileManager().getDefaultBuildType(), types);
        }
        this.buildvibbutton = toolkit.createButton(composite, "Build VIB Package", 8);
        this.buildvibbutton.setSelection(true);
        gd = new GridData(4);
        this.buildvibbutton.setLayoutData((Object)gd);
        this.buildvibbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                VIBOverviewPage.this.vibeditor.getVIBFileManager().buildVIBPackage(VIBOverviewPage.this.buildtype);
            }
        });
        this.enableBuildButton(!this.isErrorOnPage());
    }

    public void createBuildTypeSelection(FormToolkit toolkit, Composite parent, String defvalue, String[] types) {
        Composite composite = toolkit.createComposite(parent);
        GridData gd = new GridData(4);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginRight = 30;
        layout.marginWidth = 10;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        toolkit.createLabel(composite, "Select VIB Build Type");
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            final Button button = toolkit.createButton(composite, type, 16);
            if (type.equals(defvalue)) {
                button.setSelection(true);
            }
            GridData griddata = new GridData();
            griddata.horizontalIndent = 10;
            button.setLayoutData((Object)griddata);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (button.getSelection()) {
                        VIBOverviewPage.this.buildtype = button.getText();
                    }
                }
            });
            ++n2;
        }
    }

    public static String capitalizeFirstCharOnly(String text) {
        String first = text.substring(0, 1);
        return String.valueOf(first.toUpperCase()) + text.substring(1);
    }

    private boolean isErrorOnPage() {
        return !this.errorSet.isEmpty();
    }

    public void enableBuildButton(boolean enable) {
        if (this.buildvibbutton != null) {
            this.buildvibbutton.setEnabled(enable);
        }
    }

    @Override
    public void addErrorOnPage(VIBProperty errorProperty) {
        this.errorSet.add(errorProperty);
    }

    public void addErrorMaptoOverviewPage(Set<VIBProperty> errorProperties) {
        this.errorSet.addAll(errorProperties);
        this.enableBuildButton(!this.isErrorOnPage());
    }

    @Override
    public void removeErrorOnPage(VIBProperty errorProperty) {
        this.errorSet.remove(errorProperty);
        this.enableBuildButton(!this.isErrorOnPage());
    }

    @Override
    public Set<VIBProperty> getErrorSet() {
        return this.errorSet;
    }

    public void findErrorsOnPage() {
        if (this.vibproperties == null) {
            return;
        }
        this.errorSet.clear();
        for (VIBProperty prop : this.vibproperties) {
            if (!prop.isTextWidget() || prop.getInputFormat() == null) continue;
            String propString = prop.getPropertyValue();
            if (propString == null) {
                propString = "";
            }
            if (propString.matches(prop.getInputFormat())) {
                this.removeErrorOnPage(prop);
                continue;
            }
            this.addErrorOnPage(prop);
        }
    }
}

