/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcenter.inventory.util;

import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vcenter.inventory.DatastoreDefinitions;
import com.vmware.vcenter.inventory.NetworkDefinitions;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class StructTypeUtil {
    public static void populateCanonicalNameToStructTypeMap(Map<String, StructType> mapping) {
        Validate.notNull(mapping);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.inventory.datastore.info", DatastoreDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.inventory.network.info", NetworkDefinitions.info);
    }

    private static void add(Map<String, StructType> mapping, String key, StructType structType) {
        if (mapping.containsKey(key)) {
            throw new IllegalArgumentException("Two structures with the same canonical name detected: " + key + ". Unable to populate the map.");
        }
        mapping.put(key, structType);
    }
}

