/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.common;

import com.vmware.vapi.bindings.StubConfiguration;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.ConfigurationException;
import vmware.samples.common.ParametersHelper;
import vmware.samples.common.SslUtil;
import vmware.samples.common.authentication.VapiAuthenticationHelper;
import vmware.samples.common.authentication.VimAuthenticationHelper;

public abstract class SamplesAbstractBase {
    protected String server;
    protected String username;
    protected String password;
    protected boolean clearData;
    protected boolean skipServerVerification;
    protected String truststorePath;
    protected String truststorePassword;
    protected String configFile;
    protected VimAuthenticationHelper vimAuthHelper;
    protected VapiAuthenticationHelper vapiAuthHelper;
    protected StubConfiguration sessionStubConfig;
    protected Map<String, Object> parsedOptions = null;

    protected void parseArgs(List<Option> sampleOptions, String[] args) {
        ParametersHelper paramsHelper = null;
        try {
            Object truststorePasswordObj;
            Option serverOption = Option.builder().required(true).hasArg().argName("SERVER").longOpt("server").desc("hostname of vCenter Server").build();
            Option usernameOption = Option.builder().required(true).hasArg().argName("USERNAME").longOpt("username").desc("username to login to the vCenter Server").build();
            Option passwordOption = Option.builder().required(true).hasArg().argName("PASSWORD").longOpt("password").desc("password to login to the vCenter Server").build();
            Option cleardataOption = Option.builder().required(false).longOpt("cleardata").type(Boolean.class).desc("OPTIONAL: Specify this option to undo all persistent results of running the sample.").build();
            Option skipServerVerificationOption = Option.builder().required(false).longOpt("skip-server-verification").type(Boolean.class).desc("OPTIONAL: Specify this option if you do not want to perform SSL certificate verification.\nNOTE: Circumventing SSL trust in this manner is unsafe and should not be used with production code. This is ONLY FOR THE PURPOSE OF DEVELOPMENT ENVIRONMENT.").build();
            Option truststorePathOption = Option.builder().required(false).hasArg().argName("ABSOLUTE PATH OF JAVA TRUSTSTORE FILE").longOpt("truststorepath").desc("Specify the absolute path to the file containing the trusted server certificates. This option can be skipped if the parameter skip-server-verification is specified.").build();
            Option truststorePasswordOption = Option.builder().required(false).hasArg().argName("JAVA TRUSTSTORE PASSWORD").longOpt("truststorepassword").desc("Specify the password for the java truststore. This option can be skipped if the parameter skip-server-verification is specified.").build();
            Option configFileOption = Option.builder().required(false).hasArg().argName("CONFIGURATION FILE").longOpt("config-file").desc("OPTIONAL: Absolute path to  the configuration file containing the sample options.\nNOTE: Parameters can be specified either in the configuration file or on the command line. Command line parameters will override values specified in the configuration file.").build();
            ArrayList<Option> optionList = new ArrayList<Option>(Arrays.asList(configFileOption, serverOption, usernameOption, passwordOption));
            optionList.addAll(sampleOptions);
            optionList.addAll(Arrays.asList(truststorePathOption, truststorePasswordOption, cleardataOption, skipServerVerificationOption));
            paramsHelper = new ParametersHelper(optionList);
            this.parsedOptions = paramsHelper.parse(args);
            this.server = (String)this.parsedOptions.get("server");
            this.username = (String)this.parsedOptions.get("username");
            this.password = (String)this.parsedOptions.get("password");
            Object clearDataObj = this.parsedOptions.get("cleardata");
            this.clearData = clearDataObj != null ? (Boolean)clearDataObj : false;
            Object skipServerVerificationObj = this.parsedOptions.get("skip-server-verification");
            this.skipServerVerification = skipServerVerificationObj != null ? (Boolean)skipServerVerificationObj : false;
            Object truststorePathObj = this.parsedOptions.get("truststorepath");
            if (truststorePathObj != null) {
                this.truststorePath = (String)this.parsedOptions.get("truststorepath");
            }
            if ((truststorePasswordObj = this.parsedOptions.get("truststorepassword")) != null) {
                this.truststorePassword = (String)this.parsedOptions.get("truststorepassword");
            }
            String string = this.configFile = this.parsedOptions.get("config-file") != null ? (String)this.parsedOptions.get("config-file") : null;
            if (!(this.skipServerVerification || this.truststorePath != null && this.truststorePassword != null)) {
                throw new ConfigurationException("The parameters truststorepath and truststorepassword need to be specified for server certificate  verification. These are required parameters if the parameter skip-server-verification has not been specified.");
            }
        }
        catch (ParseException pex) {
            System.out.println(pex.getMessage());
            System.exit(0);
        }
        catch (ConfigurationException cex) {
            System.out.println(cex.getMessage());
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public String getServer() {
        return this.server;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isClearData() {
        return this.clearData;
    }

    public boolean isSkipServerVerification() {
        return this.skipServerVerification;
    }

    public String getTruststorePath() {
        return this.truststorePath;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public Map<String, Object> getParsedOptions() {
        return this.parsedOptions;
    }

    protected abstract void parseArgs(String[] var1);

    protected abstract void setup() throws Exception;

    protected abstract void run() throws Exception;

    protected abstract void cleanup() throws Exception;

    protected void login() throws Exception {
        this.vapiAuthHelper = new VapiAuthenticationHelper();
        this.vimAuthHelper = new VimAuthenticationHelper();
        KeyStore trustStore = this.setupSslTrustForServer();
        this.sessionStubConfig = this.vapiAuthHelper.loginByUsernameAndPassword(this.server, this.username, this.password, trustStore);
        this.vimAuthHelper.loginByUsernameAndPassword(this.server, this.username, this.password);
    }

    protected KeyStore setupSslTrustForServer() throws Exception {
        KeyStore trustStore;
        if (this.skipServerVerification) {
            SslUtil.trustAllHttpsCertificates();
            trustStore = SslUtil.createTrustStoreForServer("https://" + this.server);
        } else {
            trustStore = SslUtil.loadTrustStore(this.truststorePath, this.truststorePassword);
            System.setProperty("javax.net.ssl.trustStore", this.truststorePath);
        }
        return trustStore;
    }

    protected void logout() throws Exception {
        this.vapiAuthHelper.logout();
        this.vimAuthHelper.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(String[] args) throws Exception {
        try {
            this.parseArgs(args);
            this.login();
            this.setup();
            this.run();
            if (this.clearData) {
                this.cleanup();
            }
        }
        finally {
            this.logout();
        }
    }
}

