/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.common.authentication;

import com.vmware.cis.Session;
import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.bindings.StubFactory;
import com.vmware.vapi.cis.authn.ProtocolFactory;
import com.vmware.vapi.cis.authn.SecurityContextFactory;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.protocol.ProtocolConnection;
import com.vmware.vapi.saml.SamlToken;
import com.vmware.vapi.security.SessionSecurityContext;
import java.security.KeyStore;

public class VapiAuthenticationHelper {
    private Session sessionSvc;
    private StubFactory stubFactory;
    public static final String VAPI_PATH = "/api";

    public StubConfiguration loginByUsernameAndPassword(String server, String username, String password, KeyStore trustStore) throws Exception {
        if (this.sessionSvc != null) {
            throw new Exception("Session already created");
        }
        this.stubFactory = this.createApiStubFactory(server, trustStore);
        ExecutionContext.SecurityContext securityContext = SecurityContextFactory.createUserPassSecurityContext((String)username, (char[])password.toCharArray());
        StubConfiguration stubConfig = new StubConfiguration(securityContext);
        Session session = (Session)this.stubFactory.createStub(Session.class, (StubConfigurationBase)stubConfig);
        char[] sessionId = session.create();
        SessionSecurityContext sessionSecurityContext = new SessionSecurityContext(sessionId);
        stubConfig.setSecurityContext((ExecutionContext.SecurityContext)sessionSecurityContext);
        this.sessionSvc = (Session)this.stubFactory.createStub(Session.class, (StubConfigurationBase)stubConfig);
        return stubConfig;
    }

    public StubConfiguration loginBySamlBearerToken(String server, SamlToken samlBearerToken, KeyStore trustStore) throws Exception {
        if (this.sessionSvc != null) {
            throw new Exception("Session already created");
        }
        this.stubFactory = this.createApiStubFactory(server, trustStore);
        ExecutionContext.SecurityContext samlSecurityContext = SecurityContextFactory.createSamlSecurityContext((SamlToken)samlBearerToken, null);
        StubConfiguration stubConfig = new StubConfiguration(samlSecurityContext);
        Session session = (Session)this.stubFactory.createStub(Session.class, (StubConfigurationBase)stubConfig);
        char[] sessionId = session.create();
        SessionSecurityContext sessionSecurityContext = new SessionSecurityContext(sessionId);
        stubConfig.setSecurityContext((ExecutionContext.SecurityContext)sessionSecurityContext);
        this.sessionSvc = (Session)this.stubFactory.createStub(Session.class, (StubConfigurationBase)stubConfig);
        return stubConfig;
    }

    public void logout() {
        if (this.sessionSvc != null) {
            this.sessionSvc.delete();
        }
    }

    private StubFactory createApiStubFactory(String server, KeyStore trustStore) throws Exception {
        ProtocolFactory pf = new ProtocolFactory();
        String apiUrl = "https://" + server + VAPI_PATH;
        ProtocolConnection connection = pf.getConnection("http", apiUrl, trustStore);
        ApiProvider provider = connection.getApiProvider();
        StubFactory stubFactory = new StubFactory(provider);
        return stubFactory;
    }

    public StubFactory getStubFactory() {
        return this.stubFactory;
    }
}

