/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.contentlibrary.crud;

import com.vmware.content.LibraryModel;
import com.vmware.content.library.StorageBacking;
import com.vmware.vim25.ManagedObjectReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.cli.Option;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.common.vim.helpers.VimUtil;
import vmware.samples.contentlibrary.client.ClsApiClient;

public class LibraryCrud
extends SamplesAbstractBase {
    private String dsName;
    private String libName = "demo-local-lib";
    private ClsApiClient client;
    private LibraryModel localLibrary;

    @Override
    protected void parseArgs(String[] args) {
        Option dsNameOption = Option.builder().required(true).hasArg().argName("DATASTORE").longOpt("datastore").desc("The name of the VC datastore to be used for the local library.").build();
        ArrayList<Option> optionList = new ArrayList<Option>();
        optionList.add(dsNameOption);
        super.parseArgs(optionList, args);
        this.dsName = (String)this.parsedOptions.get("datastore");
    }

    @Override
    protected void setup() throws Exception {
        this.client = new ClsApiClient(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig);
    }

    @Override
    protected void run() throws Exception {
        List visibleCls = this.client.localLibraryService().list();
        System.out.println("All libraries : " + visibleCls);
        ManagedObjectReference dsMoref = VimUtil.getEntityByName(this.vimAuthHelper.getVimPort(), this.vimAuthHelper.getServiceContent(), this.dsName, "Datastore");
        assert (dsMoref != null);
        System.out.println("Datastore MoRef : " + dsMoref.getType() + " : " + dsMoref.getValue());
        StorageBacking storage = new StorageBacking();
        storage.setType(StorageBacking.Type.DATASTORE);
        storage.setDatastoreId(dsMoref.getValue());
        LibraryModel createSpec = new LibraryModel();
        createSpec.setName(this.libName);
        createSpec.setDescription("Local library backed by VC datastore");
        createSpec.setType(LibraryModel.LibraryType.LOCAL);
        createSpec.setStorageBackings(Collections.singletonList(storage));
        String clientToken = UUID.randomUUID().toString();
        String libraryId = this.client.localLibraryService().create(clientToken, createSpec);
        System.out.println("Local library created : " + libraryId);
        this.localLibrary = this.client.localLibraryService().get(libraryId);
        System.out.println("Retrieved library : " + this.localLibrary);
        LibraryModel updateSpec = new LibraryModel();
        updateSpec.setDescription("new description");
        this.client.localLibraryService().update(libraryId, updateSpec);
        System.out.println("Updated library description");
    }

    @Override
    protected void cleanup() throws Exception {
        if (this.localLibrary != null) {
            this.client.localLibraryService().delete(this.localLibrary.getId());
            System.out.println("Deleted library : " + this.localLibrary.getId());
        }
    }

    public static void main(String[] args) throws Exception {
        new LibraryCrud().execute(args);
    }
}

