/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.sso.embeddedpsc;

import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.saml.SamlToken;
import com.vmware.vcenter.Datacenter;
import com.vmware.vcenter.DatacenterTypes;
import java.security.KeyStore;
import java.util.Collections;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.common.authentication.VapiAuthenticationHelper;
import vmware.samples.sso.SsoHelper;

public class EmbeddedPscSsoWorkflow
extends SamplesAbstractBase {
    private Datacenter datacenterService;
    public static final String SSO_PATH = "/sts/STSService";

    @Override
    public void parseArgs(String[] args) {
        super.parseArgs(Collections.emptyList(), args);
    }

    @Override
    protected void setup() throws Exception {
    }

    @Override
    public void run() throws Exception {
        System.out.println("\n\n#### Example: Login to vCenter server with embedded Platform Services Controller");
        this.vapiAuthHelper = new VapiAuthenticationHelper();
        String ssoUrl = "https://" + this.server + SSO_PATH;
        KeyStore trustStore = this.setupSslTrustForServer();
        System.out.println("\nStep 1: Connect to the Single Sign-On URL and retrieve the SAML bearer token.");
        SamlToken samlBearerToken = SsoHelper.getSamlBearerToken(ssoUrl, this.username, this.password);
        System.out.println("\nStep 2. Login to vAPI services using the SAML bearer token.");
        StubConfiguration sessionStubConfig = this.vapiAuthHelper.loginBySamlBearerToken(this.server, samlBearerToken, trustStore);
        System.out.println("\nStep 3: Perform certain tasks using the vAPI services.");
        this.datacenterService = (Datacenter)this.vapiAuthHelper.getStubFactory().createStub(Datacenter.class, (StubConfigurationBase)sessionStubConfig);
        System.out.println("\nList of datacenters on the vcenter server:\n" + this.datacenterService.list(new DatacenterTypes.FilterSpec()));
        this.vapiAuthHelper.logout();
    }

    @Override
    protected void cleanup() throws Exception {
    }

    public static void main(String[] args) throws Exception {
        EmbeddedPscSsoWorkflow embeddedPscSsoWorkflow = null;
        embeddedPscSsoWorkflow = new EmbeddedPscSsoWorkflow();
        embeddedPscSsoWorkflow.parseArgs(args);
        embeddedPscSsoWorkflow.run();
    }
}

