/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.vcenter.vm.hardware.memory;

import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vcenter.vm.hardware.Memory;
import com.vmware.vcenter.vm.hardware.MemoryTypes;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.Option;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.vcenter.helpers.VmHelper;

public class MemoryConfiguration
extends SamplesAbstractBase {
    private String vmName;
    private String vmId;
    private MemoryTypes.Info originalMemoryInfo;
    private Memory memoryService;

    @Override
    protected void parseArgs(String[] args) {
        Option vmNameOption = Option.builder().longOpt("vmname").desc("The name of the vm for which memory needs to be configured.").required(true).hasArg().argName("VM NAME").build();
        List<Option> optionList = Collections.singletonList(vmNameOption);
        super.parseArgs(optionList, args);
        this.vmName = (String)this.parsedOptions.get("vmname");
    }

    @Override
    protected void setup() throws Exception {
        this.memoryService = (Memory)this.vapiAuthHelper.getStubFactory().createStub(Memory.class, (StubConfigurationBase)this.sessionStubConfig);
        System.out.println("\n\n#### Setup: Get the virtual machine id");
        this.vmId = VmHelper.getVM(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig, this.vmName);
        System.out.println("Using VM: " + this.vmName + " (vmId=" + this.vmId + " ) for memory configuration sample.");
    }

    @Override
    protected void run() throws Exception {
        System.out.println("\n\n#### Print original memory info.");
        MemoryTypes.Info memoryInfo = this.memoryService.get(this.vmId);
        System.out.println(memoryInfo);
        this.originalMemoryInfo = memoryInfo;
        System.out.println("\n\n#### Example: Update memory size field of memory configuration.");
        MemoryTypes.UpdateSpec memoryUpdateSpec = new MemoryTypes.UpdateSpec.Builder().setSizeMiB(Long.valueOf(8192L)).build();
        this.memoryService.update(this.vmId, memoryUpdateSpec);
        System.out.println(memoryUpdateSpec);
        memoryInfo = this.memoryService.get(this.vmId);
        System.out.println(memoryInfo);
        System.out.println("\n\n#### Example: Update hot add enabled field of memory configuration.");
        memoryUpdateSpec = new MemoryTypes.UpdateSpec.Builder().setHotAddEnabled(Boolean.valueOf(true)).build();
        this.memoryService.update(this.vmId, memoryUpdateSpec);
        System.out.println(memoryUpdateSpec);
        memoryInfo = this.memoryService.get(this.vmId);
        System.out.println(memoryInfo);
    }

    @Override
    protected void cleanup() throws Exception {
        System.out.println("\n\n#### Cleanup: Revert memory configuration.");
        MemoryTypes.UpdateSpec memoryUpdateSpec = new MemoryTypes.UpdateSpec.Builder().setHotAddEnabled(Boolean.valueOf(this.originalMemoryInfo.getHotAddEnabled())).setSizeMiB(Long.valueOf(this.originalMemoryInfo.getSizeMiB())).build();
        this.memoryService.update(this.vmId, memoryUpdateSpec);
        System.out.println(memoryUpdateSpec);
        MemoryTypes.Info memoryInfo = this.memoryService.get(this.vmId);
        System.out.println(memoryInfo);
    }

    public static void main(String[] args) throws Exception {
        new MemoryConfiguration().execute(args);
    }
}

