/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.core;

import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.data.DataDefinition;
import com.vmware.vapi.data.ErrorDefinition;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MethodDefinition {
    private MethodIdentifier id;
    private DataDefinition input;
    private DataDefinition output;
    private Set<ErrorDefinition> errorDefs;
    private Map<String, ErrorDefinition> errorDefsMap;

    public MethodDefinition(MethodIdentifier id, DataDefinition input, DataDefinition output, Set<ErrorDefinition> errors) {
        if (id == null) {
            throw new IllegalArgumentException("Method identifier is required.");
        }
        if (input == null) {
            throw new IllegalArgumentException("Data definition of the method input is required.");
        }
        if (output == null) {
            throw new IllegalArgumentException("Data definition of the method output is required.");
        }
        if (errors == null) {
            this.errorDefs = Collections.emptySet();
            this.errorDefsMap = Collections.emptyMap();
        } else {
            this.errorDefs = Collections.unmodifiableSet(new HashSet<ErrorDefinition>(errors));
            this.errorDefsMap = Collections.unmodifiableMap(MethodDefinition.createErrorMap(errors));
        }
        this.id = id;
        this.input = input;
        this.output = output;
    }

    public MethodIdentifier getIdentifier() {
        return this.id;
    }

    public DataDefinition getInputDefinition() {
        return this.input;
    }

    public DataDefinition getOutputDefinition() {
        return this.output;
    }

    public Set<ErrorDefinition> getErrorDefinitions() {
        return Collections.unmodifiableSet(this.errorDefs);
    }

    public ErrorDefinition getErrorDefinition(String errorName) {
        if (errorName == null) {
            throw new NullPointerException();
        }
        return this.errorDefsMap.get(errorName);
    }

    private static Map<String, ErrorDefinition> createErrorMap(Set<ErrorDefinition> errorDefs) {
        HashMap<String, ErrorDefinition> errorMap = new HashMap<String, ErrorDefinition>();
        for (ErrorDefinition def : errorDefs) {
            errorMap.put(def.getName(), def);
        }
        return errorMap;
    }

    public String toString() {
        return "Method id: " + this.id.toString() + "\n" + " Input: " + this.input.toString() + "\n" + " Output: " + this.output.toString() + "\n" + " Errors: " + this.errorDefs.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodDefinition)) {
            return false;
        }
        MethodDefinition other = (MethodDefinition)obj;
        return this.getIdentifier().equals(other.getIdentifier()) && this.getInputDefinition().equals(other.getInputDefinition()) && this.getOutputDefinition().equals(other.getOutputDefinition()) && this.getErrorDefinitions().equals(other.getErrorDefinitions());
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.getIdentifier().hashCode();
        hash = hash * 31 + this.getInputDefinition().hashCode();
        hash = hash * 31 + this.getOutputDefinition().hashCode();
        hash = hash * 31 + this.getErrorDefinitions().hashCode();
        return hash;
    }
}

