/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.bindings.ApiError;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.bindings.type.AnyErrorType;
import com.vmware.vapi.bindings.type.DynamicStructType;
import com.vmware.vapi.bindings.type.EnumType;
import com.vmware.vapi.bindings.type.ErrorType;
import com.vmware.vapi.bindings.type.ListType;
import com.vmware.vapi.bindings.type.MapType;
import com.vmware.vapi.bindings.type.OptionalType;
import com.vmware.vapi.bindings.type.SetType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.data.BlobValue;
import com.vmware.vapi.data.BooleanValue;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DoubleValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.SecretValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.convert.ConverterFactory;
import com.vmware.vapi.internal.bindings.convert.NameToTypeResolver;
import com.vmware.vapi.internal.bindings.convert.PrimitiveConverter;
import com.vmware.vapi.internal.bindings.convert.UniTypeConverter;
import com.vmware.vapi.internal.bindings.convert.impl.ApiEnumerationEnumConverter;
import com.vmware.vapi.internal.bindings.convert.impl.ByteArrayBinaryConverter;
import com.vmware.vapi.internal.bindings.convert.impl.CharArraySecretConverter;
import com.vmware.vapi.internal.bindings.convert.impl.DataValueOpaqueConverter;
import com.vmware.vapi.internal.bindings.convert.impl.JavaClassStructConverter;
import com.vmware.vapi.internal.bindings.convert.impl.JavaLangBooleanBooleanConverter;
import com.vmware.vapi.internal.bindings.convert.impl.JavaLangDoubleDoubleConverter;
import com.vmware.vapi.internal.bindings.convert.impl.JavaLangLongIntegerConverter;
import com.vmware.vapi.internal.bindings.convert.impl.JavaLangStringIdConverter;
import com.vmware.vapi.internal.bindings.convert.impl.JavaLangStringStringConverter;
import com.vmware.vapi.internal.bindings.convert.impl.JavaNetUriUriConverter;
import com.vmware.vapi.internal.bindings.convert.impl.JavaUtilCalendarDateTimeConverter;
import com.vmware.vapi.internal.bindings.convert.impl.JavaUtilListListConverter;
import com.vmware.vapi.internal.bindings.convert.impl.JavaUtilMapMapConverter;
import com.vmware.vapi.internal.bindings.convert.impl.JavaUtilSetSetConverter;
import com.vmware.vapi.internal.bindings.convert.impl.MapBasedNameToTypeResolver;
import com.vmware.vapi.internal.bindings.convert.impl.NullVoidConverter;
import com.vmware.vapi.internal.bindings.convert.impl.NullableReferenceOptionalConverter;
import com.vmware.vapi.internal.bindings.convert.impl.StaticErrorAnyErrorConverter;
import com.vmware.vapi.internal.bindings.convert.impl.StaticStructureDynamicStructureConverter;
import org.apache.commons.lang.Validate;

public class DefaultConverterFactory
implements ConverterFactory {
    private PrimitiveConverter<IntegerValue> integerConverter = new JavaLangLongIntegerConverter();
    private PrimitiveConverter<DoubleValue> doubleConverter = new JavaLangDoubleDoubleConverter();
    private PrimitiveConverter<BooleanValue> booleanConverter = new JavaLangBooleanBooleanConverter();
    private PrimitiveConverter<StringValue> stringConverter = new JavaLangStringStringConverter();
    private PrimitiveConverter<BlobValue> binaryConverter = new ByteArrayBinaryConverter();
    private PrimitiveConverter<SecretValue> secretConverter = new CharArraySecretConverter();
    private PrimitiveConverter<StringValue> dateTimeConverter = new JavaUtilCalendarDateTimeConverter();
    private PrimitiveConverter<StringValue> uriConverter = new JavaNetUriUriConverter();
    private PrimitiveConverter<VoidValue> voidConverter = new NullVoidConverter();
    private PrimitiveConverter<DataValue> opaqueConverter = new DataValueOpaqueConverter();
    private final UniTypeConverter<StructValue, DynamicStructType> dynamicStructConverter;
    private final UniTypeConverter<ListValue, ListType> listConverter = new JavaUtilListListConverter();
    private final UniTypeConverter<StructValue, StructType> structConverter = new JavaClassStructConverter<StructValue, StructType>(StructValue.class, Structure.class);
    private UniTypeConverter<ErrorValue, ErrorType> errorConverter = new JavaClassStructConverter<ErrorValue, ErrorType>(ErrorValue.class, ApiError.class);
    private final UniTypeConverter<OptionalValue, OptionalType> optionalConverter = new NullableReferenceOptionalConverter();
    private UniTypeConverter<StringValue, EnumType> enumConverter = new ApiEnumerationEnumConverter();
    private PrimitiveConverter<StringValue> idConverter = new JavaLangStringIdConverter();
    private UniTypeConverter<ListValue, SetType> setConverter = new JavaUtilSetSetConverter();
    private final UniTypeConverter<ListValue, MapType> mapConverter = new JavaUtilMapMapConverter();
    private final UniTypeConverter<ErrorValue, AnyErrorType> anyErrorConverter;

    public DefaultConverterFactory() {
        this(new MapBasedNameToTypeResolver(MapBasedNameToTypeResolver.STANDARD_ERRORS));
    }

    public DefaultConverterFactory(NameToTypeResolver nameToTypeResolver) {
        Validate.notNull((Object)nameToTypeResolver);
        this.anyErrorConverter = new StaticErrorAnyErrorConverter(nameToTypeResolver);
        this.dynamicStructConverter = new StaticStructureDynamicStructureConverter(nameToTypeResolver);
    }

    @Override
    public PrimitiveConverter<IntegerValue> getIntegerConverter() {
        return this.integerConverter;
    }

    @Override
    public PrimitiveConverter<DoubleValue> getDoubleConverter() {
        return this.doubleConverter;
    }

    @Override
    public PrimitiveConverter<BooleanValue> getBooleanConverter() {
        return this.booleanConverter;
    }

    @Override
    public PrimitiveConverter<StringValue> getStringConverter() {
        return this.stringConverter;
    }

    @Override
    public PrimitiveConverter<BlobValue> getBinaryConverter() {
        return this.binaryConverter;
    }

    @Override
    public PrimitiveConverter<SecretValue> getSecretConverter() {
        return this.secretConverter;
    }

    @Override
    public PrimitiveConverter<StringValue> getDateTimeConverter() {
        return this.dateTimeConverter;
    }

    @Override
    public PrimitiveConverter<StringValue> getUriConverter() {
        return this.uriConverter;
    }

    @Override
    public PrimitiveConverter<VoidValue> getVoidConverter() {
        return this.voidConverter;
    }

    @Override
    public PrimitiveConverter<DataValue> getOpaqueConverter() {
        return this.opaqueConverter;
    }

    @Override
    public UniTypeConverter<StructValue, DynamicStructType> getDynamicStructureConverter() {
        return this.dynamicStructConverter;
    }

    @Override
    public UniTypeConverter<ListValue, ListType> getListConverter() {
        return this.listConverter;
    }

    @Override
    public UniTypeConverter<StructValue, StructType> getStructConverter() {
        return this.structConverter;
    }

    @Override
    public UniTypeConverter<ErrorValue, ErrorType> getErrorConverter() {
        return this.errorConverter;
    }

    @Override
    public UniTypeConverter<OptionalValue, OptionalType> getOptionalConverter() {
        return this.optionalConverter;
    }

    @Override
    public UniTypeConverter<StringValue, EnumType> getEnumConverter() {
        return this.enumConverter;
    }

    @Override
    public PrimitiveConverter<StringValue> getIdConverter() {
        return this.idConverter;
    }

    @Override
    public UniTypeConverter<ListValue, SetType> getSetConverter() {
        return this.setConverter;
    }

    @Override
    public UniTypeConverter<ListValue, MapType> getMapConverter() {
        return this.mapConverter;
    }

    @Override
    public UniTypeConverter<ErrorValue, AnyErrorType> getAnyErrorConverter() {
        return this.anyErrorConverter;
    }
}

