/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.diagnostics;

import com.vmware.vapi.internal.diagnostics.DiagnosticsKey;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiagnosticsManager
implements DynamicMBean {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosticsManager.class);
    private static final String ROOT_COMPONENT = "com.vmware.vapi";
    private static final String OBJECT_FORMAT = "com.vmware.vapi:type=%s,id=%s";
    private final ConcurrentMap<String, AtomicLong> counters;
    private final List<AtomicLong> stopwatchSamples;
    private final DiagnosticsKey key;
    private int samples = 1;

    public static DiagnosticsManager createAndExport(DiagnosticsKey diagnosticsKey) {
        Validate.notNull((Object)diagnosticsKey);
        DiagnosticsManager bean = new DiagnosticsManager(diagnosticsKey);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName name = DiagnosticsManager.createObjectName(bean);
            server.registerMBean(bean, name);
        }
        catch (Exception ex) {
            logger.warn(String.format("Could not export diagnostics JMX bean '%s'", diagnosticsKey), (Throwable)ex);
        }
        return bean;
    }

    private DiagnosticsManager(DiagnosticsKey diagnosticsKey) {
        this.key = diagnosticsKey;
        this.counters = new ConcurrentHashMap<String, AtomicLong>();
        for (String counter : this.key.getComponentCounters()) {
            this.counters.put(counter, new AtomicLong(0L));
        }
        this.stopwatchSamples = new ArrayList<AtomicLong>();
    }

    public void setSamples(int samples) {
        this.samples = samples;
    }

    public void increment(String counter) {
        if (this.counters.containsKey(counter)) {
            AtomicLong val = (AtomicLong)this.counters.get(counter);
            val.addAndGet(1L);
        }
    }

    public void decrement(String counter) {
        if (!this.counters.containsKey(counter)) {
            logger.error("Unable to find counter " + counter);
        } else {
            AtomicLong val = (AtomicLong)this.counters.get(counter);
            val.addAndGet(-1L);
        }
    }

    private synchronized AtomicLong getAverageTime() {
        long totalTime = 0L;
        for (AtomicLong time : this.stopwatchSamples) {
            totalTime += time.get();
        }
        return new AtomicLong(totalTime / (long)this.stopwatchSamples.size());
    }

    private synchronized void addSample(AtomicLong sample) {
        if (this.stopwatchSamples.size() == this.samples) {
            this.stopwatchSamples.remove(0);
        }
        this.stopwatchSamples.add(sample);
    }

    public StopWatch createStopWatch(final String key) {
        return new StopWatch(){

            public void stop() {
                AtomicLong elapsedTime = new AtomicLong(this.getTime());
                DiagnosticsManager.this.addSample(elapsedTime);
                DiagnosticsManager.this.counters.put(key, DiagnosticsManager.this.getAverageTime());
                this.reset();
            }
        };
    }

    @Override
    public Object getAttribute(String counter) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.counters.get(counter);
    }

    @Override
    public AttributeList getAttributes(String[] keys) {
        AttributeList list = new AttributeList();
        for (String key : keys) {
            list.add(new Attribute(key, this.counters.get(key)));
        }
        return list;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        ArrayList<MBeanAttributeInfo> mbeanAttributes = new ArrayList<MBeanAttributeInfo>();
        for (Map.Entry entry : this.counters.entrySet()) {
            String id = (String)entry.getKey();
            MBeanAttributeInfo mbai = new MBeanAttributeInfo(id, ((AtomicLong)entry.getValue()).getClass().getName(), id, true, false, false);
            mbeanAttributes.add(mbai);
        }
        return new MBeanInfo(this.getClass().getName(), this.key.getComponentId(), mbeanAttributes.toArray(new MBeanAttributeInfo[0]), null, null, null);
    }

    @Override
    public Object invoke(String arg0, Object[] arg1, String[] arg2) throws MBeanException, ReflectionException {
        return this.getAttributes(new String[0]);
    }

    @Override
    public void setAttribute(Attribute arg0) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList setAttributes(AttributeList arg0) {
        return new AttributeList();
    }

    private static ObjectName createObjectName(DiagnosticsManager bean) throws MalformedObjectNameException {
        String objectName = String.format(OBJECT_FORMAT, bean.key.getComponentId(), System.identityHashCode(bean));
        return new ObjectName(objectName);
    }
}

