/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.internal.protocol.client.rpc.http.SslClientUtil;
import com.vmware.vapi.internal.protocol.client.rpc.http.VapiHostnameVerifier;
import com.vmware.vapi.protocol.HttpConfiguration;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;

public class ApacheBioHttpClientBuilder {
    private static final String HTTP_SHEME = "http";
    private static final String HTTPS_SHEME = "https";
    private PoolingHttpClientConnectionManager connManager;

    public Thread buildConnectionMonitorThread(Logger logger) {
        return new ConnectionMonitor(this.connManager, logger);
    }

    public CloseableHttpClient buildAndConfigure(final HttpConfiguration httpConfig) {
        this.connManager = this.createConnectionManager(httpConfig);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(httpConfig.getSoTimeout()).setConnectTimeout(httpConfig.getConnectTimeout()).build();
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connManager).setUserAgent("vAPI http client").setDefaultRequestConfig(requestConfig);
        builder.setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                return httpConfig.getKeepAlivePeriod();
            }
        });
        return builder.build();
    }

    private PoolingHttpClientConnectionManager createConnectionManager(HttpConfiguration httpConfig) {
        Registry<ConnectionSocketFactory> registry = this.createConnectionSocketFactoryRegistry(httpConfig.getSslConfiguration());
        PoolingHttpClientConnectionManager result = new PoolingHttpClientConnectionManager(registry);
        result.setMaxTotal(httpConfig.getMaxConnections());
        result.setDefaultMaxPerRoute(httpConfig.getMaxConnections());
        return result;
    }

    private Registry<ConnectionSocketFactory> createConnectionSocketFactoryRegistry(HttpConfiguration.SslConfiguration sslConfig) {
        RegistryBuilder builder = RegistryBuilder.create().register(HTTP_SHEME, (Object)PlainConnectionSocketFactory.INSTANCE);
        if (sslConfig != null) {
            builder.register(HTTPS_SHEME, (Object)new SSLConnectionSocketFactory(SslClientUtil.createSslContext(sslConfig), sslConfig.getEnabledProtocols(), sslConfig.getEnabledCipherSuites(), (X509HostnameVerifier)new VapiHostnameVerifier(SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER)));
        }
        return builder.build();
    }

    public static final class ConnectionMonitor
    extends Thread {
        private static final String THREAD_NAME = "vAPI-client-connection-monitor-%d";
        private static final AtomicInteger threadCount = new AtomicInteger();
        private final PoolingHttpClientConnectionManager connManager;
        private final Logger logger;

        ConnectionMonitor(PoolingHttpClientConnectionManager connManager, Logger logger) {
            super(String.format(THREAD_NAME, threadCount.getAndIncrement()));
            assert (connManager != null);
            this.connManager = connManager;
            this.logger = logger;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (!this.isInterrupted()) {
                    ConnectionMonitor.sleep(10000L);
                    this.connManager.closeExpiredConnections();
                }
            }
            catch (InterruptedException e) {
                this.logger.debug("Interrupted, no more connection pool cleanups will be performed.");
            }
        }
    }
}

