/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.common.http.impl;

import com.vmware.vapi.internal.protocol.common.http.BinaryInput;
import java.nio.ByteBuffer;
import org.apache.commons.lang.Validate;

public final class ByteBufferBinaryInput
implements BinaryInput {
    private final ByteBuffer buffer;

    public ByteBufferBinaryInput(ByteBuffer buffer) {
        Validate.notNull((Object)buffer);
        this.buffer = buffer;
    }

    @Override
    public int read() {
        if (this.buffer.remaining() > 0) {
            return this.buffer.get();
        }
        return -2;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int remaining = this.buffer.remaining();
        if (remaining > 0) {
            int effectiveLen = Math.min(len, remaining);
            this.buffer.get(b, off, effectiveLen);
            return effectiveLen;
        }
        return -2;
    }
}

